/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fieldindex;

import com.db4o.foundation.Iterator4;
import com.db4o.internal.fieldindex.FieldIndexProcessorResult;
import com.db4o.internal.fieldindex.IndexedNode;
import com.db4o.internal.fieldindex.IndexedNodeCollector;
import com.db4o.internal.query.processor.QCandidates;

public class FieldIndexProcessor {
    private final QCandidates _candidates;

    public FieldIndexProcessor(QCandidates candidates) {
        this._candidates = candidates;
    }

    public FieldIndexProcessorResult run() {
        IndexedNode bestIndex = this.selectBestIndex();
        if (null == bestIndex) {
            return FieldIndexProcessorResult.NO_INDEX_FOUND;
        }
        if (bestIndex.resultSize() > 0) {
            IndexedNode resolved = this.resolveFully(bestIndex);
            if (null == resolved) {
                return FieldIndexProcessorResult.NO_INDEX_FOUND;
            }
            return new FieldIndexProcessorResult(resolved);
        }
        return FieldIndexProcessorResult.FOUND_INDEX_BUT_NO_MATCH;
    }

    private IndexedNode resolveFully(IndexedNode bestIndex) {
        if (null == bestIndex) {
            return null;
        }
        if (bestIndex.isResolved()) {
            return bestIndex;
        }
        return this.resolveFully(bestIndex.resolve());
    }

    public IndexedNode selectBestIndex() {
        Iterator4 i = this.collectIndexedNodes();
        if (!i.moveNext()) {
            return null;
        }
        IndexedNode best = (IndexedNode)i.current();
        while (i.moveNext()) {
            IndexedNode leaf = (IndexedNode)i.current();
            if (leaf.resultSize() >= best.resultSize()) continue;
            best = leaf;
        }
        return best;
    }

    public Iterator4 collectIndexedNodes() {
        return new IndexedNodeCollector(this._candidates).getNodes();
    }
}

