/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.io;

import com.db4o.io.IoAdapter;

public class IoAdapterWindow {
    private IoAdapter _io;
    private int _blockOff;
    private int _len;
    private boolean _disabled;

    public IoAdapterWindow(IoAdapter io, int blockOff, int len) {
        this._io = io;
        this._blockOff = blockOff;
        this._len = len;
        this._disabled = false;
    }

    public int length() {
        return this._len;
    }

    public void write(int off, byte[] data) throws IllegalArgumentException, IllegalStateException {
        this.checkBounds(off, data);
        this._io.blockSeek(this._blockOff + off);
        this._io.write(data);
    }

    public int read(int off, byte[] data) throws IllegalArgumentException, IllegalStateException {
        this.checkBounds(off, data);
        this._io.blockSeek(this._blockOff + off);
        return this._io.read(data);
    }

    public void disable() {
        this._disabled = true;
    }

    public void flush() {
        if (!this._disabled) {
            this._io.sync();
        }
    }

    private void checkBounds(int off, byte[] data) {
        if (this._disabled) {
            throw new IllegalStateException();
        }
        if (data == null || off < 0 || off + data.length > this._len) {
            throw new IllegalArgumentException();
        }
    }
}

