/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.compat.DbCompat;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Transaction;
import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.Mutation;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.ConverterReader;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistCatalog;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.Store;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Evolver {
    static final int EVOLVE_NONE = 0;
    static final int EVOLVE_NEEDED = 1;
    static final int EVOLVE_FAILURE = 2;
    private PersistCatalog catalog;
    private String storePrefix;
    private Mutations mutations;
    private Map<String, Format> newFormats;
    private boolean forceEvolution;
    private boolean disallowClassChanges;
    private boolean nestedFormatsChanged;
    private Map<Format, Format> changedFormats;
    private StringBuilder errors;
    private Set<String> deleteDbs;
    private Map<String, String> renameDbs;
    private Map<Format, Format> renameFormats;
    private Map<Integer, Boolean> evolvedFormats;
    private List<Format> unprocessedFormats;
    private Map<Format, Set<Format>> subclassMap;

    Evolver(PersistCatalog catalog, String storePrefix, Mutations mutations, Map<String, Format> newFormats, boolean forceEvolution, boolean disallowClassChanges) {
        this.catalog = catalog;
        this.storePrefix = storePrefix;
        this.mutations = mutations;
        this.newFormats = newFormats;
        this.forceEvolution = forceEvolution;
        this.disallowClassChanges = disallowClassChanges;
        this.changedFormats = new IdentityHashMap<Format, Format>();
        this.errors = new StringBuilder();
        this.deleteDbs = new HashSet<String>();
        this.renameDbs = new HashMap<String, String>();
        this.renameFormats = new IdentityHashMap<Format, Format>();
        this.evolvedFormats = new HashMap<Integer, Boolean>();
        this.unprocessedFormats = new ArrayList<Format>();
        this.subclassMap = catalog.getSubclassMap();
    }

    final Mutations getMutations() {
        return this.mutations;
    }

    boolean areFormatsChanged() {
        return !this.changedFormats.isEmpty();
    }

    boolean isFormatChanged(Format format) {
        return this.changedFormats.containsKey(format);
    }

    private void setFormatsChanged(Format oldFormat) {
        this.checkClassChangesAllowed(oldFormat);
        this.changedFormats.put(oldFormat, oldFormat);
        this.nestedFormatsChanged = true;
        if (PersistCatalog.expectNoClassChanges) {
            throw new IllegalStateException("expectNoClassChanges");
        }
    }

    private void checkClassChangesAllowed(Format oldFormat) {
        if (this.disallowClassChanges) {
            throw new IllegalStateException("When performing an upgrade changes are not allowed but were made to: " + oldFormat.getClassName());
        }
    }

    Set<Format> getSubclassFormats(Format superFormat) {
        return this.subclassMap.get(superFormat);
    }

    String getErrors() {
        if (this.errors.length() > 0) {
            return this.errors.toString();
        }
        return null;
    }

    private void addError(String error) {
        if (this.errors.length() > 0) {
            this.errors.append("\n---\n");
        }
        this.errors.append(error);
    }

    private String getClassVersionLabel(Format format, String prefix) {
        if (format != null) {
            return prefix + " class: " + format.getClassName() + " version: " + format.getVersion();
        }
        return "";
    }

    void addEvolveError(Format oldFormat, Format newFormat, String scenario, String error) {
        this.checkClassChangesAllowed(oldFormat);
        if (scenario == null) {
            scenario = "Error";
        }
        this.addError(scenario + " when evolving" + this.getClassVersionLabel(oldFormat, "") + this.getClassVersionLabel(newFormat, " to") + " Error: " + error);
    }

    void addInvalidMutation(Format oldFormat, Format newFormat, Mutation mutation, String error) {
        this.checkClassChangesAllowed(oldFormat);
        this.addError("Invalid mutation: " + mutation + this.getClassVersionLabel(oldFormat, " For") + this.getClassVersionLabel(newFormat, " New") + " Error: " + error);
    }

    void addMissingMutation(Format oldFormat, Format newFormat, String error) {
        this.checkClassChangesAllowed(oldFormat);
        this.addError("Mutation is missing to evolve" + this.getClassVersionLabel(oldFormat, "") + this.getClassVersionLabel(newFormat, " to") + " Error: " + error);
    }

    void addNonEntityFormat(Format oldFormat) {
        this.unprocessedFormats.add(oldFormat);
    }

    void finishEvolution() {
        for (Format oldFormat : this.unprocessedFormats) {
            oldFormat.setUnused(true);
            Integer oldFormatId = oldFormat.getId();
            if (this.evolvedFormats.containsKey(oldFormatId)) continue;
            this.evolvedFormats.put(oldFormatId, true);
            boolean result = this.evolveFormatInternal(oldFormat);
            this.evolvedFormats.put(oldFormatId, result);
        }
    }

    boolean evolveFormat(Format oldFormat) {
        boolean result;
        Integer oldFormatId;
        boolean trackEntityChanges = oldFormat.getLatestVersion().getEntityFormat() != null;
        boolean saveNestedFormatsChanged = this.nestedFormatsChanged;
        if (trackEntityChanges) {
            this.nestedFormatsChanged = false;
        }
        if (this.evolvedFormats.containsKey(oldFormatId = Integer.valueOf(oldFormat.getId()))) {
            result = this.evolvedFormats.get(oldFormatId);
        } else {
            this.evolvedFormats.put(oldFormatId, true);
            result = this.evolveFormatInternal(oldFormat);
            this.evolvedFormats.put(oldFormatId, result);
        }
        if (oldFormat.getLatestVersion().isNew()) {
            this.nestedFormatsChanged = true;
        }
        if (trackEntityChanges) {
            Format latest;
            if (this.nestedFormatsChanged && (latest = oldFormat.getLatestVersion().getEntityFormat()) != null) {
                latest.setEvolveNeeded(true);
            }
            this.nestedFormatsChanged = saveNestedFormatsChanged;
        }
        return result;
    }

    private boolean evolveFormatInternal(Format oldFormat) {
        boolean needDeleter;
        String newFormatException;
        Format newFormat;
        String newName;
        if (Format.isPredefined(oldFormat) || oldFormat.isDeleted()) {
            return true;
        }
        String oldName = oldFormat.getClassName();
        int oldVersion = oldFormat.getVersion();
        Renamer renamer = this.mutations.getRenamer(oldName, oldVersion, null);
        Deleter deleter = this.mutations.getDeleter(oldName, oldVersion, null);
        Converter converter = this.mutations.getConverter(oldName, oldVersion, null);
        if (deleter != null && (converter != null || renamer != null)) {
            this.addInvalidMutation(oldFormat, null, deleter, "Class Deleter not allowed along with a Renamer or Converter for the same class");
            return false;
        }
        if (oldFormat.isArray()) {
            if (deleter != null || converter != null || renamer != null) {
                Deleter mutation = deleter != null ? deleter : (converter != null ? converter : renamer);
                this.addInvalidMutation(oldFormat, null, mutation, "Mutations not allowed for an array");
                return false;
            }
            Format compFormat = oldFormat.getComponentType();
            if (!this.evolveFormat(compFormat)) {
                return false;
            }
            Format latest = compFormat.getLatestVersion();
            newName = latest != compFormat ? (latest.isArray() ? "[" : "[L") + latest.getClassName() + ';' : oldName;
        } else {
            newName = renamer != null ? renamer.getNewName() : oldName;
        }
        try {
            Class newClass = SimpleCatalog.classForName(newName);
            try {
                newFormat = this.catalog.createFormat(newClass, this.newFormats);
                assert (newFormat != oldFormat) : newFormat.getClassName();
                newFormatException = null;
            }
            catch (Exception e) {
                newFormat = null;
                newFormatException = e.toString();
            }
        }
        catch (ClassNotFoundException e) {
            newFormat = null;
            newFormatException = e.toString();
        }
        if (newFormat != null) {
            if (oldFormat != oldFormat.getLatestVersion() && newFormat.getPreviousVersion() == null) {
                assert (this.newFormats.containsValue(newFormat));
                Format oldLatestFormat = oldFormat.getLatestVersion();
                this.evolveFormat(oldLatestFormat);
                if (oldLatestFormat == oldLatestFormat.getLatestVersion()) {
                    assert (!this.newFormats.containsValue(newFormat));
                    newFormat = oldLatestFormat;
                }
            }
            if (!this.forceEvolution && newFormat == oldFormat.getLatestVersion()) {
                return true;
            }
        }
        if (renamer != null && !this.applyClassRenamer(renamer, oldFormat, newFormat)) {
            return false;
        }
        if (converter != null) {
            if (oldFormat.isEntity()) {
                if (newFormat == null || !newFormat.isEntity()) {
                    this.addInvalidMutation(oldFormat, newFormat, deleter, "Class converter not allowed for an entity class that is no longer present or not having an @Entity annotation");
                    return false;
                }
                if (!oldFormat.evolveMetadata(newFormat, converter, this)) {
                    return false;
                }
            }
            return this.applyConverter(converter, oldFormat, newFormat);
        }
        boolean bl = needDeleter = newFormat == null || newFormat.isEntity() != oldFormat.isEntity();
        if (deleter != null) {
            if (!needDeleter) {
                this.addInvalidMutation(oldFormat, newFormat, deleter, "Class deleter not allowed when the class and its @Entity or @Persistent annotation is still present");
                return false;
            }
            return this.applyClassDeleter(deleter, oldFormat, newFormat);
        }
        if (needDeleter) {
            if (newFormat == null) {
                assert (newFormatException != null);
                this.addMissingMutation(oldFormat, newFormat, newFormatException);
            } else {
                this.addMissingMutation(oldFormat, newFormat, "@Entity switched to/from @Persistent");
            }
            return false;
        }
        return oldFormat.evolve(newFormat, this);
    }

    void useOldFormat(Format oldFormat, Format newFormat) {
        Format renamedFormat = this.renameFormats.get(oldFormat);
        if (renamedFormat != null) {
            assert (renamedFormat == newFormat);
            this.useEvolvedFormat(oldFormat, renamedFormat, renamedFormat);
        } else if (newFormat != null && oldFormat.getVersion() != newFormat.getVersion()) {
            this.useEvolvedFormat(oldFormat, newFormat, newFormat);
        } else {
            this.catalog.useExistingFormat(oldFormat);
            if (newFormat != null) {
                this.newFormats.remove(newFormat.getClassName());
            }
        }
    }

    void useEvolvedFormat(Format oldFormat, Reader evolveReader, Format newFormat) {
        oldFormat.setReader(evolveReader);
        if (newFormat != null) {
            oldFormat.setLatestVersion(newFormat);
        }
        this.setFormatsChanged(oldFormat);
    }

    private boolean applyClassRenamer(Renamer renamer, Format oldFormat, Format newFormat) {
        if (!this.checkUpdatedVersion(renamer, oldFormat, newFormat)) {
            return false;
        }
        if (oldFormat.isEntity() && oldFormat.isCurrentVersion()) {
            String newClassName = newFormat.getClassName();
            String oldClassName = oldFormat.getClassName();
            this.renameDbs.put(Store.makePriDbName(this.storePrefix, oldClassName), Store.makePriDbName(this.storePrefix, newClassName));
            for (SecondaryKeyMetadata keyMeta : oldFormat.getEntityMetadata().getSecondaryKeys().values()) {
                String keyName = keyMeta.getKeyName();
                this.renameDbs.put(Store.makeSecDbName(this.storePrefix, oldClassName, keyName), Store.makeSecDbName(this.storePrefix, newClassName, keyName));
            }
        }
        this.renameFormats.put(oldFormat, newFormat);
        this.setFormatsChanged(oldFormat);
        return true;
    }

    void renameSecondaryDatabase(String oldEntityClass, String newEntityClass, String oldKeyName, String newKeyName) {
        this.renameDbs.put(Store.makeSecDbName(this.storePrefix, oldEntityClass, oldKeyName), Store.makeSecDbName(this.storePrefix, newEntityClass, newKeyName));
    }

    private boolean applyClassDeleter(Deleter deleter, Format oldFormat, Format newFormat) {
        if (!this.checkUpdatedVersion(deleter, oldFormat, newFormat)) {
            return false;
        }
        if (oldFormat.isEntity() && oldFormat.isCurrentVersion()) {
            String className = oldFormat.getClassName();
            this.deleteDbs.add(Store.makePriDbName(this.storePrefix, className));
            for (SecondaryKeyMetadata keyMeta : oldFormat.getEntityMetadata().getSecondaryKeys().values()) {
                this.deleteDbs.add(Store.makeSecDbName(this.storePrefix, className, keyMeta.getKeyName()));
            }
        }
        oldFormat.setDeleted(true);
        if (newFormat != null) {
            oldFormat.setLatestVersion(newFormat);
        }
        this.setFormatsChanged(oldFormat);
        return true;
    }

    void deleteSecondaryDatabase(String oldEntityClass, String keyName) {
        this.deleteDbs.add(Store.makeSecDbName(this.storePrefix, oldEntityClass, keyName));
    }

    private boolean applyConverter(Converter converter, Format oldFormat, Format newFormat) {
        if (!this.checkUpdatedVersion(converter, oldFormat, newFormat)) {
            return false;
        }
        ConverterReader reader = new ConverterReader(converter);
        this.useEvolvedFormat(oldFormat, reader, newFormat);
        return true;
    }

    boolean isClassConverted(Format format) {
        return format.getReader() instanceof ConverterReader;
    }

    private boolean checkUpdatedVersion(Mutation mutation, Format oldFormat, Format newFormat) {
        if (newFormat != null && !oldFormat.isEnum() && newFormat.getVersion() <= oldFormat.getVersion()) {
            this.addInvalidMutation(oldFormat, newFormat, mutation, "A new higher version number must be assigned");
            return false;
        }
        return true;
    }

    boolean checkUpdatedVersion(String scenario, Format oldFormat, Format newFormat) {
        if (newFormat != null && !oldFormat.isEnum() && newFormat.getVersion() <= oldFormat.getVersion()) {
            this.addEvolveError(oldFormat, newFormat, scenario, "A new higher version number must be assigned");
            return false;
        }
        return true;
    }

    void renameAndRemoveDatabases(Store store, Transaction txn) throws DatabaseException {
        for (String string : this.deleteDbs) {
            try {
                String[] fileAndDbNames = store.parseDbName(string);
                DbCompat.removeDatabase(store.getEnvironment(), txn, fileAndDbNames[0], fileAndDbNames[1]);
            }
            catch (DatabaseNotFoundException ignored) {
            }
            catch (FileNotFoundException ignored) {}
        }
        for (Map.Entry entry : this.renameDbs.entrySet()) {
            String oldName = (String)entry.getKey();
            String newName = (String)entry.getValue();
            try {
                String[] oldFileAndDbNames = store.parseDbName(oldName);
                String[] newFileAndDbNames = store.parseDbName(newName);
                DbCompat.renameDatabase(store.getEnvironment(), txn, oldFileAndDbNames[0], oldFileAndDbNames[1], newFileAndDbNames[0], newFileAndDbNames[1]);
            }
            catch (DatabaseNotFoundException ignored) {
            }
            catch (FileNotFoundException ignored) {}
        }
    }

    int evolveRequiredKeyField(Format oldParent, Format newParent, FieldInfo oldField, FieldInfo newField) {
        int result = 0;
        String oldName = oldField.getName();
        String FIELD_KIND = "primary key field or composite key class field";
        String FIELD_LABEL = "primary key field or composite key class field: " + oldName;
        if (newField == null) {
            this.addMissingMutation(oldParent, newParent, "Field is missing and deletion is not allowed for a " + FIELD_LABEL);
            return 2;
        }
        Deleter deleter = this.mutations.getDeleter(oldParent.getClassName(), oldParent.getVersion(), oldName);
        if (deleter != null) {
            this.addInvalidMutation(oldParent, newParent, deleter, "Deleter is not allowed for a " + FIELD_LABEL);
            return 2;
        }
        Converter converter = this.mutations.getConverter(oldParent.getClassName(), oldParent.getVersion(), oldName);
        if (converter != null) {
            this.addInvalidMutation(oldParent, newParent, converter, "Converter is not allowed for a " + FIELD_LABEL);
            return 2;
        }
        Renamer renamer = this.mutations.getRenamer(oldParent.getClassName(), oldParent.getVersion(), oldName);
        String newName = newField.getName();
        if (renamer != null) {
            if (!renamer.getNewName().equals(newName)) {
                this.addInvalidMutation(oldParent, newParent, converter, "Converter is not allowed for a " + FIELD_LABEL);
                return 2;
            }
            result = 1;
        } else if (!oldName.equals(newName)) {
            this.addMissingMutation(oldParent, newParent, "Renamer is required when field name is changed from: " + oldName + " to: " + newName);
            return 2;
        }
        Format oldFieldFormat = oldField.getType();
        if (!this.evolveFormat(oldFieldFormat)) {
            return 2;
        }
        Format oldLatestFormat = oldFieldFormat.getLatestVersion();
        Format newFieldFormat = newField.getType();
        if (oldLatestFormat.getClassName().equals(newFieldFormat.getClassName())) {
            return result;
        }
        if (oldLatestFormat.getWrapperFormat() != null && oldLatestFormat.getWrapperFormat().getId() == newFieldFormat.getId() || newFieldFormat.getWrapperFormat() != null && newFieldFormat.getWrapperFormat().getId() == oldLatestFormat.getId()) {
            return 1;
        }
        this.addEvolveError(oldParent, newParent, "Type may not be changed for a primary key field or composite key class field", "Old field type: " + oldLatestFormat.getClassName() + " is not compatible with the new type: " + newFieldFormat.getClassName() + " for field: " + oldName);
        return 2;
    }
}

