/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index;

public abstract class TermEntry
implements Comparable<TermEntry> {
    static final long serialVersionUID = -994850524944312820L;
    public final String subj;
    public final float rel;

    public TermEntry(String s, float r) {
        if (s == null) {
            throw new IllegalArgumentException("can't have a null subject!");
        }
        if (r < 0.0f) {
            throw new IllegalArgumentException("Relevance must be in the half-closed interval (0,1]. Supplied: " + r);
        }
        this.subj = s.intern();
        this.rel = r;
    }

    public TermEntry(TermEntry t, float newRel) {
        this.subj = t.subj;
        this.rel = newRel;
    }

    public abstract EntryType entryType();

    @Override
    public int compareTo(TermEntry o) {
        if (this == o) {
            return 0;
        }
        int c = this.subj.compareTo(o.subj);
        if (c != 0) {
            return c;
        }
        if (this.rel != o.rel) {
            return this.rel > o.rel ? -1 : 1;
        }
        EntryType a = this.entryType();
        EntryType b = o.entryType();
        return a.compareTo(b);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TermEntry en = (TermEntry)o;
        return this.rel == en.rel && this.subj.equals(en.subj);
    }

    public abstract boolean equalsTarget(TermEntry var1);

    public int hashCode() {
        return this.subj.hashCode() ^ Float.floatToIntBits(this.rel);
    }

    public String toString() {
        return this.subj + ":" + this.rel;
    }

    public static enum EntryType {
        INDEX,
        TERM,
        PAGE;

    }
}

