/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.ui;

import freenet.keys.FreenetURI;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import freenet.support.MultiValueTable;
import freenet.support.api.HTTPRequest;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import plugins.Library.Library;
import plugins.Library.index.TermEntry;
import plugins.Library.search.InvalidSearchException;
import plugins.Library.search.Search;
import plugins.Library.ui.L10nString;
import plugins.Library.ui.ResultNodeGenerator;
import plugins.Library.util.exec.ChainedProgress;
import plugins.Library.util.exec.CompositeProgress;
import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.TaskAbortException;

class MainPage {
    private static final HashMap<Integer, MainPage> searchPages = new HashMap();
    private final Library library;
    private final PluginRespirator pr;
    private Search search = null;
    private ArrayList<Exception> exceptions = new ArrayList();
    private boolean showold = false;
    private boolean js = false;
    private String query = "";
    private String indexstring = "bookmark:liberty-of-information bookmark:free-market-free-people bookmark:gotcha bookmark:wanna bookmark:wanna.old bookmark:gogo";
    private ArrayList<String> selectedBMIndexes = new ArrayList();
    private ArrayList<String> selectedOtherIndexes = new ArrayList();
    private boolean groupusk = false;
    private StringBuilder messages = new StringBuilder();
    private String addindexname = "";
    private String addindexuri = "";
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;

    private static synchronized void addpage(int hashCode, MainPage page) {
        searchPages.put(hashCode, page);
    }

    private static synchronized void cleanUpPages() {
        Iterator<Integer> it = searchPages.keySet().iterator();
        while (it.hasNext()) {
            if (Search.hasSearch(it.next())) continue;
            it.remove();
        }
    }

    private static synchronized MainPage getPage(int intParam) {
        return searchPages.get(intParam);
    }

    MainPage(Exception e, Library library, PluginRespirator pr) {
        this.exceptions.add(e);
        this.library = library;
        this.pr = pr;
    }

    MainPage(Library library, PluginRespirator pr) {
        this.library = library;
        this.pr = pr;
    }

    public static MainPage processGetRequest(HTTPRequest request) {
        if (request.isParameterSet("request") && searchPages.containsKey(request.getIntParam("request"))) {
            return MainPage.getPage(request.getIntParam("request"));
        }
        return null;
    }

    public static MainPage processPostRequest(HTTPRequest request, HTMLNode contentNode, boolean hasFormPassword, boolean userAccess, Library library, PluginRespirator pr) {
        MainPage page;
        block21: {
            block22: {
                MainPage.cleanUpPages();
                page = new MainPage(library, pr);
                page.js = request.isPartSet("js");
                page.showold = request.isPartSet("showold");
                page.groupusk = request.isPartSet("groupusk");
                String[] etcIndexes = request.getPartAsStringFailsafe("indexuris", 256).trim().split("[ ;]");
                page.query = request.getPartAsStringFailsafe("search", 256);
                if (userAccess) {
                    page.addindexname = request.getPartAsStringFailsafe("addindexname", 32);
                    page.addindexuri = request.getPartAsStringFailsafe("addindexuri", 256);
                }
                page.indexstring = "";
                for (String bm : library.bookmarkKeys()) {
                    String bmid = ("bookmark:" + bm).trim();
                    if (!request.isPartSet("~" + bm)) continue;
                    page.indexstring = page.indexstring + bmid + " ";
                    page.selectedBMIndexes.add(bmid);
                }
                for (int i = 0; i < request.getIntPart("extraindexcount", 0); ++i) {
                    if (!request.isPartSet("index" + i)) continue;
                    String otherindexuri = request.getPartAsStringFailsafe("index" + i, 256);
                    page.indexstring = page.indexstring + otherindexuri + " ";
                    page.selectedOtherIndexes.add(otherindexuri);
                }
                for (String string : etcIndexes) {
                    if (string.length() <= 0) continue;
                    page.indexstring = page.indexstring + string + " ";
                    page.selectedOtherIndexes.add(string);
                }
                page.indexstring = page.indexstring.trim();
                if ("".equals(page.indexstring)) {
                    page.indexstring = "bookmark:liberty-of-information bookmark:free-market-free-people bookmark:gotcha bookmark:wanna bookmark:wanna.old bookmark:gogo";
                }
                if (page.selectedBMIndexes.size() == 0 && page.selectedOtherIndexes.size() == 0) {
                    page.selectedBMIndexes.add("bookmark:liberty-of-information bookmark:free-market-free-people bookmark:gotcha bookmark:wanna bookmark:wanna.old bookmark:gogo");
                }
                if (!request.isPartSet(Commands.find.toString())) break block22;
                if (!hasFormPassword) break block21;
                try {
                    if (logMINOR) {
                        Logger.minor(MainPage.class, (String)("starting search for " + page.query + " on " + page.indexstring));
                    }
                    page.search = Search.startSearch(page.query, page.indexstring);
                    if (page.search == null) {
                        page.messages.append("Stopwords too prominent in search term, try removing words like 'the', 'and' and 'that' and any words less than 3 characters");
                        break block21;
                    }
                    page.search.setMakeResultNode(page.groupusk, page.showold, true);
                    MainPage.addpage(page.search.hashCode(), page);
                }
                catch (InvalidSearchException ex) {
                    page.messages.append("Problem with search : " + ex.getLocalizedMessage() + "\n");
                }
                catch (TaskAbortException ex) {
                    page.exceptions.add(ex);
                }
                catch (RuntimeException ex) {
                    page.exceptions.add(ex);
                }
                break block21;
            }
            if (request.isPartSet(Commands.addbookmark.toString())) {
                try {
                    if (userAccess && hasFormPassword && page.addindexname.length() > 0 && URLEncoder.encode(page.addindexname, "UTF-8").equals(page.addindexname)) {
                        library.addBookmark(page.addindexname, page.addindexuri);
                        if (page.selectedOtherIndexes.contains(page.addindexuri)) {
                            page.selectedOtherIndexes.remove(page.addindexuri);
                            page.selectedBMIndexes.add("bookmark:" + page.addindexname);
                        }
                        page.addindexname = "";
                        page.addindexuri = "";
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    Logger.error((Object)page, (String)"Encoding error", (Throwable)ex);
                }
            } else {
                for (int i = 0; i < request.getIntPart("extraindexcount", 0); ++i) {
                    if (!request.isPartSet(Commands.addindex.toString() + i)) continue;
                    page.addindexuri = request.getPartAsStringFailsafe("index" + i, 256);
                }
                if (userAccess && hasFormPassword) {
                    for (String bm : library.bookmarkKeys()) {
                        if (!request.isPartSet((Object)((Object)Commands.removebookmark) + bm)) continue;
                        library.removeBookmark(bm);
                        break;
                    }
                }
            }
        }
        return page;
    }

    public void writeContent(HTMLNode contentNode, MultiValueTable<String, String> headers) {
        HTMLNode errorDiv = contentNode.addChild("div", "id", "errors");
        for (Exception exception : this.exceptions) {
            MainPage.addError(errorDiv, exception, this.messages);
        }
        try {
            contentNode.addChild("script", new String[]{"type", "src"}, new String[]{"text/javascript", "/library/static/script.js"}).addChild("%", " ");
            String refreshURL = null;
            if (this.search != null) {
                refreshURL = MainPage.path() + "?request=" + this.search.hashCode();
            }
            if (this.search == null) {
                contentNode.addChild("#", L10nString.getString("page-warning"));
            }
            contentNode.addChild(this.searchBox());
            if (this.search != null) {
                contentNode.addChild(this.progressBox());
                if (this.search.isDone()) {
                    if (this.search.hasGeneratedResultNode()) {
                        contentNode.addChild(this.search.getHTMLNode());
                    } else {
                        try {
                            ResultNodeGenerator nodegenerator = new ResultNodeGenerator((Set<TermEntry>)this.search.getResult(), this.groupusk, this.showold, true);
                            nodegenerator.run();
                            contentNode.addChild(nodegenerator.getPageEntryNode());
                        }
                        catch (TaskAbortException ex) {
                            this.exceptions.add(ex);
                        }
                        catch (RuntimeException ex) {
                            this.exceptions.add(ex);
                        }
                    }
                } else {
                    contentNode.addChild("div", "id", "results").addChild("#");
                }
            }
            if (!(this.search == null || "".equals(this.search.getQuery()) || this.search.isDone() || this.exceptions.size() > 0 || this.js)) {
                headers.put((Object)"Refresh", (Object)("2;url=" + refreshURL));
            }
        }
        catch (TaskAbortException e) {
            if (this.search != null) {
                this.search.remove();
            }
            this.exceptions.add(e);
            this.search = null;
            MainPage.addError(errorDiv, e, this.messages);
        }
        errorDiv.addChild("p", this.messages.toString());
    }

    private HTMLNode searchBox() {
        HTMLNode searchDiv = new HTMLNode("div", new String[]{"id", "style"}, new String[]{"searchbar", "text-align: center;"});
        if (this.pr != null) {
            HTMLNode searchForm = this.pr.addFormChild(searchDiv, MainPage.path(), "searchform");
            HTMLNode searchBox = searchForm.addChild("div", "style", "display: inline-table; text-align: left; margin: 20px 20px 20px 0px;");
            searchBox.addChild("#", "Search query:");
            searchBox.addChild("br");
            searchBox.addChild("input", new String[]{"name", "size", "type", "value", "title"}, new String[]{"search", "40", "text", this.query, "Enter a search query. You can use standard search syntax such as 'and', 'or', 'not' and \"\" double quotes around phrases"});
            searchBox.addChild("input", new String[]{"name", "type", "value", "tabindex"}, new String[]{"find", "submit", "Find!", "1"});
            if (this.js) {
                searchBox.addChild("input", new String[]{"type", "name"}, new String[]{"hidden", "js"});
            }
            HTMLNode indexeslist = searchBox.addChild("ul", "class", "index-bookmark-list", "Select indexes");
            for (String bm : this.library.bookmarkKeys()) {
                HTMLNode bmItem = indexeslist.addChild("li");
                bmItem.addChild("input", new String[]{"name", "type", "value", "title", this.selectedBMIndexes.contains("bookmark:" + bm) ? "checked" : "size"}, new String[]{"~" + bm, "checkbox", "bookmark:" + bm, "Index uri : " + this.library.getBookmark(bm), "1"}, bm);
                bmItem.addChild("input", new String[]{"name", "type", "value", "title", "class"}, new String[]{(Object)((Object)Commands.removebookmark) + bm, "submit", "X", "Delete this bookmark", "index-bookmark-delete"});
            }
            int i = 0;
            for (String uri : this.selectedOtherIndexes) {
                String showuri;
                HTMLNode removeItem = indexeslist.addChild("li");
                try {
                    showuri = new FreenetURI(uri).toShortString();
                }
                catch (MalformedURLException e) {
                    showuri = uri;
                }
                removeItem.addChild("input", new String[]{"type", "name", "value", "checked"}, new String[]{"checkbox", "index" + i, uri, "checked"}, showuri);
                removeItem.addChild("input", new String[]{"name", "type", "value"}, new String[]{Commands.addindex.toString() + i, "submit", "Add=>"});
                ++i;
            }
            indexeslist.addChild("input", new String[]{"name", "type", "value"}, new String[]{"extraindexcount", "hidden", "" + this.selectedOtherIndexes.size()});
            indexeslist.addChild("li").addChild("input", new String[]{"name", "type", "value", "class", "title"}, new String[]{"indexuris", "text", "", "index", "URI or path of other index(s) to search on"});
            HTMLNode optionsBox = searchForm.addChild("div", "style", "margin: 20px 0px 20px 20px; display: inline-table; text-align: left;", "Options");
            HTMLNode optionsList = optionsBox.addChild("ul", "class", "options-list");
            optionsList.addChild("li").addChild("input", new String[]{"name", "type", this.groupusk ? "checked" : "size", "title"}, new String[]{"groupusk", "checkbox", "1", "If set, the results are returned grouped by site and edition, this makes the results quicker to scan through but will disrupt ordering on relevance, if applicable to the indexs you are using."}, "Group sites and editions");
            optionsList.addChild("li").addChild("input", new String[]{"name", "type", this.showold ? "checked" : "size", "title"}, new String[]{"showold", "checkbox", "1", "If set, older editions are shown in the results greyed out, otherwise only the most recent are shown."}, "Show older editions");
            HTMLNode newIndexInput = optionsBox.addChild("div", new String[]{"class", "style"}, new String[]{"index", "display: inline-table;"}, "Add an index:");
            newIndexInput.addChild("br");
            newIndexInput.addChild("div", "style", "display: inline-block; width: 50px;", "Name:");
            newIndexInput.addChild("input", new String[]{"name", "type", "class", "title", "value"}, new String[]{"addindexname", "text", "index", "Name of the bookmark, this will appear in the list to the left", this.addindexname});
            newIndexInput.addChild("br");
            newIndexInput.addChild("div", "style", "display: inline-block; width: 50px;", "URI:");
            newIndexInput.addChild("input", new String[]{"name", "type", "class", "title", "value"}, new String[]{"addindexuri", "text", "index", "URI or path of index to add to bookmarks, including the main index filename at the end of a Freenet uri will help Library not to block in order to discover the index type.", this.addindexuri});
            newIndexInput.addChild("br");
            newIndexInput.addChild("input", new String[]{"name", "type", "value"}, new String[]{"addbookmark", "submit", "Add Bookmark"});
        } else {
            searchDiv.addChild("#", "No PluginRespirater, so Form cannot be displayed");
        }
        return searchDiv;
    }

    private HTMLNode progressBox() throws TaskAbortException {
        HTMLNode progressDiv = new HTMLNode("div", "id", "progress");
        HTMLNode progressTable = progressDiv.addChild("table", "width", "100%");
        HTMLNode searchingforCell = progressTable.addChild("tr").addChild("td");
        searchingforCell.addChild("#", L10nString.getString("Searching-for"));
        searchingforCell.addChild("span", "class", "librarian-searching-for-target").addChild("b", this.query);
        searchingforCell.addChild("#", L10nString.getString("in-index"));
        searchingforCell.addChild("i", this.indexstring);
        HTMLNode statusRow = progressTable.addChild("tr");
        statusRow.addChild("td").addChild("div", "id", "librarian-search-status").addChild("table", new String[]{"id", "class"}, new String[]{"progress-base", "progress-table"}).addChild("tbody").addChild(MainPage.progressBar(this.search, true));
        return progressDiv;
    }

    public static void addError(HTMLNode node, Throwable error, StringBuilder messages) {
        if (messages != null && (error instanceof InvalidSearchException || error instanceof TaskAbortException) && !logMINOR) {
            messages.append(error.getMessage() + "\n");
        } else {
            HTMLNode error1 = node.addChild("div", "style", "padding:10px;border:5px solid gray;margin:10px", error.toString());
            for (StackTraceElement ste : error.getStackTrace()) {
                error1.addChild("br");
                error1.addChild("#", " -- " + ste.toString());
            }
            if (error.getCause() != null) {
                MainPage.addError(error1, error.getCause(), messages);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HTMLNode progressBar(Progress progress, boolean canFail) throws TaskAbortException {
        Progress progress2 = progress;
        synchronized (progress2) {
            if (progress instanceof CompositeProgress && ((CompositeProgress)progress).getSubProgress() != null && ((CompositeProgress)progress).getSubProgress().iterator().hasNext()) {
                HTMLNode block = new HTMLNode("#");
                block.addChild("tr").addChild("td", "colspan", "6", progress.getSubject() + " : " + progress.getStatus());
                TaskAbortException firstError = null;
                boolean anySuccess = false;
                if (canFail && progress instanceof Search) {
                    if (!((Search)progress).innerCanFailAndStillComplete()) {
                        canFail = false;
                    }
                } else {
                    canFail = false;
                }
                if (((CompositeProgress)progress).getSubProgress() != null) {
                    for (Progress progress3 : ((CompositeProgress)progress).getSubProgress()) {
                        try {
                            block.addChild(MainPage.progressBar(progress3, canFail));
                            anySuccess = true;
                        }
                        catch (TaskAbortException e) {
                            if (!canFail) {
                                throw e;
                            }
                            if (firstError == null) {
                                firstError = e;
                            }
                            block.addChild("tr").addChild("td", "colspan", "6", progress3.getSubject() + " : " + L10nString.getString("failed") + " : " + e.getMessage());
                        }
                    }
                }
                if (firstError != null && !anySuccess) {
                    throw firstError;
                }
                return block;
            }
            ProgressParts parts = progress instanceof ChainedProgress && ((ChainedProgress)progress).getCurrentProgress() != null ? ((ChainedProgress)progress).getCurrentProgress().getParts() : progress.getParts();
            HTMLNode bar = new HTMLNode("tr");
            bar.addChild("td");
            bar.addChild("td", progress.getSubject());
            bar.addChild("td", progress.getStatus());
            if (progress.isDone() || progress.getParts().known == 0) {
                bar.addChild("td", "");
                bar.addChild("td");
            } else {
                float fractiondone = parts.getKnownFractionDone();
                int percentage = (int)(100.0f * fractiondone);
                boolean bl = parts.finalizedTotal();
                bar.addChild("td", new String[]{"class", "style"}, new String[]{"progress-bar-outline", "padding: 0px 3px;"}).addChild("div", new String[]{"class", "style"}, new String[]{bl ? "progress-bar-inner-final" : "progress-bar-inner-nonfinal", "z-index : -1; width:" + percentage + "%;"});
                bar.addChild("td", bl ? percentage + "%" : "Operation length unknown");
            }
            return bar;
        }
    }

    public static String path() {
        return "/library/";
    }

    public String getQuery() {
        return this.query;
    }

    static {
        Logger.registerClass(MainPage.class);
    }

    private static enum Commands {
        find,
        addbookmark,
        addindex,
        removebookmark;

    }
}

