/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import plugins.Library.util.func.SafeClosure;

public class Executors {
    public static final SafeClosure<Executor> CLEANUP_EXECSERV = new SafeClosure<Executor>(){

        @Override
        public void invoke(Executor exec) {
            if (!(exec instanceof ExecutorService)) {
                return;
            }
            ExecutorService x = (ExecutorService)exec;
            x.shutdown();
            try {
                while (!x.awaitTermination(1L, TimeUnit.SECONDS)) {
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    };
    public static final Executor DEFAULT_EXECUTOR = new Executor(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(Runnable r) {
            Class<Executors> clazz = Executors.class;
            synchronized (Executors.class) {
                if (default_exec == null) {
                    default_exec = new ThreadPoolExecutor(1, 64, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), new ThreadPoolExecutor.CallerRunsPolicy());
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                default_exec.execute(r);
                return;
            }
        }
    };
    private static Executor default_exec = null;

    public static synchronized void setDefaultExecutor(Executor e) {
        default_exec = e;
    }

    private Executors() {
    }
}

