/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.confluence;

import java.util.ArrayList;
import java.util.List;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.Dialect;
import net.java.textilej.parser.markup.confluence.block.CodeBlock;
import net.java.textilej.parser.markup.confluence.block.ExtendedPreformattedBlock;
import net.java.textilej.parser.markup.confluence.block.ExtendedQuoteBlock;
import net.java.textilej.parser.markup.confluence.block.HeadingBlock;
import net.java.textilej.parser.markup.confluence.block.ListBlock;
import net.java.textilej.parser.markup.confluence.block.ParagraphBlock;
import net.java.textilej.parser.markup.confluence.block.QuoteBlock;
import net.java.textilej.parser.markup.confluence.block.TableBlock;
import net.java.textilej.parser.markup.confluence.block.TableOfContentsBlock;
import net.java.textilej.parser.markup.confluence.block.TextBoxBlock;
import net.java.textilej.parser.markup.confluence.phrase.ImagePhraseModifier;
import net.java.textilej.parser.markup.confluence.phrase.SimplePhraseModifier;
import net.java.textilej.parser.markup.confluence.phrase.SimpleWrappedPhraseModifier;
import net.java.textilej.parser.markup.confluence.token.AnchorReplacementToken;
import net.java.textilej.parser.markup.confluence.token.HyperlinkReplacementToken;
import net.java.textilej.parser.markup.token.EntityReferenceReplacementToken;
import net.java.textilej.parser.markup.token.ImpliedHyperlinkReplacementToken;
import net.java.textilej.parser.markup.token.PatternEntityReferenceReplacementToken;
import net.java.textilej.parser.markup.token.PatternLineBreakReplacementToken;
import net.java.textilej.parser.markup.token.PatternLiteralReplacementToken;

public class ConfluenceDialect
extends Dialect {
    private List<Block> blocks = new ArrayList<Block>();
    private List<Block> paragraphBreakingBlocks = new ArrayList<Block>();
    private static Dialect.PatternBasedSyntax tokenSyntax = new Dialect.PatternBasedSyntax();
    private static Dialect.PatternBasedSyntax phraseModifierSyntax = new Dialect.PatternBasedSyntax();

    @Override
    protected Dialect.PatternBasedSyntax getPhraseModifierSyntax() {
        return phraseModifierSyntax;
    }

    @Override
    protected Dialect.PatternBasedSyntax getReplacementTokenSyntax() {
        return tokenSyntax;
    }

    public ConfluenceDialect() {
        HeadingBlock headingBlock = new HeadingBlock();
        this.blocks.add(headingBlock);
        this.paragraphBreakingBlocks.add(headingBlock);
        ListBlock listBlock = new ListBlock();
        this.blocks.add(listBlock);
        this.paragraphBreakingBlocks.add(listBlock);
        this.blocks.add(new QuoteBlock());
        TableBlock tableBlock = new TableBlock();
        this.blocks.add(tableBlock);
        this.paragraphBreakingBlocks.add(tableBlock);
        ExtendedQuoteBlock quoteBlock = new ExtendedQuoteBlock();
        this.blocks.add(quoteBlock);
        this.paragraphBreakingBlocks.add(quoteBlock);
        ExtendedPreformattedBlock noformatBlock = new ExtendedPreformattedBlock();
        this.blocks.add(noformatBlock);
        this.paragraphBreakingBlocks.add(noformatBlock);
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.PANEL, "panel"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.NOTE, "note"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.INFORMATION, "info"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.WARNING, "warning"));
        this.blocks.add(new TextBoxBlock(DocumentBuilder.BlockType.TIP, "tip"));
        CodeBlock codeBlock = new CodeBlock();
        this.blocks.add(codeBlock);
        this.paragraphBreakingBlocks.add(codeBlock);
        this.blocks.add(new TableOfContentsBlock());
        this.blocks.add(new ParagraphBlock());
    }

    @Override
    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Block> getParagraphBreakingBlocks() {
        return this.paragraphBreakingBlocks;
    }

    static {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add(new SimplePhraseModifier("*", DocumentBuilder.SpanType.STRONG, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("_", DocumentBuilder.SpanType.EMPHASIS, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("??", DocumentBuilder.SpanType.CITATION, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("-", DocumentBuilder.SpanType.DELETED, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("+", DocumentBuilder.SpanType.UNDERLINED, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("^", DocumentBuilder.SpanType.SUPERSCRIPT, false));
        phraseModifierSyntax.add(new SimplePhraseModifier("~", DocumentBuilder.SpanType.SUBSCRIPT, false));
        phraseModifierSyntax.add(new SimpleWrappedPhraseModifier("{{", "}}", DocumentBuilder.SpanType.MONOSPACE, false));
        phraseModifierSyntax.add(new ImagePhraseModifier());
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        tokenSyntax.add(new EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add(new EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add(new HyperlinkReplacementToken());
        tokenSyntax.add(new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(---)(?=\\s\\w))", "#8212"));
        tokenSyntax.add(new PatternEntityReferenceReplacementToken("(?:(?<=\\w\\s)(--)(?=\\s\\w))", "#8211"));
        tokenSyntax.add(new PatternLiteralReplacementToken("(?:(?<=\\w\\s)(----)(?=\\s\\w))", "<hr/>"));
        tokenSyntax.add(new PatternLineBreakReplacementToken("(\\\\\\\\)"));
        tokenSyntax.add(new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add(new AnchorReplacementToken());
    }
}

