/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.confluence.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.confluence.ConfluenceDialect;

public class ParagraphBlock
extends Block {
    private static final Pattern confluenceBlockStart = Pattern.compile("\\{(code|info|tip|warning|panel|note|toc)(?:(:[^\\}]*))?\\}");
    private int blockLineCount = 0;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        }
        if (this.dialect.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        ++this.blockLineCount;
        ConfluenceDialect dialect = (ConfluenceDialect)this.getDialect();
        for (Block block : dialect.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        Matcher blockStartMatcher = confluenceBlockStart.matcher(line);
        if (offset > 0) {
            blockStartMatcher.region(offset, line.length());
        }
        if (blockStartMatcher.find()) {
            int end = blockStartMatcher.start();
            if (end > offset) {
                dialect.emitMarkupLine(this.getParser(), this.state, offset, line.substring(offset, end), 0);
            }
            this.setClosed(true);
            return end;
        }
        if (this.blockLineCount > 1) {
            this.builder.lineBreak();
        }
        dialect.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

