/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.textile.Textile;

public class PreformattedBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 9;
    private static final int EXTENDED_GROUP = 8;
    static final Pattern startPattern = Pattern.compile("pre(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\.(\\.)?\\s+(.*)");
    private boolean extended;
    private int blockLineCount = 0;
    private Matcher matcher;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            Textile.configureAttributes(attributes, this.matcher, 1, true);
            offset = this.matcher.start(9);
            this.extended = this.matcher.group(8) != null;
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, attributes);
        }
        if (this.dialect.isEmptyLine(line) && !this.extended) {
            this.setClosed(true);
            return 0;
        }
        if (this.extended && Textile.explicitBlockBegins(line, offset)) {
            this.setClosed(true);
            return offset;
        }
        ++this.blockLineCount;
        this.builder.characters(offset > 0 ? line.substring(offset) : line);
        this.builder.characters("\n");
        return -1;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

