/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.trac.block;

import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.trac.TracWikiDialect;

public class ParagraphBlock
extends Block {
    private int blockLineCount = 0;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        }
        if (this.dialect.isEmptyLine(line)) {
            this.setClosed(true);
            return -1;
        }
        ++this.blockLineCount;
        TracWikiDialect dialect = (TracWikiDialect)this.getDialect();
        for (Block block : dialect.getParagraphNestableBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        if (this.blockLineCount != 1) {
            this.builder.characters("\n");
        }
        dialect.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

