/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.trac.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;

public class PreformattedBlock
extends Block {
    private static final Pattern startPattern = Pattern.compile("\\{\\{\\{(.*)");
    private static final Pattern endPattern = Pattern.compile("\\}\\}\\}(.*)");
    private int blockLineCount = 0;
    private Matcher matcher;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount++ == 0) {
            offset = this.matcher.start(1);
            this.builder.beginBlock(DocumentBuilder.BlockType.PREFORMATTED, new Attributes());
        } else {
            Matcher endMatcher = endPattern.matcher(line);
            if (endMatcher.matches()) {
                this.setClosed(true);
                return endMatcher.start(1);
            }
        }
        this.builder.characters(offset == 0 ? line : line.substring(offset));
        this.builder.characters("\n");
        return -1;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

