/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import net.java.textilej.util.XmlStreamWriter;

public class DefaultXmlStreamWriter
implements XmlStreamWriter {
    private PrintWriter out;
    private Map<String, String> prefixToUri = new HashMap<String, String>();
    private Map<String, String> uriToPrefix = new HashMap<String, String>();
    private boolean inEmptyElement = false;
    private boolean inStartElement = false;
    private Stack<String> elements = new Stack();
    private char xmlHederQuoteChar = (char)39;
    private static final byte[] XML11CHARS = new byte[65536];
    public static final int MASK_XML11_VALID = 1;
    public static final int MASK_XML11_CONTROL = 16;

    public DefaultXmlStreamWriter(OutputStream out) throws UnsupportedEncodingException {
        this.out = this.createUtf8PrintWriter(out);
    }

    public DefaultXmlStreamWriter(Writer out) {
        this.out = new PrintWriter(out);
    }

    public DefaultXmlStreamWriter(Writer out, char xmlHeaderQuoteChar) {
        this.out = new PrintWriter(out);
        this.xmlHederQuoteChar = xmlHeaderQuoteChar;
    }

    protected PrintWriter createUtf8PrintWriter(OutputStream out) throws UnsupportedEncodingException {
        return new PrintWriter(new OutputStreamWriter(out, "UTF8"));
    }

    @Override
    public void close() {
        if (this.out != null) {
            this.closeElement();
            this.flush();
        }
        this.out = null;
    }

    @Override
    public void flush() {
        this.out.flush();
    }

    @Override
    public String getPrefix(String uri) {
        return this.uriToPrefix.get(uri);
    }

    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }

    @Override
    public void setDefaultNamespace(String uri) {
        this.setPrefix("", uri);
    }

    @Override
    public void setPrefix(String prefix, String uri) {
        this.prefixToUri.put(prefix, uri);
        this.uriToPrefix.put(uri, prefix);
    }

    @Override
    public void writeAttribute(String localName, String value) {
        this.out.write(32);
        this.out.write(localName);
        this.out.write("=\"");
        if (value != null) {
            this.attrEncode(value);
        }
        this.out.write("\"");
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) {
        this.out.write(32);
        String prefix = this.uriToPrefix.get(namespaceURI);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
        this.out.write("=\"");
        if (value != null) {
            this.attrEncode(value);
        }
        this.out.write("\"");
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) {
        this.out.write(32);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
        this.out.write("=\"");
        if (value != null) {
            this.attrEncode(value);
        }
        this.out.write("\"");
    }

    private void attrEncode(String value) {
        if (value == null) {
            return;
        }
        DefaultXmlStreamWriter.printEscaped(this.out, value, true);
    }

    private void encode(String text) {
        if (text == null) {
            return;
        }
        DefaultXmlStreamWriter.printEscaped(this.out, text, false);
    }

    @Override
    public void writeCData(String data) {
        this.closeElement();
        this.out.write("<![CDATA[");
        this.out.write(data);
        this.out.write("]]>");
    }

    @Override
    public void writeCharacters(String text) {
        this.closeElement();
        this.encode(text);
    }

    public void writeCharactersUnescaped(String text) {
        this.closeElement();
        this.out.print(text);
    }

    @Override
    public void writeLiteral(String literal) {
        this.writeCharactersUnescaped(literal);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) {
        this.closeElement();
        this.encode(new String(text, start, len));
    }

    @Override
    public void writeComment(String data) {
        this.closeElement();
        this.out.write("<!-- ");
        this.out.write(data);
        this.out.write(" -->");
    }

    @Override
    public void writeDTD(String dtd) {
        this.out.write(dtd);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) {
        this.writeAttribute("xmlns", namespaceURI);
    }

    private void closeElement() {
        if (this.inEmptyElement) {
            this.out.write("/>");
            this.inEmptyElement = false;
        } else if (this.inStartElement) {
            this.out.write(">");
            this.inStartElement = false;
        }
    }

    @Override
    public void writeEmptyElement(String localName) {
        this.closeElement();
        this.inEmptyElement = true;
        this.out.write(60);
        this.out.write(localName);
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) {
        this.closeElement();
        this.inEmptyElement = true;
        String prefix = this.uriToPrefix.get(namespaceURI);
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) {
        this.closeElement();
        this.inEmptyElement = true;
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
    }

    @Override
    public void writeEndDocument() {
        if (!this.elements.isEmpty()) {
            throw new IllegalStateException(this.elements.size() + " elements not closed");
        }
    }

    @Override
    public void writeEndElement() {
        this.closeElement();
        if (this.elements.isEmpty()) {
            throw new IllegalStateException();
        }
        String name = this.elements.pop();
        this.out.write(60);
        this.out.write(47);
        this.out.write(name);
        this.out.write(62);
    }

    @Override
    public void writeEntityRef(String name) {
        this.closeElement();
        this.out.write(38);
        this.out.write(name);
        this.out.write(59);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) {
        if (prefix == null || prefix.length() == 0) {
            this.writeAttribute("xmlns", namespaceURI);
        } else {
            this.writeAttribute("xmlns:" + prefix, namespaceURI);
        }
    }

    @Override
    public void writeProcessingInstruction(String target) {
        this.closeElement();
    }

    @Override
    public void writeProcessingInstruction(String target, String data) {
        this.closeElement();
    }

    @Override
    public void writeStartDocument() {
        this.out.write(this.processXmlHeader("<?xml version='1.0' ?>"));
    }

    @Override
    public void writeStartDocument(String version) {
        this.out.write(this.processXmlHeader("<?xml version='" + version + "' ?>"));
    }

    @Override
    public void writeStartDocument(String encoding, String version) {
        this.out.write(this.processXmlHeader("<?xml version='" + version + "' encoding='" + encoding + "' ?>"));
    }

    @Override
    public void writeStartElement(String localName) {
        this.closeElement();
        this.inStartElement = true;
        this.elements.push(localName);
        this.out.write(60);
        this.out.write(localName);
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) {
        this.closeElement();
        this.inStartElement = true;
        String prefix = this.uriToPrefix.get(namespaceURI);
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
            this.elements.push(prefix + ':' + localName);
        } else {
            this.elements.push(localName);
        }
        this.out.write(localName);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) {
        this.closeElement();
        this.inStartElement = true;
        this.elements.push(localName);
        this.out.write(60);
        if (prefix != null && prefix.length() > 0) {
            this.out.write(prefix);
            this.out.write(58);
        }
        this.out.write(localName);
    }

    public char getXmlHederQuoteChar() {
        return this.xmlHederQuoteChar;
    }

    public void setXmlHederQuoteChar(char xmlHederQuoteChar) {
        this.xmlHederQuoteChar = xmlHederQuoteChar;
    }

    private String processXmlHeader(String header) {
        return this.xmlHederQuoteChar == '\'' ? header : header.replace('\'', this.xmlHederQuoteChar);
    }

    private static void printEscaped(PrintWriter writer, CharSequence s, boolean attribute) {
        int length = s.length();
        try {
            for (int x = 0; x < length; ++x) {
                char ch = s.charAt(x);
                DefaultXmlStreamWriter.printEscaped(writer, ch, attribute);
            }
        }
        catch (IOException ioe) {
            throw new IllegalStateException();
        }
    }

    private static void printEscaped(PrintWriter writer, int ch, boolean attribute) throws IOException {
        String ref = DefaultXmlStreamWriter.getEntityRef(ch, attribute);
        if (ref != null) {
            writer.write(38);
            writer.write(ref);
            writer.write(59);
        } else if (ch == 13 || ch == 133 || ch == 8232) {
            DefaultXmlStreamWriter.printHex(writer, ch);
        } else if (ch >= 32 && ch != 160 && DefaultXmlStreamWriter.isUtf8Printable((char)ch) && DefaultXmlStreamWriter.isXML11ValidLiteral(ch) || ch == 9 || ch == 10 || ch == 13) {
            writer.write((char)ch);
        } else {
            DefaultXmlStreamWriter.printHex(writer, ch);
        }
    }

    static final void printHex(PrintWriter writer, int ch) throws IOException {
        writer.write("&#x");
        writer.write(Integer.toHexString(ch));
        writer.write(59);
    }

    protected static String getEntityRef(int ch, boolean attribute) {
        switch (ch) {
            case 60: {
                return "lt";
            }
            case 34: {
                if (!attribute) break;
                return "quot";
            }
            case 38: {
                return "amp";
            }
        }
        return null;
    }

    protected static boolean isUtf8Printable(char ch) {
        return ch >= ' ' && ch <= '\u10ffff' && ch != '\u00f7' || ch == '\n' || ch == '\r' || ch == '\t';
    }

    public static boolean isXML11ValidLiteral(int c) {
        return c < 65536 && (XML11CHARS[c] & 1) != 0 && (XML11CHARS[c] & 0x10) == 0 || 65536 <= c && c <= 0x10FFFF;
    }

    static {
        Arrays.fill(XML11CHARS, 1, 9, (byte)17);
        DefaultXmlStreamWriter.XML11CHARS[9] = 35;
        DefaultXmlStreamWriter.XML11CHARS[10] = 3;
        Arrays.fill(XML11CHARS, 11, 13, (byte)17);
        DefaultXmlStreamWriter.XML11CHARS[13] = 3;
        Arrays.fill(XML11CHARS, 14, 32, (byte)17);
        DefaultXmlStreamWriter.XML11CHARS[32] = 35;
        Arrays.fill(XML11CHARS, 33, 38, (byte)33);
        DefaultXmlStreamWriter.XML11CHARS[38] = 1;
        Arrays.fill(XML11CHARS, 39, 45, (byte)33);
        Arrays.fill(XML11CHARS, 45, 47, (byte)-87);
        DefaultXmlStreamWriter.XML11CHARS[47] = 33;
        Arrays.fill(XML11CHARS, 48, 58, (byte)-87);
        DefaultXmlStreamWriter.XML11CHARS[58] = 45;
        DefaultXmlStreamWriter.XML11CHARS[59] = 33;
        DefaultXmlStreamWriter.XML11CHARS[60] = 1;
        Arrays.fill(XML11CHARS, 61, 65, (byte)33);
        Arrays.fill(XML11CHARS, 65, 91, (byte)-19);
        Arrays.fill(XML11CHARS, 91, 93, (byte)33);
        DefaultXmlStreamWriter.XML11CHARS[93] = 1;
        DefaultXmlStreamWriter.XML11CHARS[94] = 33;
        DefaultXmlStreamWriter.XML11CHARS[95] = -19;
        DefaultXmlStreamWriter.XML11CHARS[96] = 33;
        Arrays.fill(XML11CHARS, 97, 123, (byte)-19);
        Arrays.fill(XML11CHARS, 123, 127, (byte)33);
        Arrays.fill(XML11CHARS, 127, 133, (byte)17);
        DefaultXmlStreamWriter.XML11CHARS[133] = 35;
        Arrays.fill(XML11CHARS, 134, 160, (byte)17);
        Arrays.fill(XML11CHARS, 160, 183, (byte)33);
        DefaultXmlStreamWriter.XML11CHARS[183] = -87;
        Arrays.fill(XML11CHARS, 184, 192, (byte)33);
        Arrays.fill(XML11CHARS, 192, 215, (byte)-19);
        DefaultXmlStreamWriter.XML11CHARS[215] = 33;
        Arrays.fill(XML11CHARS, 216, 247, (byte)-19);
        DefaultXmlStreamWriter.XML11CHARS[247] = 33;
        Arrays.fill(XML11CHARS, 248, 768, (byte)-19);
        Arrays.fill(XML11CHARS, 768, 880, (byte)-87);
        Arrays.fill(XML11CHARS, 880, 894, (byte)-19);
        DefaultXmlStreamWriter.XML11CHARS[894] = 33;
        Arrays.fill(XML11CHARS, 895, 8192, (byte)-19);
        Arrays.fill(XML11CHARS, 8192, 8204, (byte)33);
        Arrays.fill(XML11CHARS, 8204, 8206, (byte)-19);
        Arrays.fill(XML11CHARS, 8206, 8232, (byte)33);
        DefaultXmlStreamWriter.XML11CHARS[8232] = 35;
        Arrays.fill(XML11CHARS, 8233, 8255, (byte)33);
        Arrays.fill(XML11CHARS, 8255, 8257, (byte)-87);
        Arrays.fill(XML11CHARS, 8257, 8304, (byte)33);
        Arrays.fill(XML11CHARS, 8304, 8592, (byte)-19);
        Arrays.fill(XML11CHARS, 8592, 11264, (byte)33);
        Arrays.fill(XML11CHARS, 11264, 12272, (byte)-19);
        Arrays.fill(XML11CHARS, 12272, 12289, (byte)33);
        Arrays.fill(XML11CHARS, 12289, 55296, (byte)-19);
        Arrays.fill(XML11CHARS, 57344, 63744, (byte)33);
        Arrays.fill(XML11CHARS, 63744, 64976, (byte)-19);
        Arrays.fill(XML11CHARS, 64976, 65008, (byte)33);
        Arrays.fill(XML11CHARS, 65008, 65534, (byte)-19);
    }
}

