/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.util.anttask;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import net.java.textilej.parser.util.TextileToEclipseToc;
import net.java.textilej.util.anttask.TextileToHtmlTask;
import org.apache.tools.ant.BuildException;

public class TextileToEclipseHelpTask
extends TextileToHtmlTask {
    private String xmlFilenameFormat = "$1-toc.xml";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String processFile(File baseDir, File source) throws BuildException {
        File tocOutputFile;
        String textile = super.processFile(baseDir, source);
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(tocOutputFile = this.computeTocFile(source, name)).exists() || this.overwrite || tocOutputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            File htmlOutputFile = this.computeHtmlFile(source, name);
            if (textile == null) {
                textile = this.readFully(source);
            }
            try {
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(tocOutputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", tocOutputFile, e.getMessage()), (Throwable)e);
            }
            try {
                TextileToEclipseToc toEclipseToc = new TextileToEclipseToc();
                toEclipseToc.setBookTitle(this.title == null ? name : this.title);
                String basePath = baseDir.getAbsolutePath().replace('\\', '/');
                String outputFilePath = htmlOutputFile.getAbsolutePath().replace('\\', '/');
                if (outputFilePath.startsWith(basePath)) {
                    String filePath = outputFilePath.substring(basePath.length());
                    if (filePath.startsWith("/")) {
                        filePath = filePath.substring(1);
                    }
                    toEclipseToc.setHtmlFile(filePath);
                } else {
                    toEclipseToc.setHtmlFile(htmlOutputFile.getName());
                }
                String tocXml = toEclipseToc.parse(textile);
                try {
                    writer.write(tocXml);
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot write to file '%s': %s", tocXml, e.getMessage()), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot write to file '%s': %s", tocOutputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", tocOutputFile, e.getMessage()), (Throwable)e);
            }
        }
        return textile;
    }

    private File computeTocFile(File source, String name) {
        return new File(source.getParentFile(), this.xmlFilenameFormat.replace("$1", name));
    }

    public String getXmlFilenameFormat() {
        return this.xmlFilenameFormat;
    }

    public void setXmlFilenameFormat(String xmlFilenameFormat) {
        this.xmlFilenameFormat = xmlFilenameFormat;
    }
}

