/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite;

import freenet.l10n.BaseL10n;
import freenet.l10n.PluginL10n;
import freenet.pluginmanager.FredPlugin;
import freenet.pluginmanager.FredPluginBaseL10n;
import freenet.pluginmanager.FredPluginL10n;
import freenet.pluginmanager.FredPluginRealVersioned;
import freenet.pluginmanager.FredPluginThreadless;
import freenet.pluginmanager.FredPluginVersioned;
import freenet.pluginmanager.PluginRespirator;
import plugins.Sharesite.Database;
import plugins.Sharesite.Inserter;
import plugins.Sharesite.common.Logger;
import plugins.Sharesite.webui.WebInterface;

public class Plugin
implements FredPlugin,
FredPluginVersioned,
FredPluginRealVersioned,
FredPluginL10n,
FredPluginBaseL10n,
FredPluginThreadless {
    public static final String version = "0.2.7";
    public static final long realVersion = 2L;
    public static final String freesite = "USK@dCnkUL22fAmKbKg-Cftx9j2m4IwyWB0QbGoiq1RSLP8,4d1TDqwRr4tYlsubLrQK~c4h0~FtmE-OXCDmFiI8BB4,AQACAAE/Sharesite/-1/";
    public static boolean isPreRelease = false;
    private PluginL10n plugL10n;
    public static Plugin instance;
    public PluginRespirator pluginRespirator;
    public BaseL10n l10n;
    public Logger logger;
    public Inserter inserter;
    public Database database;
    public WebInterface webInterface;

    public Plugin() {
        instance = this;
    }

    public void runPlugin(PluginRespirator pr) {
        this.pluginRespirator = pr;
        this.logger = new Logger("Sharesite.log");
        this.logger.putstr("Loading of Sharesite 0.2.7 begins!");
        this.logger.putstr("Setting GraphicsEnvironment to headless");
        System.setProperty("java.awt.headless", "true");
        this.logger.putstr("Preparing the inserter ...");
        this.inserter = new Inserter();
        this.inserter.start();
        this.logger.putstr("Loading the database ...");
        this.database = new Database();
        this.logger.putstr("Registering the web interface ...");
        this.webInterface = new WebInterface();
        this.webInterface.createInterface();
        this.logger.putstr("Successfully started!");
    }

    public void terminate() {
        this.logger.putstr("Terminating ...");
        this.webInterface.removeInterface();
        this.inserter.terminate();
        this.logger.close();
    }

    public String getVersion() {
        return version;
    }

    public long getRealVersion() {
        return 2L;
    }

    public String getString(String key) {
        return this.l10n.getString(key);
    }

    public void setLanguage(BaseL10n.LANGUAGE newLanguage) {
        this.plugL10n = new PluginL10n((FredPluginBaseL10n)this, newLanguage);
        this.l10n = this.plugL10n.getBase();
    }

    public String getL10nFilesBasePath() {
        return "plugins/Sharesite/l10n/";
    }

    public String getL10nFilesMask() {
        return "lang_${lang}.l10n";
    }

    public String getL10nOverrideFilesMask() {
        return "Sharesite_lang_${lang}.override.l10n";
    }

    public ClassLoader getPluginClassLoader() {
        return Plugin.class.getClassLoader();
    }
}

