/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite.webui;

import freenet.clients.http.InfoboxNode;
import freenet.clients.http.PageMaker;
import freenet.clients.http.PageNode;
import freenet.clients.http.Toadlet;
import freenet.clients.http.ToadletContext;
import freenet.clients.http.ToadletContextClosedException;
import freenet.keys.FreenetURI;
import freenet.l10n.BaseL10n;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.HTMLNode;
import freenet.support.api.Bucket;
import freenet.support.api.HTTPRequest;
import freenet.support.io.ArrayBucket;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import plugins.Sharesite.Freesite;
import plugins.Sharesite.Plugin;
import plugins.Sharesite.common.MapToData;
import plugins.Sharesite.common.SmartMap;

public class HomeToadlet
extends Toadlet {
    private PluginRespirator pr;
    private PageMaker pageMaker;
    private BaseL10n l10n;

    public HomeToadlet() {
        super(null);
        this.pr = Plugin.instance.pluginRespirator;
        this.pageMaker = this.pr.getPageMaker();
        this.l10n = Plugin.instance.l10n;
    }

    public String path() {
        return "/Sharesite/";
    }

    public void handleMethodGET(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (uri.getPath().endsWith(".db")) {
            SmartMap map = Plugin.instance.database.getDatabaseAsMap();
            byte[] file = MapToData.mapToData(map);
            ArrayBucket bucket = new ArrayBucket(file);
            this.writeReply(ctx, 200, "application/octet-stream", "OK", (Bucket)bucket);
            return;
        }
        PageNode pageNode = this.pageMaker.getPageNode(this.l10n.getString("Sharesite.Menu.Name"), ctx);
        HTMLNode homeForm = this.pr.addFormChild(pageNode.content, "/Sharesite/", "homeForm");
        InfoboxNode listBox = this.pageMaker.getInfobox(this.l10n.getString("Sharesite.Home.Header"));
        homeForm.addChild(listBox.outer);
        if (Plugin.isPreRelease) {
            listBox.content.addChild("p", this.l10n.getString("Sharesite.Home.PreRelease"));
        }
        HTMLNode listNewP = listBox.content.addChild("p");
        String[] attrs = new String[]{"type", "name", "value"};
        String[] vals = new String[]{"submit", "newBtn", this.l10n.getString("Sharesite.Home.NewBtn")};
        listNewP.addChild("input", attrs, vals);
        int numDeleted = Plugin.instance.database.numDeleted();
        if (numDeleted > 0) {
            String undelstr = this.l10n.getString("Sharesite.Home.UndeleteBtn", "num", Integer.toString(numDeleted));
            attrs = new String[]{"type", "name", "value"};
            vals = new String[]{"submit", "undeleteBtn", undelstr};
            listNewP.addChild("input", attrs, vals);
        }
        if (Plugin.instance.database.numFreesites() == 0) {
            listBox.content.addChild("p", this.l10n.getString("Sharesite.Home.Empty"));
        } else {
            attrs = new String[]{"type", "name", "value"};
            vals = new String[]{"submit", "insertBtn", this.l10n.getString("Sharesite.Home.InsertBtn")};
            listBox.content.addChild("input", attrs, vals);
            attrs = new String[]{"type", "name", "value"};
            vals = new String[]{"submit", "deleteBtn", this.l10n.getString("Sharesite.Home.DeleteBtn")};
            listBox.content.addChild("input", attrs, vals);
            listBox.content.addChild("span", " " + this.l10n.getString("Sharesite.Home.SelectedLists"));
            HTMLNode listTable = listBox.content.addChild("table");
            HTMLNode listHeaders = listTable.addChild("tr");
            listHeaders.addChild("th", "");
            listHeaders.addChild("th", this.l10n.getString("Sharesite.Home.NameHeader"));
            listHeaders.addChild("th", this.l10n.getString("Sharesite.Home.StatusHeader"));
            listHeaders.addChild("th", this.l10n.getString("Sharesite.Home.KeyHeader"));
            listHeaders.addChild("th", this.l10n.getString("Sharesite.Home.PreviewHeader"));
            for (Freesite c : Plugin.instance.database.getFreesites()) {
                HTMLNode listRow = listTable.addChild("tr");
                attrs = new String[]{"type", "name"};
                vals = new String[]{"checkbox", "list-" + c.getUniqueKey()};
                listRow.addChild("td").addChild("input", attrs, vals);
                listRow.addChild("td").addChild("a", "href", "/Sharesite/Edit/" + c.getUniqueKey(), c.getName());
                listRow.addChild("td", c.getStatus());
                if (c.getEdition() >= 0L) {
                    FreenetURI key = new FreenetURI(c.getRequestSSK() + c.getName() + "-" + c.getEdition() + "/");
                    key = key.uskForSSK();
                    listRow.addChild("td").addChild("a", "href", "/" + key.toString(), key.toShortString());
                } else {
                    listRow.addChild("td", this.l10n.getString("Sharesite.Home.NoKey"));
                }
                listRow.addChild("td").addChild("a", "href", "/Sharesite/Preview/" + c.getUniqueKey() + "/index.html", "#" + c.getUniqueKey());
            }
            this.l10n.addL10nSubstitution(listBox.content.addChild("p"), "Sharesite.Home.NoteAnnounce", new String[]{"link"}, new HTMLNode[]{HTMLNode.link((String)"/chat/")});
        }
        InfoboxNode backupBox = this.pageMaker.getInfobox(this.l10n.getString("Sharesite.Home.BackupHeader"));
        homeForm.addChild(backupBox.outer);
        Calendar calendar = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String todayDate = dateFormat.format(calendar.getTime());
        HTMLNode backupP = backupBox.content.addChild("p");
        backupP.addChild("a", "href", "/Sharesite/Sharesite-" + todayDate + ".db", this.l10n.getString("Sharesite.Home.BackupBtn"));
        backupBox.content.addChild("p", this.l10n.getString("Sharesite.Home.NoteRestore"));
        attrs = new String[]{"type", "name", "value"};
        vals = new String[]{"file", "restoreFile", ""};
        backupBox.content.addChild("input", attrs, vals);
        attrs = new String[]{"type", "name", "value"};
        vals = new String[]{"submit", "restoreBtn", this.l10n.getString("Sharesite.Home.RestoreBtn")};
        backupBox.content.addChild("input", attrs, vals);
        HTMLNode versionP = homeForm.addChild("p", "style", "text-align: right");
        versionP.addChild("span", "style", "font-size: 0.7em;", this.l10n.getString("Sharesite.Home.Version", "ver", "0.2.7"));
        versionP.addChild("br");
        versionP.addChild("span", "style", "font-size: 0.7em;").addChild("a", "href", "/USK@dCnkUL22fAmKbKg-Cftx9j2m4IwyWB0QbGoiq1RSLP8,4d1TDqwRr4tYlsubLrQK~c4h0~FtmE-OXCDmFiI8BB4,AQACAAE/Sharesite/-1/", this.l10n.getString("Sharesite.Home.CheckSite"));
        String ret = pageNode.outer.generate();
        this.writeHTMLReply(ctx, 200, "OK", ret);
    }

    public void handleMethodPOST(URI uri, HTTPRequest req, ToadletContext ctx) throws ToadletContextClosedException, IOException {
        if (req.isPartSet("newBtn")) {
            Plugin.instance.database.createFreesite();
            Plugin.instance.database.save();
            this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/");
            return;
        }
        if (req.isPartSet("undeleteBtn")) {
            Plugin.instance.database.restoreDeleted();
            Plugin.instance.database.save();
            this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/");
            return;
        }
        if (req.isPartSet("restoreBtn")) {
            byte[] got = req.getPartAsBytesFailsafe("restoreFile", 1000000000);
            SmartMap map = MapToData.dataToMap(got);
            Plugin.instance.database.addFromMap(map);
            Plugin.instance.database.save();
            this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/");
            return;
        }
        boolean INSERT = true;
        int DELETE = 2;
        int button = 0;
        if (req.isPartSet("insertBtn")) {
            button = 1;
        }
        if (req.isPartSet("deleteBtn")) {
            button = 2;
        }
        if (button != 0) {
            for (String part : req.getParts()) {
                if (!part.startsWith("list-") || !req.getPartAsStringFailsafe(part, 5).equals("on")) continue;
                int id = -1;
                try {
                    id = Integer.parseInt(part.substring(5));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                Freesite c = Plugin.instance.database.getFreesiteWithUniqueKey(id);
                if (c == null) continue;
                if (button == 1) {
                    Plugin.instance.inserter.add(c);
                }
                if (button != 2) continue;
                Plugin.instance.database.delete(c);
            }
            if (button == 2) {
                Plugin.instance.database.save();
            }
        }
        this.writeTemporaryRedirect(ctx, "Redirecting...", "/Sharesite/");
    }
}

