/*
 * Decompiled with CFR 0.152.
 */
package freenet.node;

import freenet.client.InsertException;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientRequestScheduler;
import freenet.keys.ClientKey;
import freenet.node.LowLevelPutException;
import freenet.node.RequestScheduler;
import freenet.node.SendableRequest;
import freenet.node.SendableRequestItem;
import freenet.support.Logger;
import freenet.support.io.NativeThread;
import freenet.support.io.ResumeFailedException;

public abstract class SendableInsert
extends SendableRequest {
    private static final long serialVersionUID = 1L;
    private transient boolean resumed = false;

    public SendableInsert(boolean persistent, boolean realTimeFlag) {
        super(persistent, realTimeFlag);
    }

    public abstract void onSuccess(SendableRequestItem var1, ClientKey var2, ClientContext var3);

    public abstract void onFailure(LowLevelPutException var1, SendableRequestItem var2, ClientContext var3);

    @Override
    public void internalError(Throwable t, RequestScheduler sched, ClientContext context, boolean persistent) {
        Logger.error(this, "Internal error on " + this + " : " + t, t);
        sched.callFailure(this, new LowLevelPutException(1, t.getMessage(), t), NativeThread.MAX_PRIORITY, persistent);
    }

    @Override
    public final boolean isInsert() {
        return true;
    }

    @Override
    public ClientRequestScheduler getScheduler(ClientContext context) {
        if (this.isSSK()) {
            return context.getSskInsertScheduler(this.realTimeFlag);
        }
        return context.getChkInsertScheduler(this.realTimeFlag);
    }

    public abstract boolean canWriteClientCache();

    public abstract boolean localRequestOnly();

    public abstract boolean forkOnCacheable();

    public abstract void onEncode(SendableRequestItem var1, ClientKey var2, ClientContext var3);

    public abstract boolean isEmpty();

    @Override
    public long getWakeupTime(ClientContext context, long now) {
        if (this.isEmpty()) {
            return -1L;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onResume(ClientContext context) throws InsertException, ResumeFailedException {
        SendableInsert sendableInsert = this;
        synchronized (sendableInsert) {
            if (this.resumed) {
                return;
            }
            this.resumed = true;
        }
        this.innerOnResume(context);
    }

    protected abstract void innerOnResume(ClientContext var1) throws InsertException, ResumeFailedException;
}

