/*
 * Decompiled with CFR 0.152.
 */
package plugins.UPnP.org.cybergarage.util;

import plugins.UPnP.org.cybergarage.util.Debug;

public final class StringUtil {
    public static final boolean hasData(String value) {
        if (value == null) {
            return false;
        }
        return value.length() > 0;
    }

    public static final int toInteger(String value) {
        try {
            return Integer.parseInt(value);
        }
        catch (Exception e) {
            Debug.warning(e);
            return 0;
        }
    }

    public static final long toLong(String value) {
        try {
            return Long.parseLong(value);
        }
        catch (Exception e) {
            Debug.warning(e);
            return 0L;
        }
    }

    public static final int findOf(String str, String chars, int startIdx, int endIdx, int offset, boolean isEqual) {
        if (offset == 0) {
            return -1;
        }
        int charCnt = chars.length();
        int idx = startIdx;
        while (!(0 < offset ? endIdx < idx : idx < endIdx)) {
            char strc = str.charAt(idx);
            int noEqualCnt = 0;
            for (int n = 0; n < charCnt; ++n) {
                char charc = chars.charAt(n);
                if (isEqual) {
                    if (strc != charc) continue;
                    return idx;
                }
                if (strc != charc) {
                    ++noEqualCnt;
                }
                if (noEqualCnt != charCnt) continue;
                return idx;
            }
            idx += offset;
        }
        return -1;
    }

    public static final int findFirstOf(String str, String chars) {
        return StringUtil.findOf(str, chars, 0, str.length() - 1, 1, true);
    }

    public static final int findFirstNotOf(String str, String chars) {
        return StringUtil.findOf(str, chars, 0, str.length() - 1, 1, false);
    }

    public static final int findLastOf(String str, String chars) {
        return StringUtil.findOf(str, chars, str.length() - 1, 0, -1, true);
    }

    public static final int findLastNotOf(String str, String chars) {
        return StringUtil.findOf(str, chars, str.length() - 1, 0, -1, false);
    }

    public static final String trim(String trimStr, String trimChars) {
        int spIdx = StringUtil.findFirstNotOf(trimStr, trimChars);
        if (spIdx < 0) {
            String buf = trimStr;
            return buf;
        }
        String trimStr2 = trimStr.substring(spIdx, trimStr.length());
        if ((spIdx = StringUtil.findLastNotOf(trimStr2, trimChars)) < 0) {
            String buf = trimStr2;
            return buf;
        }
        String buf = trimStr2.substring(0, spIdx + 1);
        return buf;
    }
}

