/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library;

import freenet.crypt.RandomSource;
import freenet.keys.FreenetURI;
import freenet.keys.InsertableClientSSK;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.Logger;
import freenet.support.io.Closer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;

class SpiderIndexURIs {
    private FreenetURI privURI;
    private FreenetURI pubURI;
    private long edition;
    private final PluginRespirator pr;

    SpiderIndexURIs(PluginRespirator pr) {
        this.pr = pr;
    }

    synchronized long setEdition(long newEdition) {
        if (newEdition < this.edition) {
            return this.edition;
        }
        this.edition = newEdition;
        return this.edition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    synchronized FreenetURI loadSSKURIs() {
        block22: {
            OutputStreamWriter osw;
            if (this.privURI != null) break block22;
            File f = new File("library.index.privkey");
            FileInputStream fis = null;
            InsertableClientSSK privkey = null;
            boolean newPrivKey = false;
            try {
                fis = new FileInputStream(f);
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                this.privURI = new FreenetURI(br.readLine()).setDocName("index.yml");
                privkey = InsertableClientSSK.create((FreenetURI)this.privURI);
                Logger.debug((Object)this, (String)"Read old privkey");
                this.pubURI = privkey.getURI();
                Logger.debug((Object)this, (String)("Recovered URI from disk, pubkey is " + this.pubURI));
                fis.close();
                fis = null;
            }
            catch (IOException br) {
                Closer.close((Closeable)fis);
                catch (Throwable throwable) {
                    Closer.close(fis);
                    throw throwable;
                }
            }
            Closer.close((Closeable)fis);
            if (this.privURI == null) {
                InsertableClientSSK key = InsertableClientSSK.createRandom((RandomSource)this.pr.getNode().random, (String)"index.yml");
                this.privURI = key.getInsertURI();
                this.pubURI = key.getURI();
                newPrivKey = true;
                Logger.debug((Object)this, (String)("Created new keypair, pubkey is " + this.pubURI));
            }
            FileOutputStream fos = null;
            if (newPrivKey) {
                try {
                    fos = new FileOutputStream(new File("library.index.privkey"));
                    osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                    osw.write(this.privURI.toASCIIString());
                    osw.close();
                    fos = null;
                }
                catch (IOException e) {
                    try {
                        Logger.error((Object)this, (String)"Failed to write new private key : ", (Throwable)e);
                    }
                    catch (Throwable throwable) {
                        Closer.close(fos);
                        throw throwable;
                    }
                    Closer.close((Closeable)fos);
                }
                Closer.close((Closeable)fos);
            }
            try {
                fos = new FileOutputStream(new File("library.index.pubkey"));
                osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
                osw.write(this.pubURI.toASCIIString());
                osw.close();
                fos = null;
            }
            catch (IOException e) {
                try {
                    Logger.error((Object)this, (String)"Failed to write new pubkey", (Throwable)e);
                }
                catch (Throwable throwable) {
                    Closer.close(fos);
                    throw throwable;
                }
                Closer.close((Closeable)fos);
            }
            Closer.close((Closeable)fos);
            try {
                fis = new FileInputStream(new File("library.index.next-edition"));
                BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                try {
                    this.edition = Long.parseLong(br.readLine());
                }
                catch (NumberFormatException e) {
                    this.edition = 0L;
                }
                Logger.debug((Object)this, (String)("Edition: " + this.edition));
                fis.close();
                fis = null;
            }
            catch (IOException e) {
                this.edition = 0L;
            }
            finally {
                Closer.close((Closeable)fis);
            }
        }
        return this.privURI;
    }

    synchronized FreenetURI getPrivateUSK() {
        return this.loadSSKURIs().setKeyType("USK").setDocName("index.yml").setSuggestedEdition(this.edition);
    }

    synchronized FreenetURI getPublicUSK() {
        this.loadSSKURIs();
        return this.pubURI.setKeyType("USK").setDocName("index.yml").setSuggestedEdition(this.getLastUploadedEdition());
    }

    private synchronized long getLastUploadedEdition() {
        return this.edition - 1L;
    }
}

