/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util;

import java.util.Arrays;
import plugins.Library.util.PrefixTree;

public abstract class BytePrefixKey<K extends BytePrefixKey<K>>
extends PrefixTree.AbstractPrefixKey<K>
implements PrefixTree.PrefixKey<K> {
    protected final byte[] hash;
    private transient String str_ = null;

    public static String bytesToHex(byte[] hash) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < hash.length; ++i) {
            int h = hash[i] >> 4 & 0xF;
            int l = hash[i] & 0xF;
            buf.append((char)(0 <= h && h <= 9 ? 48 + h : 97 + h - 10));
            buf.append((char)(0 <= l && l <= 9 ? 48 + l : 97 + l - 10));
        }
        return buf.toString();
    }

    public static byte[] hexToBytes(String hex) {
        byte[] bs = new byte[hex.length() >> 1];
        int j = 0;
        for (int i = 0; i < bs.length; ++i) {
            int hi;
            char h = hex.charAt(j++);
            char l = hex.charAt(j++);
            int n = '0' <= h && h <= '9' ? h - 48 : ('a' <= h && h <= 'f' ? h - 97 + 10 : (hi = 'A' <= h && h <= 'F' ? h - 65 + 10 : (int)BytePrefixKey.err(h)));
            int li = '0' <= l && l <= '9' ? l - 48 : ('a' <= l && l <= 'f' ? l - 97 + 10 : ('A' <= l && l <= 'F' ? l - 65 + 10 : (int)BytePrefixKey.err(l)));
            bs[i] = (byte)(hi << 4 | li);
        }
        return bs;
    }

    private static byte err(char c) {
        throw new IllegalArgumentException("Invalid character in string: " + c);
    }

    protected BytePrefixKey(int s) {
        this.hash = new byte[s];
    }

    protected BytePrefixKey(int s, byte[] h) {
        if (h.length != s) {
            throw new IllegalArgumentException("Byte array must be " + s + " bits long.");
        }
        this.hash = new byte[s];
        for (int i = 0; i < h.length; ++i) {
            this.hash[i] = h[i];
        }
    }

    public String toString() {
        if (this.str_ == null) {
            this.str_ = BytePrefixKey.bytesToHex(this.hash);
        }
        return this.str_;
    }

    public String toByteString() {
        return new String(this.hash);
    }

    @Override
    public abstract BytePrefixKey<K> clone();

    @Override
    public int symbols() {
        return 256;
    }

    @Override
    public int size() {
        return this.hash.length;
    }

    @Override
    public int get(int i) {
        return this.hash[i] & 0xFF;
    }

    @Override
    public void set(int i, int v) {
        this.hash[i] = (byte)v;
    }

    @Override
    public void clear(int i) {
        this.hash[i] = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BytePrefixKey) {
            return Arrays.equals(this.hash, ((BytePrefixKey)o).hash);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.hash);
    }
}

