/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.concurrent;

import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;

public class BoundedPriorityBlockingQueue<E>
extends PriorityBlockingQueue<E> {
    int maxSize;
    protected final Object fullLock = new Object();

    public BoundedPriorityBlockingQueue(int capacity) {
        super(capacity);
        this.maxSize = capacity;
    }

    public BoundedPriorityBlockingQueue(int capacity, Comparator<E> comp) {
        super(capacity, comp);
        this.maxSize = capacity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(E o) {
        Object object = this.fullLock;
        synchronized (object) {
            if (super.size() < this.maxSize) {
                super.offer(o);
                return;
            }
            do {
                try {
                    this.fullLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (super.size() >= this.maxSize);
            super.offer(o);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o, long timeout, TimeUnit unit) {
        Object object = this.fullLock;
        synchronized (object) {
            if (super.size() < this.maxSize) {
                super.offer(o);
                return true;
            }
            long waitTime = unit.toMillis(timeout);
            if (waitTime <= 0L) {
                waitTime = 0L;
            }
            long now = System.currentTimeMillis();
            long end = now + waitTime;
            while (now < end) {
                try {
                    this.fullLock.wait((int)Math.min(Integer.MAX_VALUE, end - now));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (super.size() < this.maxSize) {
                    super.offer(o);
                    return true;
                }
                now = System.currentTimeMillis();
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean offer(E o) {
        Object object = this.fullLock;
        synchronized (object) {
            if (super.size() < this.maxSize) {
                super.offer(o);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll() {
        Object o = super.poll();
        if (o == null) {
            return null;
        }
        Object object = this.fullLock;
        synchronized (object) {
            this.fullLock.notifyAll();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        Object o = super.poll(timeout, unit);
        if (o == null) {
            return null;
        }
        Object object = this.fullLock;
        synchronized (object) {
            this.fullLock.notifyAll();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public E take() throws InterruptedException {
        Object o = super.take();
        Object object = this.fullLock;
        synchronized (object) {
            this.fullLock.notifyAll();
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int remainingCapacity() {
        Object object = this.fullLock;
        synchronized (object) {
            return this.maxSize - this.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean remove(Object o) {
        if (super.remove(o)) {
            Object object = this.fullLock;
            synchronized (object) {
                this.fullLock.notifyAll();
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c) {
        int moved = super.drainTo(c);
        if (moved > 0) {
            Object object = this.fullLock;
            synchronized (object) {
                this.fullLock.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int drainTo(Collection<? super E> c, int maxElements) {
        int moved = super.drainTo(c, maxElements);
        if (moved > 0) {
            Object object = this.fullLock;
            synchronized (object) {
                this.fullLock.notifyAll();
            }
        }
        return moved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        super.clear();
        Object object = this.fullLock;
        synchronized (object) {
            this.fullLock.notifyAll();
        }
    }

    @Override
    public Iterator<E> iterator() {
        final Iterator underlying = super.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return underlying.hasNext();
            }

            @Override
            public E next() {
                return underlying.next();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void remove() {
                underlying.remove();
                Object object = BoundedPriorityBlockingQueue.this.fullLock;
                synchronized (object) {
                    BoundedPriorityBlockingQueue.this.fullLock.notifyAll();
                }
            }
        };
    }
}

