/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.concurrent;

import freenet.support.Logger;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import plugins.Library.util.concurrent.ExceptionConvertor;
import plugins.Library.util.concurrent.Notifier;
import plugins.Library.util.concurrent.Scheduler;
import plugins.Library.util.func.Closure;
import plugins.Library.util.func.SafeClosure;
import plugins.Library.util.func.Tuples;

public class ObjectProcessor<T, E, X extends Exception>
implements Scheduler {
    protected final BlockingQueue<T> in;
    protected final BlockingQueue<Tuples.X2<T, X>> out;
    protected final Map<T, E> dep;
    protected final Closure<T, X> clo;
    protected final Executor exec;
    protected final ExceptionConvertor<X> convertor;
    protected Notifier notifier;
    protected volatile boolean open = true;
    protected int dispatched = 0;
    protected int completed = 0;
    protected int started = 0;
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    private final WeakReference<ObjectProcessor> myRef = new WeakReference<ObjectProcessor>(this);
    public static final int default_maxconc = 40;
    int maxconc = 40;
    protected final SafeClosure<Tuples.X2<T, X>> postProcess = new SafeClosure<Tuples.X2<T, X>>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void invoke(Tuples.X2<T, X> res) {
            try {
                ObjectProcessor.this.out.put(res);
                if (ObjectProcessor.this.notifier != null) {
                    ObjectProcessor.this.notifier.notifyUpdate();
                }
                ObjectProcessor objectProcessor = ObjectProcessor.this;
                synchronized (objectProcessor) {
                    ++ObjectProcessor.this.completed;
                }
            }
            catch (InterruptedException e) {
                throw new UnsupportedOperationException();
            }
        }
    };
    private static final ConcurrentMap<WeakReference<ObjectProcessor>, Boolean> pending;
    private static Thread auto;
    protected String name;

    public int outputCapacity() {
        return this.out.remainingCapacity();
    }

    public int outputSize() {
        return this.out.size();
    }

    public ObjectProcessor(BlockingQueue<T> input, BlockingQueue<Tuples.X2<T, X>> output, Map<T, E> deposit, Closure<T, X> closure, Executor executor, ExceptionConvertor<X> conv, Notifier n) {
        this.in = input;
        this.out = output;
        this.dep = deposit;
        this.clo = closure;
        this.exec = executor;
        this.convertor = conv;
        this.notifier = n;
    }

    public ObjectProcessor(BlockingQueue<T> input, BlockingQueue<Tuples.X2<T, X>> output, Map<T, E> deposit, Closure<T, X> closure, Executor executor, ExceptionConvertor<X> conv) {
        this(input, output, deposit, closure, executor, conv, null);
    }

    public void setNotifier(Notifier n) {
        this.notifier = n;
    }

    public synchronized void setMaxConc(int x) {
        this.maxconc = x;
    }

    public static <T, E, X extends Exception> void submitSafe(ObjectProcessor<T, E, X> proc, T item, E deposit) {
        try {
            proc.submit(item, deposit);
        }
        catch (InterruptedException e) {
            throw new IllegalArgumentException("ObjectProcessor: abuse of submitSafe(). Blame the programmer, who did not know what they were doing", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(T item, E deposit) throws InterruptedException {
        ObjectProcessor objectProcessor = this;
        synchronized (objectProcessor) {
            if (!this.open) {
                throw new IllegalStateException("ObjectProcessor: not open");
            }
            if (this.dep.containsKey(item)) {
                throw new IllegalArgumentException("ObjectProcessor: object " + item + " already submitted");
            }
            this.dep.put(item, deposit);
        }
        this.in.put(item);
    }

    public synchronized void update(T item, E deposit) {
        if (!this.open) {
            throw new IllegalStateException("ObjectProcessor: not open");
        }
        if (!this.dep.containsKey(item)) {
            throw new IllegalArgumentException("ObjectProcessor: object " + item + " not yet submitted");
        }
        this.dep.put(item, deposit);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Tuples.X3<T, E, X> accept() throws InterruptedException {
        Tuples.X2<T, X> item = this.out.take();
        ObjectProcessor objectProcessor = this;
        synchronized (objectProcessor) {
            return Tuples.X3(item._0, this.dep.remove(item._0), item._1);
        }
    }

    public synchronized boolean hasPending() {
        return !this.dep.isEmpty();
    }

    public synchronized boolean hasCompleted() {
        return !this.out.isEmpty();
    }

    public synchronized int size() {
        return this.dep.size();
    }

    public synchronized void dispatchTake() throws InterruptedException {
        throw new UnsupportedOperationException("not implemented");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchPoll() {
        ObjectProcessor objectProcessor = this;
        synchronized (objectProcessor) {
            if (this.dispatched - this.completed >= this.maxconc) {
                return false;
            }
        }
        Object item = this.in.poll();
        ObjectProcessor objectProcessor2 = this;
        synchronized (objectProcessor2) {
            if (item == null) {
                return false;
            }
            this.exec.execute(this.createJobFor(item));
            ++this.dispatched;
            return true;
        }
    }

    protected Runnable createJobFor(final T item) {
        if (this.clo == null) {
            throw new IllegalStateException("ObjectProcessor: no closure given, but createJobFor() was not overidden");
        }
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Exception ex = null;
                ObjectProcessor objectProcessor = ObjectProcessor.this;
                synchronized (objectProcessor) {
                    ++ObjectProcessor.this.started;
                }
                Object ee = null;
                try {
                    ObjectProcessor.this.clo.invoke(item);
                }
                catch (RuntimeException e) {
                    Logger.error((Object)this, (String)("Caught " + e), (Throwable)e);
                    System.err.println("In ObjProc-" + ObjectProcessor.this.name + " : " + e);
                    e.printStackTrace();
                    ex = ObjectProcessor.this.convertor.convert(e);
                }
                catch (Exception e) {
                    ex = e;
                }
                ObjectProcessor.this.postProcess.invoke(Tuples.X2(item, ex));
            }
        };
    }

    private static synchronized void ensureAutoHandler() {
        if (auto != null) {
            return;
        }
        auto = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            @Override
            public void run() {
                int timeout = 4;
                int t = 4;
                while (true) {
                    if (!pending.isEmpty()) {
                        t = 4;
                    } else if (t-- <= 0) throw new AssertionError((Object)"ObjectProcessor: bad exit in autohandler. this is a bug; please report.");
                    Iterator it = pending.keySet().iterator();
                    while (it.hasNext()) {
                        WeakReference ref = (WeakReference)it.next();
                        ObjectProcessor proc = (ObjectProcessor)ref.get();
                        if (proc == null) {
                            it.remove();
                            continue;
                        }
                        try {
                            boolean o = proc.open;
                            while (proc.dispatchPoll()) {
                            }
                            if (o) continue;
                            it.remove();
                        }
                        catch (RejectedExecutionException e) {
                            Logger.error((Object)this, (String)"REJECTED EXECUTION", (Throwable)e);
                        }
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (t > 0) continue;
                    Class<ObjectProcessor> clazz = ObjectProcessor.class;
                    // MONITORENTER : plugins.Library.util.concurrent.ObjectProcessor.class
                    if (pending.isEmpty()) {
                        auto = null;
                        // MONITOREXIT : clazz
                        return;
                    }
                    // MONITOREXIT : clazz
                }
            }
        };
        auto.start();
    }

    public boolean auto() {
        Boolean r = pending.put(this.myRef, Boolean.TRUE);
        ObjectProcessor.ensureAutoHandler();
        return r == null;
    }

    public ObjectProcessor autostart() {
        this.auto();
        return this;
    }

    @Override
    public void close() {
        this.open = false;
    }

    public void finalize() {
        this.close();
    }

    public void setName(String n) {
        this.name = n;
    }

    public String toString() {
        return "ObjProc-" + this.name + ":{" + this.size() + "|" + this.dispatched + "|" + this.started + "|" + this.completed + "}";
    }

    static {
        Logger.registerClass(ObjectProcessor.class);
        pending = new ConcurrentHashMap<WeakReference<ObjectProcessor>, Boolean>();
        auto = null;
    }
}

