/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.confluence.block;

import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.confluence.block.AbstractConfluenceDelimitedBlock;

public class ExtendedQuoteBlock
extends AbstractConfluenceDelimitedBlock {
    private int paraLine = 0;
    private boolean paraOpen = false;

    public ExtendedQuoteBlock() {
        super("quote");
    }

    @Override
    protected void resetState() {
        super.resetState();
        this.paraOpen = false;
        this.paraLine = 0;
    }

    @Override
    protected void beginBlock() {
        Attributes attributes = new Attributes();
        this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, attributes);
    }

    @Override
    protected void endBlock() {
        if (this.paraOpen) {
            this.builder.endBlock();
            this.paraLine = 0;
            this.paraOpen = false;
        }
        this.builder.endBlock();
    }

    @Override
    protected void handleBlockContent(String content) {
        if (this.blockLineCount == 1 && content.length() == 0) {
            return;
        }
        if (this.dialect.isEmptyLine(content) && this.blockLineCount > 1 && this.paraOpen) {
            this.builder.endBlock();
            this.paraOpen = false;
            this.paraLine = 0;
            return;
        }
        if (!this.paraOpen) {
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            this.paraOpen = true;
        }
        if (this.paraLine != 0) {
            this.builder.lineBreak();
        }
        ++this.paraLine;
        this.getDialect().emitMarkupLine(this.getParser(), this.state, content, 0);
    }

    @Override
    protected void setOption(String key, String value) {
    }
}

