/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.confluence.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;

public class ListBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 2;
    static final Pattern startPattern = Pattern.compile("((?:(?:\\*)|(?:#)|(?:-))+)\\s(.*+)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            Attributes attributes = new Attributes();
            String listSpec = this.matcher.group(1);
            int level = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(listSpec);
            if (type == DocumentBuilder.BlockType.BULLETED_LIST && "-".equals(listSpec)) {
                attributes.setCssStyle("list-style: square");
            }
            offset = this.matcher.start(2);
            this.listState.push(new ListState(1, type));
            this.builder.beginBlock(type, attributes);
            this.adjustLevel(listSpec, level, type);
        } else {
            Matcher matcher = startPattern.matcher(line);
            if (!matcher.matches()) {
                this.setClosed(true);
                return 0;
            }
            String listSpec = matcher.group(1);
            int level = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(listSpec);
            offset = matcher.start(2);
            this.adjustLevel(listSpec, level, type);
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (listState.openItem) {
            this.builder.endBlock();
        }
        listState.openItem = true;
        this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        this.dialect.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private void adjustLevel(String listSpec, int level, DocumentBuilder.BlockType type) {
        ListState previousState = this.listState.peek();
        while (level != previousState.level || previousState.type != type) {
            Attributes blockAttributes;
            if (level > previousState.level) {
                if (!previousState.openItem) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
                    previousState.openItem = true;
                }
                blockAttributes = new Attributes();
                if (type == DocumentBuilder.BlockType.BULLETED_LIST && "-".equals(listSpec)) {
                    blockAttributes.setCssStyle("list-style: square");
                }
                this.listState.push(new ListState(previousState.level + 1, type));
                this.builder.beginBlock(type, blockAttributes);
            } else {
                this.closeOne();
                if (this.listState.isEmpty()) {
                    blockAttributes = new Attributes();
                    if (type == DocumentBuilder.BlockType.BULLETED_LIST && "-".equals(listSpec)) {
                        blockAttributes.setCssStyle("list-style: square");
                    }
                    this.listState.push(new ListState(1, type));
                    this.builder.beginBlock(type, blockAttributes);
                }
            }
            previousState = this.listState.peek();
        }
    }

    private int calculateLevel(String listSpec) {
        return listSpec.length();
    }

    private DocumentBuilder.BlockType calculateType(String listSpec) {
        return listSpec.charAt(listSpec.length() - 1) == '#' ? DocumentBuilder.BlockType.NUMERIC_LIST : DocumentBuilder.BlockType.BULLETED_LIST;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.listState = null;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class ListState {
        int level;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(int level, DocumentBuilder.BlockType type) {
            this.level = level;
            this.type = type;
        }
    }
}

