/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.mediawiki;

import java.util.ArrayList;
import java.util.List;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.Dialect;
import net.java.textilej.parser.markup.mediawiki.block.HeadingBlock;
import net.java.textilej.parser.markup.mediawiki.block.ListBlock;
import net.java.textilej.parser.markup.mediawiki.block.ParagraphBlock;
import net.java.textilej.parser.markup.mediawiki.block.PreformattedBlock;
import net.java.textilej.parser.markup.mediawiki.block.TableBlock;
import net.java.textilej.parser.markup.mediawiki.phrase.EscapePhraseModifier;
import net.java.textilej.parser.markup.mediawiki.phrase.SimplePhraseModifier;
import net.java.textilej.parser.markup.mediawiki.token.EntityReferenceReplacementToken;
import net.java.textilej.parser.markup.mediawiki.token.HyperlinkExternalReplacementToken;
import net.java.textilej.parser.markup.mediawiki.token.HyperlinkInternalReplacementToken;
import net.java.textilej.parser.markup.mediawiki.token.ImageReplacementToken;
import net.java.textilej.parser.markup.mediawiki.token.LineBreakToken;
import net.java.textilej.parser.markup.mediawiki.token.TemplateReplacementToken;
import net.java.textilej.parser.markup.phrase.HtmlCommentPhraseModifier;
import net.java.textilej.parser.markup.phrase.LimitedHtmlEndTagPhraseModifier;
import net.java.textilej.parser.markup.phrase.LimitedHtmlStartTagPhraseModifier;
import net.java.textilej.parser.markup.token.ImpliedHyperlinkReplacementToken;
import net.java.textilej.parser.markup.token.PatternLiteralReplacementToken;

public class MediaWikiDialect
extends Dialect {
    private List<Block> blocks = new ArrayList<Block>();
    private List<Block> paragraphBreakingBlocks = new ArrayList<Block>();
    private static Dialect.PatternBasedSyntax tokenSyntax = new Dialect.PatternBasedSyntax();
    private static Dialect.PatternBasedSyntax phraseModifierSyntax = new Dialect.PatternBasedSyntax();
    private String internalPageHrefPrefix = "/wiki/";

    public MediaWikiDialect() {
        this.blocks.add(new HeadingBlock());
        this.blocks.add(new ListBlock());
        this.blocks.add(new PreformattedBlock());
        this.blocks.add(new TableBlock());
        ParagraphBlock paragraphBlock = new ParagraphBlock();
        this.blocks.add(paragraphBlock);
        for (Block block : this.blocks) {
            if (block == paragraphBlock) continue;
            this.paragraphBreakingBlocks.add(block);
        }
    }

    @Override
    protected Dialect.PatternBasedSyntax getPhraseModifierSyntax() {
        return phraseModifierSyntax;
    }

    @Override
    protected Dialect.PatternBasedSyntax getReplacementTokenSyntax() {
        return tokenSyntax;
    }

    @Override
    public List<Block> getBlocks() {
        return this.blocks;
    }

    public List<Block> getParagraphBreakingBlocks() {
        return this.paragraphBreakingBlocks;
    }

    public String toInternalHref(String pageName) {
        String pageId = pageName.replace(' ', '_');
        if (pageId.startsWith(":")) {
            pageId = pageId.substring(1);
        } else if (pageId.startsWith("#")) {
            return pageId;
        }
        return this.internalPageHrefPrefix + pageId;
    }

    public String getInternalPageHrefPrefix() {
        return this.internalPageHrefPrefix;
    }

    public void setInternalPageHrefPrefix(String internalPageHrefPrefix) {
        this.internalPageHrefPrefix = internalPageHrefPrefix;
    }

    static {
        phraseModifierSyntax.beginGroup("(?:(?<=[\\s\\.,\\\"'?!;:\\)\\(\\{\\}\\[\\]])|^)(?:", 0);
        phraseModifierSyntax.add(new EscapePhraseModifier());
        phraseModifierSyntax.add(new SimplePhraseModifier("'''''", new DocumentBuilder.SpanType[]{DocumentBuilder.SpanType.BOLD, DocumentBuilder.SpanType.ITALIC}, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("'''", DocumentBuilder.SpanType.BOLD, true));
        phraseModifierSyntax.add(new SimplePhraseModifier("''", DocumentBuilder.SpanType.ITALIC, true));
        phraseModifierSyntax.endGroup(")(?=\\W|$)", 0);
        String[] allowedHtmlTags = new String[]{"b", "big", "blockquote", "caption", "center", "cite", "code", "dd", "del", "div", "dl", "dt", "em", "font", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "i", "ins", "li", "ol", "p", "pre", "rb", "rp", "rt", "ruby", "s", "small", "span", "strike", "strong", "sub", "sup", "table", "td", "th", "tr", "tt", "u", "ul", "var"};
        phraseModifierSyntax.add(new LimitedHtmlEndTagPhraseModifier(allowedHtmlTags));
        phraseModifierSyntax.add(new LimitedHtmlStartTagPhraseModifier(allowedHtmlTags));
        phraseModifierSyntax.add(new HtmlCommentPhraseModifier());
        tokenSyntax.add(new LineBreakToken());
        tokenSyntax.add(new net.java.textilej.parser.markup.token.EntityReferenceReplacementToken("(tm)", "#8482"));
        tokenSyntax.add(new net.java.textilej.parser.markup.token.EntityReferenceReplacementToken("(TM)", "#8482"));
        tokenSyntax.add(new net.java.textilej.parser.markup.token.EntityReferenceReplacementToken("(c)", "#169"));
        tokenSyntax.add(new net.java.textilej.parser.markup.token.EntityReferenceReplacementToken("(C)", "#169"));
        tokenSyntax.add(new net.java.textilej.parser.markup.token.EntityReferenceReplacementToken("(r)", "#174"));
        tokenSyntax.add(new net.java.textilej.parser.markup.token.EntityReferenceReplacementToken("(R)", "#174"));
        tokenSyntax.add(new ImageReplacementToken());
        tokenSyntax.add(new HyperlinkInternalReplacementToken());
        tokenSyntax.add(new HyperlinkExternalReplacementToken());
        tokenSyntax.add(new ImpliedHyperlinkReplacementToken());
        tokenSyntax.add(new PatternLiteralReplacementToken("(?:(?<=\\w\\s)(----)(?=\\s\\w))", "<hr/>"));
        tokenSyntax.add(new TemplateReplacementToken());
        tokenSyntax.add(new EntityReferenceReplacementToken());
    }
}

