/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.mediawiki.token;

import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;

public class HyperlinkReplacementToken
extends PatternBasedElement {
    @Override
    protected String getPattern(int groupOffset) {
        return "(?:(\"|\\!)([^\"]+)\\" + (1 + groupOffset) + ":([^\\s]+))";
    }

    @Override
    protected int getPatternGroupCount() {
        return 3;
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new HyperlinkReplacementTokenProcessor();
    }

    private static class HyperlinkReplacementTokenProcessor
    extends PatternBasedElementProcessor {
        private HyperlinkReplacementTokenProcessor() {
        }

        @Override
        public void emit() {
            String hyperlinkBoundaryText = this.group(1);
            String hyperlinkSrc = this.group(2);
            String href = this.group(3);
            if (hyperlinkBoundaryText.equals("\"")) {
                this.builder.link(href, hyperlinkSrc);
            } else {
                this.builder.imageLink(href, hyperlinkSrc);
            }
        }
    }
}

