/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.mediawiki.token;

import java.util.HashMap;
import java.util.Map;
import net.java.textilej.parser.markup.PatternBasedElement;
import net.java.textilej.parser.markup.PatternBasedElementProcessor;

public class TemplateReplacementToken
extends PatternBasedElement {
    private static Map<String, Class<? extends PatternBasedElementProcessor>> processorByTemplate = new HashMap<String, Class<? extends PatternBasedElementProcessor>>();

    @Override
    protected String getPattern(int groupOffset) {
        return "(\\{\\{([^\\s]+)\\}\\})";
    }

    @Override
    protected int getPatternGroupCount() {
        return 2;
    }

    @Override
    protected PatternBasedElementProcessor newProcessor() {
        return new DispatchingProcessor();
    }

    static {
        processorByTemplate.put("endash", EndashElementProcessor.class);
        processorByTemplate.put("ndash", EndashElementProcessor.class);
        processorByTemplate.put("mdash", EmdashElementProcessor.class);
        processorByTemplate.put("emdash", EmdashElementProcessor.class);
    }

    public static class EmdashElementProcessor
    extends PatternBasedElementProcessor {
        @Override
        public void emit() {
            this.getBuilder().entityReference("nbsp");
            this.getBuilder().entityReference("mdash");
            this.getBuilder().characters(" ");
        }
    }

    public static class EndashElementProcessor
    extends PatternBasedElementProcessor {
        @Override
        public void emit() {
            this.getBuilder().entityReference("nbsp");
            this.getBuilder().entityReference("ndash");
            this.getBuilder().characters(" ");
        }
    }

    private static class DispatchingProcessor
    extends PatternBasedElementProcessor {
        private DispatchingProcessor() {
        }

        @Override
        public void emit() {
            Class processor = (Class)processorByTemplate.get(this.group(2));
            if (processor == null) {
                this.getBuilder().characters(this.group(1));
            } else {
                PatternBasedElementProcessor delegate;
                try {
                    delegate = (PatternBasedElementProcessor)processor.newInstance();
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
                delegate.setLineStartOffset(this.getLineStartOffset());
                delegate.setLineEndOffset(this.getLineEndOffset());
                delegate.setParser(this.getParser());
                delegate.setState(this.getState());
                delegate.setGroup(1, this.group(1), this.start(1), this.end(1));
                delegate.setGroup(2, this.group(2), this.start(2), this.end(2));
                delegate.emit();
            }
        }
    }
}

