/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.markup.block.GlossaryBlock;

public class TextileGlossaryBlock
extends GlossaryBlock {
    static final Pattern startPattern = Pattern.compile("\\s*\\{glossary(?::([^\\}]+))?\\}\\s*");
    private Matcher matcher;

    @Override
    public int processLineContent(String line, int offset) {
        String options;
        if (this.blockLineNumber == 0 && (options = this.matcher.group(1)) != null) {
            String[] optionPairs;
            for (String optionPair : optionPairs = options.split("\\s*\\|\\s*")) {
                String[] keyValue = optionPair.split("\\s*=\\s*");
                if (keyValue.length != 2) continue;
                String key = keyValue[0].trim();
                String value = keyValue[1].trim();
                if (!key.equals("style")) continue;
                this.setStyle(value);
            }
        }
        return super.processLineContent(line, offset);
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }
}

