/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.util.anttask;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import net.java.textilej.parser.MarkupParser;
import net.java.textilej.parser.builder.HtmlDocumentBuilder;
import net.java.textilej.parser.markup.textile.TextileDialect;
import net.java.textilej.util.XmlStreamWriter;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class TextileToHtmlTask
extends Task {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    protected String htmlFilenameFormat = "$1.html";
    protected boolean overwrite = true;
    private List<Stylesheet> stylesheets = new ArrayList<Stylesheet>();
    protected File file;
    protected String title;
    private boolean useInlineCssStyles = true;
    private boolean suppressBuiltInCssStyles = false;

    public void execute() throws BuildException {
        if (this.file == null && this.filesets.isEmpty()) {
            throw new BuildException("Please add one or more source filesets or specify @file");
        }
        if (this.file != null && !this.filesets.isEmpty()) {
            throw new BuildException("@file may not be specified if filesets are also specified");
        }
        if (this.file != null) {
            if (!this.file.exists()) {
                throw new BuildException(String.format("File cannot be found: %s", this.file));
            }
            if (!this.file.isFile()) {
                throw new BuildException(String.format("Not a file: %s", this.file));
            }
            if (!this.file.canRead()) {
                throw new BuildException(String.format("Cannot read file: %s", this.file));
            }
        }
        for (Stylesheet stylesheet : this.stylesheets) {
            if (stylesheet.url == null && stylesheet.file == null) {
                throw new BuildException("Must specify one of @file or @url on <stylesheet>");
            }
            if (stylesheet.url != null && stylesheet.file != null) {
                throw new BuildException("May only specify one of @file or @url on <stylesheet>");
            }
            if (stylesheet.file == null) continue;
            if (!stylesheet.file.exists()) {
                throw new BuildException("Stylesheet file does not exist: " + stylesheet.file);
            }
            if (!stylesheet.file.isFile()) {
                throw new BuildException("Referenced stylesheet is not a file: " + stylesheet.file);
            }
            if (stylesheet.file.canRead()) continue;
            throw new BuildException("Cannot read stylesheet: " + stylesheet.file);
        }
        for (FileSet fileset : this.filesets) {
            File filesetBaseDir = fileset.getDir(this.getProject());
            DirectoryScanner ds = fileset.getDirectoryScanner(this.getProject());
            String[] files = ds.getIncludedFiles();
            if (files == null) continue;
            File baseDir = ds.getBasedir();
            for (String file : files) {
                File inputFile = new File(baseDir, file);
                try {
                    this.processFile(filesetBaseDir, inputFile);
                }
                catch (BuildException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot process file '%s': %s", inputFile, e.getMessage()), (Throwable)e);
                }
            }
        }
        if (this.file != null) {
            try {
                this.processFile(this.file.getParentFile(), this.file);
            }
            catch (BuildException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot process file '%s': %s", this.file, e.getMessage()), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String processFile(File baseDir, File source) throws BuildException {
        File htmlOutputFile;
        this.log(String.format("Processing file '%s'", source), 3);
        String textile = null;
        String name = source.getName();
        if (name.lastIndexOf(46) != -1) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        if (!(htmlOutputFile = this.computeHtmlFile(source, name)).exists() || this.overwrite || htmlOutputFile.lastModified() < source.lastModified()) {
            OutputStreamWriter writer;
            if (textile == null) {
                textile = this.readFully(source);
            }
            try {
                writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(new FileOutputStream(htmlOutputFile)), "utf-8");
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", htmlOutputFile, e.getMessage()), (Throwable)e);
            }
            try {
                HtmlDocumentBuilder builder = new HtmlDocumentBuilder(writer){

                    @Override
                    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
                        return super.createFormattingXmlStreamWriter(out);
                    }
                };
                builder.setUseInlineStyles(this.useInlineCssStyles);
                builder.setSuppressBuiltInStyles(this.suppressBuiltInCssStyles);
                for (Stylesheet stylesheet : this.stylesheets) {
                    if (stylesheet.url != null) {
                        builder.addCssStylesheet(stylesheet.url);
                        continue;
                    }
                    builder.addCssStylesheet(stylesheet.file);
                }
                builder.setTitle(this.title == null ? name : this.title);
                MarkupParser parser = new MarkupParser();
                parser.setDialect(new TextileDialect());
                parser.setBuilder(builder);
                builder.setEmitDtd(true);
                parser.parse(textile);
            }
            catch (Throwable throwable) {
                try {
                    ((Writer)writer).close();
                }
                catch (Exception e) {
                    throw new BuildException(String.format("Cannot write to file '%s': %s", htmlOutputFile, e.getMessage()), (Throwable)e);
                }
                throw throwable;
            }
            try {
                ((Writer)writer).close();
            }
            catch (Exception e) {
                throw new BuildException(String.format("Cannot write to file '%s': %s", htmlOutputFile, e.getMessage()), (Throwable)e);
            }
        }
        return textile;
    }

    protected File computeHtmlFile(File source, String name) {
        return new File(source.getParentFile(), this.htmlFilenameFormat.replace("$1", name));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readFully(File inputFile) {
        StringWriter w = new StringWriter();
        try (InputStreamReader r = new InputStreamReader(new BufferedInputStream(new FileInputStream(inputFile)));){
            int i;
            while ((i = ((Reader)r).read()) != -1) {
                w.write((char)i);
            }
        }
        catch (IOException e) {
            throw new BuildException(String.format("Cannot read file '%s': %s", inputFile, e.getMessage()), (Throwable)e);
        }
        return w.toString();
    }

    public String getHtmlFilenameFormat() {
        return this.htmlFilenameFormat;
    }

    public void setHtmlFilenameFormat(String htmlFilenameFormat) {
        this.htmlFilenameFormat = htmlFilenameFormat;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void addStylesheet(Stylesheet stylesheet) {
        if (stylesheet == null) {
            throw new IllegalArgumentException();
        }
        this.stylesheets.add(stylesheet);
    }

    public boolean isUseInlineCssStyles() {
        return this.useInlineCssStyles;
    }

    public void setUseInlineCssStyles(boolean useInlineCssStyles) {
        this.useInlineCssStyles = useInlineCssStyles;
    }

    public boolean isSuppressBuiltInCssStyles() {
        return this.suppressBuiltInCssStyles;
    }

    public void setSuppressBuiltInCssStyles(boolean suppressBuiltInCssStyles) {
        this.suppressBuiltInCssStyles = suppressBuiltInCssStyles;
    }

    public static class Stylesheet {
        private File file;
        private String url;

        public File getFile() {
            return this.file;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }
}

