/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.defragment;

import com.db4o.Db4o;
import com.db4o.config.Configuration;
import com.db4o.defragment.ContextIDMapping;
import com.db4o.defragment.StoredClassFilter;
import com.db4o.defragment.TreeIDMapping;
import com.db4o.ext.StoredClass;
import com.db4o.internal.Config4Impl;

public class DefragmentConfig {
    public static final boolean DEBUG = false;
    public static final String BACKUP_SUFFIX = "backup";
    private String _origPath;
    private String _backupPath;
    private String _tempPath;
    private ContextIDMapping _mapping;
    private Configuration _config;
    private StoredClassFilter _storedClassFilter = null;
    private boolean _forceBackupDelete = false;
    private boolean _readOnly = true;
    private int _objectCommitFrequency;
    private static final StoredClassFilter NULLFILTER = new NullFilter();

    public DefragmentConfig(String origPath) {
        this(origPath, origPath + "." + BACKUP_SUFFIX);
    }

    public DefragmentConfig(String origPath, String backupPath) {
        this(origPath, backupPath, new TreeIDMapping());
    }

    public DefragmentConfig(String origPath, String backupPath, ContextIDMapping mapping) {
        this._origPath = origPath;
        this._backupPath = backupPath;
        this._mapping = mapping;
    }

    public String origPath() {
        return this._origPath;
    }

    public String backupPath() {
        return this._backupPath;
    }

    public ContextIDMapping mapping() {
        return this._mapping;
    }

    public StoredClassFilter storedClassFilter() {
        return this._storedClassFilter == null ? NULLFILTER : this._storedClassFilter;
    }

    public void storedClassFilter(StoredClassFilter storedClassFilter) {
        this._storedClassFilter = storedClassFilter;
    }

    public boolean forceBackupDelete() {
        return this._forceBackupDelete;
    }

    public void forceBackupDelete(boolean forceBackupDelete) {
        this._forceBackupDelete = forceBackupDelete;
    }

    public void readOnly(boolean flag) {
        this._readOnly = flag;
    }

    public boolean readOnly() {
        return this._readOnly;
    }

    public Configuration db4oConfig() {
        if (this._config == null) {
            this._config = DefragmentConfig.vanillaDb4oConfig(1);
        }
        return this._config;
    }

    public void db4oConfig(Configuration config) {
        this._config = config;
    }

    public int objectCommitFrequency() {
        return this._objectCommitFrequency;
    }

    public void objectCommitFrequency(int objectCommitFrequency) {
        this._objectCommitFrequency = objectCommitFrequency;
    }

    public void upgradeFile(String tempPath) {
        this._tempPath = tempPath;
    }

    public boolean fileNeedsUpgrade() {
        return this._tempPath != null;
    }

    public String tempPath() {
        return this._tempPath != null ? this._tempPath : this._backupPath;
    }

    public int blockSize() {
        return ((Config4Impl)this.db4oConfig()).blockSize();
    }

    public static Configuration vanillaDb4oConfig(int blockSize) {
        Configuration config = Db4o.newConfiguration();
        config.weakReferences(false);
        config.blockSize(blockSize);
        return config;
    }

    public Configuration clonedDb4oConfig() {
        return (Configuration)((Config4Impl)this.db4oConfig()).deepClone(null);
    }

    protected static class NullFilter
    implements StoredClassFilter {
        protected NullFilter() {
        }

        @Override
        public boolean accept(StoredClass storedClass) {
            return true;
        }
    }
}

