/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.foundation;

public final class BitMap4 {
    private final byte[] _bits;

    public BitMap4(int numBits) {
        this._bits = new byte[this.byteCount(numBits)];
    }

    public BitMap4(byte[] buffer, int pos, int numBits) {
        this(numBits);
        System.arraycopy(buffer, pos, this._bits, 0, this._bits.length);
    }

    public BitMap4(byte singleByte) {
        this._bits = new byte[]{singleByte};
    }

    public boolean isTrue(int bit) {
        return (this._bits[this.arrayOffset(bit)] >>> this.byteOffset(bit) & 1) != 0;
    }

    public boolean isFalse(int bit) {
        return !this.isTrue(bit);
    }

    public int marshalledLength() {
        return this._bits.length;
    }

    public void setFalse(int bit) {
        int n = this.arrayOffset(bit);
        this._bits[n] = (byte)(this._bits[n] & (byte)(~this.bitMask(bit)));
    }

    public void set(int bit, boolean val) {
        if (val) {
            this.setTrue(bit);
        } else {
            this.setFalse(bit);
        }
    }

    public void setTrue(int bit) {
        int n = this.arrayOffset(bit);
        this._bits[n] = (byte)(this._bits[n] | this.bitMask(bit));
    }

    public void writeTo(byte[] bytes, int pos) {
        System.arraycopy(this._bits, 0, bytes, pos, this._bits.length);
    }

    private byte byteOffset(int bit) {
        return (byte)(bit % 8);
    }

    private int arrayOffset(int bit) {
        return bit / 8;
    }

    private byte bitMask(int bit) {
        return (byte)(1 << this.byteOffset(bit));
    }

    private int byteCount(int numBits) {
        return (numBits + 7) / 8;
    }

    public byte getByte(int index) {
        return this._bits[index];
    }

    public byte[] bytes() {
        return this._bits;
    }
}

