/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.tools;

import com.db4o.Db4o;
import com.db4o.ObjectContainer;
import com.db4o.config.Configuration;
import com.db4o.ext.StoredClass;
import com.db4o.foundation.Tree;
import com.db4o.foundation.Visitor4;
import com.db4o.internal.ReflectPlatform;
import com.db4o.internal.TreeInt;
import com.db4o.internal.TreeString;
import com.db4o.internal.TreeStringObject;
import java.io.File;

public class Statistics {
    private static final String REMOVE = "XXxxREMOVExxXX";

    public static void main(String[] args) {
        if (args == null || args.length != 1) {
            System.out.println("Usage: java com.db4o.tools.Statistics <database filename>");
        } else {
            new Statistics().run(args[0]);
        }
    }

    public void run(String filename) {
        if (new File(filename).exists()) {
            ObjectContainer con = null;
            try {
                Configuration config = Db4o.newConfiguration();
                config.messageLevel(-1);
                con = Db4o.openFile(config, filename);
                this.printHeader("STATISTICS");
                System.out.println("File: " + filename);
                this.printStats(con, filename);
                con.close();
            }
            catch (Exception e) {
                System.out.println("Statistics failed for file: '" + filename + "'");
                System.out.println(e.getMessage());
                e.printStackTrace();
            }
        } else {
            System.out.println("File not found: '" + filename + "'");
        }
    }

    private static boolean canCallConstructor(String className) {
        return ReflectPlatform.createInstance(className) != null;
    }

    private void printStats(ObjectContainer con, String filename) {
        Tree unavailable = new TreeString(REMOVE);
        Tree noConstructor = new TreeString(REMOVE);
        StoredClass[] internalClasses = con.ext().storedClasses();
        for (int i = 0; i < internalClasses.length; ++i) {
            String internalClassName = internalClasses[i].getName();
            Class clazz = ReflectPlatform.forName(internalClassName);
            if (clazz == null) {
                unavailable = unavailable.add(new TreeString(internalClassName));
                continue;
            }
            if (Statistics.canCallConstructor(internalClassName)) continue;
            noConstructor = noConstructor.add(new TreeString(internalClassName));
        }
        unavailable = unavailable.removeLike(new TreeString(REMOVE));
        noConstructor = noConstructor.removeLike(new TreeString(REMOVE));
        if (unavailable != null) {
            this.printHeader("UNAVAILABLE");
            unavailable.traverse(new Visitor4(){

                @Override
                public void visit(Object obj) {
                    System.out.println(((TreeString)obj)._key);
                }
            });
        }
        if (noConstructor != null) {
            this.printHeader("NO PUBLIC CONSTRUCTOR");
            noConstructor.traverse(new Visitor4(){

                @Override
                public void visit(Object obj) {
                    System.out.println(((TreeString)obj)._key);
                }
            });
        }
        this.printHeader("CLASSES");
        System.out.println("Number of objects per class:");
        final Tree.ByRef ids = new Tree.ByRef(new TreeInt(0));
        if (internalClasses.length > 0) {
            Tree all = new TreeStringObject(internalClasses[0].getName(), internalClasses[0]);
            for (int i = 1; i < internalClasses.length; ++i) {
                all = all.add(new TreeStringObject(internalClasses[i].getName(), internalClasses[i]));
            }
            all.traverse(new Visitor4(){

                @Override
                public void visit(Object obj) {
                    TreeStringObject node = (TreeStringObject)obj;
                    long[] newIDs = ((StoredClass)node._object).getIDs();
                    for (int j = 0; j < newIDs.length; ++j) {
                        if (ids.value.find(new TreeInt((int)newIDs[j])) != null) continue;
                        ids.value = ids.value.add(new TreeInt((int)newIDs[j]));
                    }
                    System.out.println(node._key + ": " + newIDs.length);
                }
            });
        }
        this.printHeader("SUMMARY");
        System.out.println("File: " + filename);
        System.out.println("Stored classes: " + internalClasses.length);
        if (unavailable != null) {
            System.out.println("Unavailable classes: " + unavailable.size());
        }
        if (noConstructor != null) {
            System.out.println("Classes without public constructors: " + noConstructor.size());
        }
        System.out.println("Total number of objects: " + (ids.value.size() - 1));
    }

    private void printHeader(String str) {
        int i;
        int stars = (39 - str.length()) / 2;
        System.out.println("\n");
        for (i = 0; i < stars; ++i) {
            System.out.print("*");
        }
        System.out.print(" " + str + " ");
        for (i = 0; i < stars; ++i) {
            System.out.print("*");
        }
        System.out.println();
    }
}

