/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.collections;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.RecordNumberBinding;
import com.sleepycat.collections.BaseIterator;
import com.sleepycat.collections.BlockIterator;
import com.sleepycat.collections.DataCursor;
import com.sleepycat.collections.DataView;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredCollection;
import com.sleepycat.collections.StoredContainer;
import com.sleepycat.collections.StoredIterator;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseEntry;
import com.sleepycat.je.OperationStatus;
import com.sleepycat.util.keyrange.KeyRangeException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StoredList<E>
extends StoredCollection<E>
implements List<E> {
    private static final EntryBinding DEFAULT_KEY_BINDING = new IndexKeyBinding(1);
    private int baseIndex = 1;
    private boolean isSubList;

    public StoredList(Database database, EntryBinding<E> valueBinding, boolean writeAllowed) {
        super(new DataView(database, DEFAULT_KEY_BINDING, valueBinding, null, writeAllowed, null));
    }

    public StoredList(Database database, EntityBinding<E> valueEntityBinding, boolean writeAllowed) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, valueEntityBinding, writeAllowed, null));
    }

    public StoredList(Database database, EntryBinding<E> valueBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, valueBinding, null, true, keyAssigner));
    }

    public StoredList(Database database, EntityBinding<E> valueEntityBinding, PrimaryKeyAssigner keyAssigner) {
        super(new DataView(database, DEFAULT_KEY_BINDING, null, valueEntityBinding, true, keyAssigner));
    }

    private StoredList(DataView view, int baseIndex) {
        super(view);
        this.baseIndex = baseIndex;
        this.isSubList = true;
    }

    @Override
    public void add(int index, E value) {
        this.checkIterAddAllowed();
        DataCursor cursor = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.getSearchKey(index, null, false);
            if (status == OperationStatus.SUCCESS) {
                cursor.putBefore(value);
                this.closeCursor(cursor);
            } else {
                this.closeCursor(cursor);
                cursor = null;
                this.view.append(value, null, null);
            }
            this.commitAutoCommit(doAutoCommit);
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean add(E value) {
        this.checkIterAddAllowed();
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            this.view.append(value, null, null);
            this.commitAutoCommit(doAutoCommit);
            return true;
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    public int append(E value) {
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            Object[] key = new Object[1];
            this.view.append(value, key, null);
            this.commitAutoCommit(doAutoCommit);
            return ((Number)key[0]).intValue();
        }
        catch (Exception e) {
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    void checkIterAddAllowed() throws UnsupportedOperationException {
        if (this.isSubList) {
            throw new UnsupportedOperationException("cannot add to subList");
        }
        if (!this.view.keysRenumbered) {
            throw new UnsupportedOperationException("requires renumbered keys");
        }
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> coll) {
        this.checkIterAddAllowed();
        DataCursor cursor = null;
        Iterator i = null;
        boolean doAutoCommit = this.beginAutoCommit();
        try {
            i = this.storedOrExternalIterator(coll);
            if (!i.hasNext()) {
                return false;
            }
            cursor = new DataCursor(this.view, true);
            OperationStatus status = cursor.getSearchKey(index, null, false);
            if (status == OperationStatus.SUCCESS) {
                while (i.hasNext()) {
                    cursor.putBefore(i.next());
                }
                this.closeCursor(cursor);
            } else {
                this.closeCursor(cursor);
                cursor = null;
                while (i.hasNext()) {
                    this.view.append(i.next(), null, null);
                }
            }
            StoredIterator.close(i);
            this.commitAutoCommit(doAutoCommit);
            return true;
        }
        catch (Exception e) {
            this.closeCursor(cursor);
            StoredIterator.close(i);
            throw this.handleException(e, doAutoCommit);
        }
    }

    @Override
    public boolean contains(Object value) {
        return this.containsValue(value);
    }

    @Override
    public E get(int index) {
        return (E)this.getValue(index);
    }

    @Override
    public int indexOf(Object value) {
        return this.indexOf(value, true);
    }

    @Override
    public int lastIndexOf(Object value) {
        return this.indexOf(value, false);
    }

    private int indexOf(Object value, boolean findFirst) {
        int n;
        DataCursor cursor = null;
        try {
            cursor = new DataCursor(this.view, false);
            OperationStatus status = cursor.findValue(value, findFirst);
            n = status == OperationStatus.SUCCESS ? cursor.getCurrentRecordNumber() - this.baseIndex : -1;
            Object var7_7 = null;
        }
        catch (Exception e) {
            try {
                throw StoredContainer.convertException(e);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                this.closeCursor(cursor);
                throw throwable;
            }
        }
        this.closeCursor(cursor);
        return n;
    }

    @Override
    int getIndexOffset() {
        return this.baseIndex;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.blockIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        BlockIterator i = this.blockIterator();
        if (i.moveToIndex(index)) {
            return i;
        }
        throw new IndexOutOfBoundsException(String.valueOf(index));
    }

    @Override
    public E remove(int index) {
        try {
            Object[] oldVal = new Object[1];
            this.removeKey(index, oldVal);
            return (E)oldVal[0];
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public boolean remove(Object value) {
        return this.removeValue(value);
    }

    @Override
    public E set(int index, E value) {
        try {
            return (E)this.putKeyValue(index, value);
        }
        catch (IllegalArgumentException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex > toIndex) {
            throw new IndexOutOfBoundsException(String.valueOf(fromIndex));
        }
        try {
            int newBaseIndex = this.baseIndex + fromIndex;
            return new StoredList<E>(this.view.subView(fromIndex, true, toIndex, false, new IndexKeyBinding(newBaseIndex)), newBaseIndex);
        }
        catch (KeyRangeException e) {
            throw new IndexOutOfBoundsException(e.getMessage());
        }
        catch (Exception e) {
            throw StoredContainer.convertException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean equals(Object other) {
        boolean bl;
        ListIterator i2;
        StoredIterator i1;
        block20: {
            boolean bl2;
            block19: {
                boolean bl3;
                block18: {
                    boolean bl4;
                    block17: {
                        boolean bl5;
                        block16: {
                            boolean bl6;
                            block15: {
                                if (!(other instanceof List)) {
                                    return false;
                                }
                                List otherList = (List)other;
                                i1 = null;
                                i2 = null;
                                try {
                                    i1 = this.storedIterator();
                                    i2 = this.storedOrExternalListIterator(otherList);
                                    while (i1.hasNext()) {
                                        if (!i2.hasNext()) {
                                            bl6 = false;
                                            Object var9_11 = null;
                                            if (i1 != null) {
                                                i1.close();
                                            }
                                            break block15;
                                        }
                                        if (i1.nextIndex() != i2.nextIndex()) {
                                            bl5 = false;
                                            break block16;
                                        }
                                        Object o1 = i1.next();
                                        Object o2 = i2.next();
                                        if (o1 == null) {
                                            if (o2 == null) continue;
                                            bl4 = false;
                                            break block17;
                                        }
                                        if (o1.equals(o2)) continue;
                                        bl3 = false;
                                        break block18;
                                    }
                                    if (i2.hasNext()) {
                                        bl2 = false;
                                        break block19;
                                    }
                                    bl = true;
                                    break block20;
                                }
                                catch (Throwable throwable) {
                                    Object var9_17 = null;
                                    if (i1 != null) {
                                        i1.close();
                                    }
                                    StoredIterator.close(i2);
                                    throw throwable;
                                }
                            }
                            StoredIterator.close(i2);
                            return bl6;
                        }
                        Object var9_12 = null;
                        if (i1 != null) {
                            i1.close();
                        }
                        StoredIterator.close(i2);
                        return bl5;
                    }
                    Object var9_13 = null;
                    if (i1 != null) {
                        i1.close();
                    }
                    StoredIterator.close(i2);
                    return bl4;
                }
                Object var9_14 = null;
                if (i1 != null) {
                    i1.close();
                }
                StoredIterator.close(i2);
                return bl3;
            }
            Object var9_15 = null;
            if (i1 != null) {
                i1.close();
            }
            StoredIterator.close(i2);
            return bl2;
        }
        Object var9_16 = null;
        if (i1 != null) {
            i1.close();
        }
        StoredIterator.close(i2);
        return bl;
    }

    final ListIterator storedOrExternalListIterator(List list) {
        if (list instanceof StoredCollection) {
            return ((StoredCollection)((Object)list)).storedIterator();
        }
        return list.listIterator();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    E makeIteratorData(BaseIterator iterator, DatabaseEntry keyEntry, DatabaseEntry priKeyEntry, DatabaseEntry valueEntry) {
        return (E)this.view.makeValue(priKeyEntry, valueEntry);
    }

    @Override
    boolean hasValues() {
        return true;
    }

    private static class IndexKeyBinding
    extends RecordNumberBinding {
        private int baseIndex;

        private IndexKeyBinding(int baseIndex) {
            this.baseIndex = baseIndex;
        }

        public Long entryToObject(DatabaseEntry data) {
            return IndexKeyBinding.entryToRecordNumber(data) - (long)this.baseIndex;
        }

        public void objectToEntry(Long object, DatabaseEntry data) {
            IndexKeyBinding.recordNumberToEntry(((Number)object).intValue() + this.baseIndex, data);
        }
    }
}

