/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.mediawiki.block;

import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.mediawiki.MediaWikiDialect;

public class ParagraphBlock
extends Block {
    private int blockLineCount = 0;
    private Block nestedBlock = null;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            Attributes attributes = new Attributes();
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, attributes);
        } else if (this.nestedBlock != null) {
            int returnOffset = this.nestedBlock.processLine(line, offset);
            if (this.nestedBlock.isClosed()) {
                this.nestedBlock = null;
            }
            if (returnOffset >= 0) {
                offset = returnOffset;
                if (this.nestedBlock != null) {
                    throw new IllegalStateException();
                }
            } else {
                if (this.dialect.isEmptyLine(line)) {
                    this.setClosed(true);
                    return 0;
                }
                return returnOffset;
            }
        }
        if (this.dialect.isEmptyLine(line)) {
            this.setClosed(true);
            return 0;
        }
        MediaWikiDialect dialect = (MediaWikiDialect)this.getDialect();
        for (Block block : dialect.getParagraphBreakingBlocks()) {
            if (!block.canStart(line, offset)) continue;
            this.setClosed(true);
            return 0;
        }
        ++this.blockLineCount;
        if (this.nestedBlock != null) {
            if (this.blockLineCount > 1) {
                this.builder.lineBreak();
            }
            this.nestedBlock.processLine(line, offset);
        } else {
            if (offset == 0 && line.length() > 0 && line.charAt(0) == ' ') {
                this.setClosed(true);
                return 0;
            }
            if (this.blockLineCount != 1) {
                this.builder.characters("\n");
            }
            dialect.emitMarkupLine(this.getParser(), this.state, line, offset);
        }
        return -1;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        return true;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            if (this.nestedBlock != null) {
                this.nestedBlock.setClosed(closed);
                this.nestedBlock = null;
            }
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

