/*
 * Decompiled with CFR 0.152.
 */
package net.java.textilej.parser.markup.textile.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.Attributes;
import net.java.textilej.parser.DocumentBuilder;
import net.java.textilej.parser.QuoteAttributes;
import net.java.textilej.parser.markup.Block;
import net.java.textilej.parser.markup.textile.Textile;

public class QuoteBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP = 10;
    private static final int CITATION_GROUP = 9;
    private static final int EXTENDED_GROUP = 8;
    static final Pattern startPattern = Pattern.compile("bq(\\(+)?(\\)+)?(\\<|\\>|\\=|\\<\\>)?(?:(?:\\(([^#\\)]+)?(?:#([^\\)]+))?\\))|(?:\\{([^\\}]+)\\})|(?:\\[([^\\]]+)\\])){0,3}\\.(\\.)?(?::(https?://[^\\s]*))?\\s+(.*)");
    private boolean extended;
    private boolean paraOpen;
    private int blockLineCount = 0;
    private Matcher matcher;

    @Override
    public int processLineContent(String line, int offset) {
        if (this.blockLineCount == 0) {
            QuoteAttributes attributes = new QuoteAttributes();
            Textile.configureAttributes(attributes, this.matcher, 1, true);
            attributes.setCitation(this.matcher.group(9));
            offset = this.matcher.start(10);
            this.extended = this.matcher.group(8) != null;
            this.builder.beginBlock(DocumentBuilder.BlockType.QUOTE, attributes);
            this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
            this.paraOpen = true;
        }
        if (this.dialect.isEmptyLine(line)) {
            if (!this.extended) {
                this.setClosed(true);
                return 0;
            }
            if (this.paraOpen) {
                this.builder.endBlock();
                this.paraOpen = false;
            }
            return 0;
        }
        if (this.extended && Textile.explicitBlockBegins(line, offset)) {
            this.setClosed(true);
            return offset;
        }
        if (this.blockLineCount != 0) {
            if (this.paraOpen) {
                this.builder.lineBreak();
            } else {
                this.builder.beginBlock(DocumentBuilder.BlockType.PARAGRAPH, new Attributes());
                this.paraOpen = true;
            }
        }
        ++this.blockLineCount;
        this.getDialect().emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    @Override
    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        if (lineOffset == 0) {
            this.matcher = startPattern.matcher(line);
            return this.matcher.matches();
        }
        this.matcher = null;
        return false;
    }

    @Override
    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            if (this.paraOpen) {
                this.builder.endBlock();
                this.paraOpen = false;
            }
            this.builder.endBlock();
        }
        super.setClosed(closed);
    }
}

