/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite;

import freenet.client.HighLevelSimpleClient;
import freenet.keys.FreenetURI;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Random;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.java.textilej.parser.MarkupParser;
import net.java.textilej.parser.builder.HtmlDocumentBuilder;
import net.java.textilej.parser.markup.textile.TextileDialect;
import plugins.Sharesite.Plugin;
import plugins.Sharesite.common.SmartMap;

public class Freesite
implements Comparable<Freesite> {
    private String name;
    private String path;
    private Integer insertHour;
    private String description;
    private String text;
    private String css;
    private String activelinkUri;
    private String requestSSK;
    private String insertSSK;
    private long edition;
    private String l10nStatus;
    private String l10nStatusChangeToOnRestart;
    private int uniqueKey;

    public Freesite(int uniqueKey) {
        String line;
        StringBuilder sb;
        Throwable throwable;
        BufferedReader reader;
        Throwable throwable2;
        InputStream is;
        this.uniqueKey = uniqueKey;
        this.name = "Sharesite freesite";
        this.path = "sharesite-freesite";
        Random r = new Random();
        this.insertHour = r.nextInt(24);
        this.description = "Write a short description shown in search results here.";
        this.activelinkUri = "";
        String csstemplate = "/templates/style.css";
        String texttemplate = "/templates/content.txt";
        try {
            is = Plugin.class.getClassLoader().getResourceAsStream(csstemplate);
            throwable2 = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is));
                throwable = null;
                try {
                    sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    reader.close();
                    this.css = sb.toString();
                }
                catch (Throwable x2) {
                    throwable = x2;
                    throw x2;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Throwable x2) {
                throwable2 = x2;
                throw x2;
            }
            finally {
                if (is != null) {
                    if (throwable2 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.css = "";
        }
        try {
            is = Plugin.class.getClassLoader().getResourceAsStream(texttemplate);
            throwable2 = null;
            try {
                reader = new BufferedReader(new InputStreamReader(is));
                throwable = null;
                try {
                    sb = new StringBuilder();
                    while ((line = reader.readLine()) != null) {
                        sb.append(line + "\n");
                    }
                    reader.close();
                    this.text = sb.toString();
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    if (reader != null) {
                        if (throwable != null) {
                            try {
                                reader.close();
                            }
                            catch (Throwable x2) {
                                throwable.addSuppressed(x2);
                            }
                        } else {
                            reader.close();
                        }
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable2 = throwable4;
                throw throwable4;
            }
            finally {
                if (is != null) {
                    if (throwable2 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable x2) {
                            throwable2.addSuppressed(x2);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (Exception e) {
            this.text = "";
        }
        HighLevelSimpleClient simpleClient = Plugin.instance.pluginRespirator.getHLSimpleClient();
        FreenetURI[] keys = simpleClient.generateKeyPair("");
        this.requestSSK = keys[1].toString();
        this.insertSSK = keys[0].toString();
        this.edition = -1L;
        this.l10nStatus = "Status.New";
        this.l10nStatusChangeToOnRestart = "Status.New";
    }

    public synchronized String getName() {
        return this.name;
    }

    public synchronized void setName(String name) {
        this.name = name;
    }

    public synchronized String getPath() {
        if (this.path != null) {
            return this.path;
        }
        return this.name;
    }

    public synchronized void setPath(String path) {
        this.path = path;
    }

    public synchronized Integer getInsertHour() {
        if (this.insertHour != null) {
            return this.insertHour;
        }
        return -1;
    }

    public synchronized void setInsertHour(Integer insertHour) {
        if (insertHour.equals(-2)) {
            Random r = new Random();
            this.insertHour = r.nextInt(24);
        } else {
            this.insertHour = insertHour;
        }
    }

    public synchronized String getDescription() {
        return this.description;
    }

    public synchronized void setDescription(String description) {
        this.description = description;
    }

    public synchronized String getText() {
        return this.text;
    }

    public synchronized void setText(String text) {
        this.text = text;
    }

    public int getUniqueKey() {
        return this.uniqueKey;
    }

    public synchronized void setInsertSSK(String key) {
        this.insertSSK = key;
    }

    public synchronized void setRequestSSK(String key) {
        this.requestSSK = key;
    }

    public synchronized String getRequestSSK() {
        return this.requestSSK;
    }

    public synchronized String getInsertSSK() {
        return this.insertSSK;
    }

    public synchronized long getEdition() {
        return this.edition;
    }

    public synchronized void setEdition(long edition) {
        this.edition = edition;
    }

    public synchronized String getKeys() {
        BufferedReader br = new BufferedReader(new StringReader(this.text));
        StringBuffer buf = new StringBuffer();
        try {
            String line = "";
            while ((line = br.readLine()) != null) {
                Pattern key = Pattern.compile("(?<=/)((SSK|USK|CHK)@.*)");
                Matcher sm = key.matcher(line);
                if (!sm.find()) continue;
                String str = sm.group();
                str = str.replaceAll("jpg!", "jpg");
                str = str.replaceAll("JPG!", "JPG");
                str = str.replaceAll("jpeg!", "jpeg");
                str = str.replaceAll("JPEG!", "JPEG");
                str = str.replaceAll("gif!", "gif");
                str = str.replaceAll("GIF!", "GIF");
                str = str.replaceAll("png!", "png");
                str = str.replaceAll("PNG!", "PNG");
                str = str.replaceAll("%20", " ");
                buf.append(str + "\r\n");
            }
        }
        catch (IOException e) {
            Plugin.instance.logger.putstr(e.getMessage());
        }
        return buf.toString();
    }

    public synchronized String getHTML() throws Exception {
        String line;
        String descriptionHTML = Freesite.textToHTML(this.description);
        String content = Freesite.textToHTML(this.text);
        FreenetURI requestURI = new FreenetURI(this.requestSSK + this.path + "-" + (this.edition + 1L) + "/");
        FreenetURI uskURI = requestURI.uskForSSK();
        String nextEdition = uskURI.toString();
        long updateEdition = this.edition >= 0L ? -(this.edition + 1L) : -1L;
        String checkUpdates = uskURI.setSuggestedEdition(updateEdition).toString();
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        String insertDate = dateFormat.format(calendar.getTime());
        String template = "/templates/index.html";
        InputStream is = Plugin.class.getClassLoader().getResourceAsStream(template);
        if (is == null) {
            throw new Exception("Couldn't load \"" + template + "\"");
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        while ((line = reader.readLine()) != null) {
            line = line.replaceAll("\\$NAME\\$", Matcher.quoteReplacement(this.name));
            line = line.replaceAll("\\$DESCRIPTION\\$", Matcher.quoteReplacement(this.description));
            line = line.replaceAll("\\$DESCRIPTION_HTML\\$", Matcher.quoteReplacement(descriptionHTML));
            line = line.replaceAll("\\$CONTENT\\$", Matcher.quoteReplacement(content));
            line = line.replaceAll("\\$INSERT_URI\\$", Matcher.quoteReplacement(nextEdition));
            line = line.replaceAll("\\$CHECK_UPDATES_URI\\$", Matcher.quoteReplacement(checkUpdates));
            line = line.replaceAll("\\$INSERT_DATE\\$", Matcher.quoteReplacement(insertDate));
            sb.append(line + "\n");
        }
        reader.close();
        return sb.toString();
    }

    public synchronized void setCSS(String css) {
        this.css = css;
    }

    public synchronized String getCSS() {
        return this.css;
    }

    public synchronized String getActivelinkUri() {
        return this.activelinkUri;
    }

    public synchronized void setActivelinkUri(String activelinkUri) {
        this.activelinkUri = activelinkUri;
    }

    public synchronized String getStatus() {
        return Plugin.instance.l10n.getString("Sharesite." + this.l10nStatus);
    }

    public synchronized String getRealStatus() {
        return this.l10nStatus;
    }

    public void setL10nStatus(String status) {
        this.setL10nStatus(status, status);
    }

    public synchronized void setL10nStatus(String status, String changeToOnRestart) {
        this.l10nStatus = status;
        this.l10nStatusChangeToOnRestart = changeToOnRestart;
    }

    synchronized void save(SmartMap map) {
        String prefix = "collection-" + this.uniqueKey + "/";
        map.putstr(prefix + "name", this.name);
        map.putstr(prefix + "path", this.path);
        map.putint(prefix + "insertHour", this.insertHour);
        map.putstr(prefix + "description", this.description);
        map.putstr(prefix + "text", this.text);
        map.putstr(prefix + "css", this.css);
        map.putstr(prefix + "activelinkUri", this.activelinkUri);
        map.putstr(prefix + "requestSSK", this.requestSSK);
        map.putstr(prefix + "insertSSK", this.insertSSK);
        map.putlong(prefix + "edition", this.edition);
        map.putstr(prefix + "l10nStatus", this.l10nStatusChangeToOnRestart);
    }

    void load(SmartMap map, int uniqueKeyInMap) {
        String prefix = "collection-" + uniqueKeyInMap + "/";
        this.name = map.getstr(prefix + "name", this.name);
        this.path = map.getstr(prefix + "path", null);
        if (this.path == null) {
            this.path = this.name;
        }
        this.insertHour = map.getint(prefix + "insertHour", -1);
        this.description = map.getstr(prefix + "description", this.description);
        this.text = map.getstr(prefix + "text", this.text);
        this.css = map.getstr(prefix + "css", this.css);
        this.activelinkUri = map.getstr(prefix + "activelinkUri", this.activelinkUri);
        this.requestSSK = map.getstr(prefix + "requestSSK", this.requestSSK);
        this.insertSSK = map.getstr(prefix + "insertSSK", this.insertSSK);
        this.edition = map.getlong(prefix + "edition", this.edition);
        this.l10nStatusChangeToOnRestart = this.l10nStatus = map.getstr(prefix + "l10nStatus", this.l10nStatus);
    }

    private static String textToHTML(String text) {
        String html = "";
        try {
            StringWriter writer = new StringWriter();
            MarkupParser parser = new MarkupParser();
            parser.setDialect(new TextileDialect());
            HtmlDocumentBuilder builder = new HtmlDocumentBuilder(writer);
            builder.setEmitAsDocument(false);
            parser.setBuilder(builder);
            parser.parse(text);
            html = writer.toString();
            Plugin.instance.logger.putstr(html);
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            html = sw.toString();
            Plugin.instance.logger.putstr("textToHTML: " + e.getMessage());
        }
        return html;
    }

    @Override
    public int compareTo(Freesite other) {
        return this.uniqueKey - other.uniqueKey;
    }
}

