/*
 * Decompiled with CFR 0.152.
 */
package plugins.Sharesite;

import freenet.client.HighLevelSimpleClient;
import freenet.keys.FreenetURI;
import freenet.support.api.ManifestElement;
import freenet.support.io.ArrayBucket;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Locale;
import java.util.TimeZone;
import javax.imageio.ImageIO;
import plugins.Sharesite.ActivelinkCreator;
import plugins.Sharesite.Freesite;
import plugins.Sharesite.Plugin;

public class Inserter
extends Thread {
    private boolean running = true;
    private LinkedList<Freesite> queuedInserts = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            Freesite nextToInsert;
            Integer currentHour = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US).get(11);
            Inserter inserter = this;
            synchronized (inserter) {
                nextToInsert = null;
                if (!this.queuedInserts.isEmpty()) {
                    for (Freesite c : this.queuedInserts) {
                        if (c.getInsertHour() != null && !c.getInsertHour().equals(-1) && !c.getInsertHour().equals(currentHour)) continue;
                        nextToInsert = c;
                        this.queuedInserts.remove(c);
                        break;
                    }
                }
            }
            if (nextToInsert != null) {
                if (!nextToInsert.getInsertHour().equals(-1)) {
                    Integer currentMinute = Calendar.getInstance(TimeZone.getTimeZone("UTC"), Locale.US).get(12);
                    Integer waitTime = (int)(Math.random() * (double)(55 - currentMinute));
                    try {
                        if (waitTime > 0) {
                            Thread.sleep(waitTime * 60 * 1000);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                this.performInsert(nextToInsert);
            }
            try {
                inserter = this;
                synchronized (inserter) {
                    if (!this.running) {
                        break;
                    }
                    if (!this.queuedInserts.isEmpty()) {
                        continue;
                    }
                    this.wait();
                    continue;
                }
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public synchronized void terminate() {
        this.running = false;
        this.notify();
    }

    private synchronized boolean isTerminated() {
        return !this.running;
    }

    public synchronized void add(Freesite freesite) {
        freesite.setL10nStatus("Status.Queue", freesite.getRealStatus());
        this.queuedInserts.addLast(freesite);
        this.notify();
    }

    private void performInsert(Freesite c) {
        c.setL10nStatus("Status.Inserting", "Status.InsertFailed");
        Plugin.instance.database.save();
        try {
            HashMap<String, Object> bucketsByName = new HashMap<String, Object>();
            ArrayBucket html = new ArrayBucket(c.getHTML().getBytes("UTF-8"));
            ArrayBucket css = new ArrayBucket(c.getCSS().getBytes("UTF-8"));
            ArrayBucket text = new ArrayBucket(c.getText().getBytes("UTF-8"));
            ArrayBucket keys = new ArrayBucket(c.getKeys().getBytes("UTF-8"));
            if (c.getActivelinkUri().equals("")) {
                BufferedImage img = ActivelinkCreator.create(c.getName());
                ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
                ImageIO.write((RenderedImage)img, "PNG", baos);
                ArrayBucket activelinkData = new ArrayBucket(baos.toByteArray());
                Plugin.instance.logger.putstr("444");
                bucketsByName.put("activelink.png", activelinkData);
            } else {
                FreenetURI activelinkURI = new FreenetURI(c.getActivelinkUri());
                ManifestElement activelinkManifest = new ManifestElement("activelink.png", activelinkURI, null);
                bucketsByName.put("activelink.png", activelinkManifest);
            }
            bucketsByName.put("index.html", html);
            bucketsByName.put("style.css", css);
            bucketsByName.put("source.txt", text);
            bucketsByName.put("keys.txt", keys);
            String suffix = c.getPath() + "-" + (c.getEdition() + 1L);
            FreenetURI insertURI = new FreenetURI(c.getInsertSSK() + suffix);
            insertURI = insertURI.uskForSSK();
            HighLevelSimpleClient simpleClient = Plugin.instance.pluginRespirator.getHLSimpleClient();
            Plugin.instance.logger.putstr(insertURI + ": Insert starting");
            FreenetURI resultURI = simpleClient.insertManifest(insertURI, bucketsByName, "index.html", (short)1);
            if (this.isTerminated()) {
                return;
            }
            c.setL10nStatus("Status.Current");
            c.setEdition(resultURI.getEdition());
            Plugin.instance.database.save();
            Plugin.instance.logger.putstr(insertURI + ": Insert finished");
        }
        catch (Exception e) {
            c.setL10nStatus("Status.InsertFailed");
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            Plugin.instance.logger.putstr(e.getMessage());
        }
    }
}

