/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library;

import freenet.client.FetchContext;
import freenet.client.FetchException;
import freenet.client.FetchResult;
import freenet.client.FetchWaiter;
import freenet.client.HighLevelSimpleClient;
import freenet.client.async.ClientContext;
import freenet.client.async.ClientGetCallback;
import freenet.client.async.ClientGetter;
import freenet.client.async.PersistenceDisabledException;
import freenet.client.async.USKCallback;
import freenet.client.async.USKManager;
import freenet.client.async.USKRetriever;
import freenet.client.async.USKRetrieverCallback;
import freenet.client.events.ClientEvent;
import freenet.client.events.ClientEventListener;
import freenet.client.events.ExpectedMIMEEvent;
import freenet.keys.FreenetURI;
import freenet.keys.USK;
import freenet.node.NodeClientCore;
import freenet.node.RequestClient;
import freenet.pluginmanager.PluginRespirator;
import freenet.pluginmanager.PluginStore;
import freenet.support.Executor;
import freenet.support.Logger;
import freenet.support.io.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.MalformedURLException;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import plugins.Library.Index;
import plugins.Library.client.FreenetArchiver;
import plugins.Library.index.ProtoIndex;
import plugins.Library.index.ProtoIndexSerialiser;
import plugins.Library.index.xml.URLUpdateHook;
import plugins.Library.index.xml.XMLIndex;
import plugins.Library.io.ObjectStreamReader;
import plugins.Library.io.ObjectStreamWriter;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.search.InvalidSearchException;
import plugins.Library.util.exec.TaskAbortException;

public final class Library
implements URLUpdateHook {
    public static final String BOOKMARK_PREFIX = "bookmark:";
    public static final String DEFAULT_INDEX_SITE = "bookmark:liberty-of-information bookmark:free-market-free-people bookmark:gotcha bookmark:wanna bookmark:wanna.old bookmark:gogo";
    private static int version = 36;
    public static final String plugName = "Library " + Library.getVersion();
    private static Library lib;
    private final PluginRespirator pr;
    private final Executor exec;
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;
    public static final RequestClient REQUEST_CLIENT;
    private final PluginStore store;
    static final String STOREKEY = "indexuris";
    private Map<String, String> bookmarks = new HashMap<String, String>();
    private Map<String, BookmarkCallback> bookmarkCallbacks = new HashMap<String, BookmarkCallback>();
    final RequestClient rcBulk = new RequestClient(){

        public boolean persistent() {
            return false;
        }

        public boolean realTimeFlag() {
            return false;
        }
    };

    public static String getPlugName() {
        return plugName;
    }

    public static long getVersion() {
        return version;
    }

    public static synchronized Library init(PluginRespirator pr) {
        if (lib != null) {
            throw new IllegalStateException("Library already initialised");
        }
        lib = new Library(pr);
        return lib;
    }

    private Library(PluginRespirator pr) {
        PluginStore ps;
        this.pr = pr;
        if (pr != null) {
            this.exec = pr.getNode().executor;
            try {
                ps = pr.getStore();
            }
            catch (PersistenceDisabledException e) {
                ps = null;
            }
        } else {
            this.exec = null;
            ps = null;
        }
        USKManager uskManager = pr.getNode().clientCore.clientContext.uskManager;
        this.store = ps;
        if (this.store != null && this.store.subStores.containsKey(STOREKEY)) {
            for (Map.Entry entry : ((PluginStore)this.store.subStores.get((Object)STOREKEY)).strings.entrySet()) {
                String name = (String)entry.getKey();
                String target = (String)entry.getValue();
                this.bookmarks.put(name, target);
            }
        }
        File persistentFile = new File("LibraryPersistent");
        boolean migrated = false;
        if (persistentFile.canRead()) {
            try {
                ObjectInputStream is = new ObjectInputStream(new FileInputStream(persistentFile));
                this.bookmarks = (Map)is.readObject();
                is.close();
                FileUtil.secureDelete((File)persistentFile);
                Logger.error((Object)this, (String)"Moved LibraryPersistent contents into database and securely deleted old file.");
                migrated = true;
            }
            catch (ClassNotFoundException ex) {
                Logger.error((Object)this, (String)"Error trying to read bookmarks Map from file.", (Throwable)ex);
            }
            catch (IOException ex) {
                Logger.normal((Object)this, (String)"Error trying to read Library persistent data.", (Throwable)ex);
            }
        }
        boolean needNewWanna = false;
        for (Map.Entry<String, String> entry : this.bookmarks.entrySet()) {
            USK u;
            FreenetURI uri;
            long edition;
            String target;
            String name;
            block25: {
                name = entry.getKey();
                target = entry.getValue();
                if (name.equals("wanna") && target.startsWith("USK@5hH~39FtjA7A9")) {
                    name = "wanna.old";
                    needNewWanna = true;
                }
                edition = -1L;
                try {
                    uri = new FreenetURI(target);
                    if (!uri.isUSK()) break block25;
                    edition = uri.getEdition();
                }
                catch (MalformedURLException e) {
                    Logger.error((Object)this, (String)("Invalid bookmark URI: " + target + " for " + name), (Throwable)e);
                    continue;
                }
            }
            if (!uri.isUSK()) continue;
            BookmarkCallback callback = new BookmarkCallback(name, uri.getAllMetaStrings(), edition);
            this.bookmarkCallbacks.put(name, callback);
            try {
                u = USK.create((FreenetURI)uri);
            }
            catch (MalformedURLException e) {
                Logger.error((Object)this, (String)("Invalid bookmark USK: " + target + " for " + name), (Throwable)e);
                continue;
            }
            uskManager.subscribe(u, (USKCallback)callback, false, this.rcBulk);
            callback.ret = uskManager.subscribeContent(u, (USKRetrieverCallback)callback, false, pr.getHLSimpleClient().getFetchContext(), (short)2, this.rcBulk);
        }
        if (this.bookmarks.isEmpty() || needNewWanna || !this.bookmarks.containsKey("gotcha") || !this.bookmarks.containsKey("liberty-of-information") || !this.bookmarks.containsKey("free-market-free-people")) {
            if (!this.bookmarks.containsKey("liberty-of-information")) {
                this.addBookmark("liberty-of-information", "USK@5YCPzcs60uab6VSdiKcyvo-G-r-ga2UWCyOzWHaPoYE,a1zEPCf0qkUFQxftFZK5xmxYdxt0JErDb2aJgwG8s~4,AQACAAE/index.yml/25");
            }
            if (!this.bookmarks.containsKey("free-market-free-people")) {
                this.addBookmark("free-market-free-people", "USK@X4lMQ51bXPSicAgbR~XdFzDyizYHYrvzStdeUrIFhes,0ze4TAqd~RdAMZMsshybHZFema3ZP3id4sgN3H8969g,AQACAAE/index.yml/4");
            }
            if (!this.bookmarks.containsKey("gotcha")) {
                this.addBookmark("gotcha", "USK@zcAnAgT-xp5LnnK28-Lc7Qt-GU7pNKnVdkmU4-HCCBc,s2jiTh8~O9MtnGdVqJqgnKGrXrosK8rArcZ8A49hprY,AQACAAE/index.yml/6");
            }
            if (!this.bookmarks.containsKey("wanna.old")) {
                this.addBookmark("wanna.old", "USK@5hH~39FtjA7A9~VXWtBKI~prUDTuJZURudDG0xFn3KA,GDgRGt5f6xqbmo-WraQtU54x4H~871Sho9Hz6hC-0RA,AQACAAE/Search/25/index.xml");
            }
            if (!this.bookmarks.containsKey("freenetindex")) {
                this.addBookmark("freenetindex", "USK@US6gHsNApDvyShI~sBHGEOplJ3pwZUDhLqTAas6rO4c,3jeU5OwV0-K4B6HRBznDYGvpu2PRUuwL0V110rn-~8g,AQACAAE/freenet-index/5/index.xml");
            }
            if (!this.bookmarks.containsKey("gogo")) {
                this.addBookmark("gogo", "USK@shmVvDhwivG1z1onSA5efRl3492Xyoov52hrC0tF6uI,wpMhseMpFHPLpXYbV8why1nfBXf2XdSQkzVaemFOEsA,AQACAAE/index.yml/51");
            }
            if (!this.bookmarks.containsKey("wanna")) {
                this.addBookmark("wanna", "USK@gxuHPaicqxlpPPagBKPVPraZ4bwLdMYBc5vipkWGh3E,08ExdmvZzB8Hfi6H6crbiuCd2~ikWDIpJ8dvr~tLp7k,AQACAAE/index.yml/82");
            }
            migrated = true;
            Logger.normal((Object)this, (String)"Added default indexes");
        }
        if (migrated) {
            this.saveState();
        }
    }

    public synchronized void saveState() {
        if (this.store == null) {
            return;
        }
        PluginStore inner = (PluginStore)this.store.subStores.get(STOREKEY);
        if (inner == null) {
            inner = new PluginStore();
            this.store.subStores.put(STOREKEY, inner);
        }
        inner.strings.clear();
        inner.strings.putAll(this.bookmarks);
        try {
            this.pr.putStore(this.store);
            if (logMINOR) {
                Logger.minor((Object)this, (String)"Stored state to database");
            }
        }
        catch (PersistenceDisabledException persistenceDisabledException) {
            // empty catch block
        }
    }

    public Class<?> getIndexType(FreenetURI indexuri) throws FetchException {
        if (indexuri.lastMetaString() != null && indexuri.lastMetaString().equals("index.xml")) {
            return XMLIndex.class;
        }
        if (indexuri.lastMetaString() != null && indexuri.lastMetaString().equals("index.yml")) {
            return ProtoIndex.class;
        }
        if (indexuri.isUSK() && indexuri.getDocName().equals("index.yml")) {
            return ProtoIndex.class;
        }
        NodeClientCore core = this.pr.getNode().clientCore;
        HighLevelSimpleClient hlsc = core.makeClient((short)1, false, false);
        List<FreenetURI> uris = Arrays.asList(indexuri, indexuri.pushMetaString(""), indexuri.pushMetaString("index.yml"), indexuri.pushMetaString("index.xml"));
        for (FreenetURI uri : uris) {
            for (int i = 0; i < 5; ++i) {
                ClientContext cctx = core.clientContext;
                FetchContext fctx = hlsc.getFetchContext();
                FetchWaiter fw = new FetchWaiter(REQUEST_CLIENT);
                final ClientGetter gu = hlsc.fetch(uri, 65536L, (ClientGetCallback)fw, fctx);
                gu.setPriorityClass((short)1, cctx);
                final Class[] c = new Class[1];
                hlsc.addEventHook(new ClientEventListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void receive(ClientEvent ce, ClientContext context) {
                        if (!(ce instanceof ExpectedMIMEEvent)) {
                            return;
                        }
                        Class[] classArray = c;
                        synchronized (c) {
                            String type = ((ExpectedMIMEEvent)ce).expectedMIMEType;
                            Logger.normal((Object)this, (String)("Expected type in index: " + type));
                            try {
                                c[0] = Library.this.getIndexTypeFromMIME(type);
                                gu.cancel(context);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                // empty catch block
                            }
                            return;
                        }
                    }
                });
                try {
                    FetchResult res = fw.waitForCompletion();
                    return this.getIndexTypeFromMIME(res.getMimeType());
                }
                catch (FetchException e) {
                    if (e.getMode() == FetchException.FetchExceptionMode.CANCELLED) {
                        Class[] classArray = c;
                        synchronized (c) {
                            if (c[0] != null) {
                                // ** MonitorExit[var14_15] (shouldn't be in output)
                                return c[0];
                            }
                            throw new UnsupportedOperationException("Unable to get mime type or got an invalid mime type for index");
                        }
                    }
                    if (e.newURI == null) continue;
                    uri = e.newURI;
                    continue;
                }
            }
        }
        throw new UnsupportedOperationException("Could not find appropriate data for index");
    }

    public Class<?> getIndexTypeFromMIME(String mime) {
        if (mime.equals("text/yaml")) {
            return ProtoIndex.class;
        }
        if (mime.equals("application/xml")) {
            return XMLIndex.class;
        }
        throw new UnsupportedOperationException("Unknown mime-type for index: " + mime);
    }

    public Class<?> getIndexType(File f) {
        if (f.getName().endsWith(".yml")) {
            return ProtoIndex.class;
        }
        if (f.isDirectory() && new File(f, "index.xml").canRead()) {
            return XMLIndex.class;
        }
        throw new UnsupportedOperationException("Could not determine default index file under the path given: " + f);
    }

    public Object getAddressTypeFromString(String indexuri) {
        try {
            FreenetURI tempURI = new FreenetURI(indexuri);
            return tempURI;
        }
        catch (MalformedURLException e) {
            File file = new File(indexuri);
            if (file.canRead()) {
                return file;
            }
            throw new UnsupportedOperationException("Could not recognise index type from string: " + indexuri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String addBookmark(String name, String uri) {
        String old;
        FreenetURI u;
        USK uskNew = null;
        BookmarkCallback callback = null;
        long edition = -1L;
        try {
            u = new FreenetURI(uri);
            if (u.isUSK()) {
                uskNew = USK.create((FreenetURI)u);
                edition = uskNew.suggestedEdition;
            }
        }
        catch (MalformedURLException e) {
            Logger.error((Object)this, (String)("Invalid new uri " + uri));
            return null;
        }
        Library library = this;
        synchronized (library) {
            old = this.bookmarks.put(name, uri);
            callback = this.bookmarkCallbacks.get(name);
            if (callback == null) {
                callback = new BookmarkCallback(name, u.getAllMetaStrings(), edition);
                this.bookmarkCallbacks.put(name, callback);
                old = null;
            }
            this.saveState();
        }
        boolean isSame = false;
        USKManager uskManager = this.pr.getNode().clientCore.clientContext.uskManager;
        if (old != null) {
            try {
                FreenetURI uold = new FreenetURI(old);
                if (uold.isUSK()) {
                    USK usk = USK.create((FreenetURI)uold);
                    if (uskNew == null || !usk.equals((Object)uskNew, false)) {
                        uskManager.unsubscribe(usk, (USKCallback)callback);
                        uskManager.unsubscribeContent(usk, callback.ret, true);
                    } else {
                        isSame = true;
                    }
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (!isSame) {
            uskManager.subscribe(uskNew, (USKCallback)callback, false, this.rcBulk);
            callback.ret = uskManager.subscribeContent(uskNew, (USKRetrieverCallback)callback, false, this.pr.getHLSimpleClient().getFetchContext(), (short)2, this.rcBulk);
        }
        return name;
    }

    public synchronized void removeBookmark(String name) {
        this.bookmarks.remove(name);
        this.saveState();
    }

    public synchronized String getBookmark(String bm) {
        return this.bookmarks.get(bm);
    }

    public Set<String> bookmarkKeys() {
        return Collections.unmodifiableSet(this.bookmarks.keySet());
    }

    public final ArrayList<Index> getIndices(String indexuris) throws InvalidSearchException, TaskAbortException {
        String[] uris = indexuris.split("[ ;]");
        ArrayList<Index> indices = new ArrayList<Index>(uris.length);
        for (String uri : uris) {
            indices.add(this.getIndex(uri, null));
        }
        return indices;
    }

    public final Index getIndex(String indexuri) throws InvalidSearchException, TaskAbortException {
        return this.getIndex(indexuri, null);
    }

    public final Index getIndex(String indexuri, String origIndexName) throws InvalidSearchException, TaskAbortException {
        Object indexkey;
        Logger.normal((Object)this, (String)("Getting index " + indexuri));
        indexuri = indexuri.trim();
        if (indexuri.startsWith(BOOKMARK_PREFIX)) {
            if (this.bookmarks.containsKey(indexuri = indexuri.substring(BOOKMARK_PREFIX.length()))) {
                return this.getIndex(this.bookmarks.get(indexuri), indexuri);
            }
            throw new InvalidSearchException("Index bookmark '" + indexuri + " does not exist");
        }
        try {
            indexkey = this.getAddressTypeFromString(indexuri);
        }
        catch (UnsupportedOperationException e) {
            throw new TaskAbortException("Did not recognise index type in : \"" + indexuri + "\"", e);
        }
        long edition = -1L;
        try {
            Index index;
            Class<?> indextype;
            if (indexkey instanceof File) {
                indextype = this.getIndexType((File)indexkey);
            } else if (indexkey instanceof FreenetURI) {
                FreenetURI uri = (FreenetURI)indexkey;
                if (uri.isUSK()) {
                    edition = uri.getEdition();
                }
                indextype = this.getIndexType(uri);
            } else {
                throw new AssertionError();
            }
            if (indextype == ProtoIndex.class) {
                Serialiser.PullTask<ProtoIndex> task = new Serialiser.PullTask<ProtoIndex>(indexkey);
                ProtoIndexSerialiser.forIndex(indexkey, (short)1).pull(task);
                index = (Index)task.data;
            } else if (indextype == XMLIndex.class) {
                index = new XMLIndex(indexuri, edition, this.pr, this, origIndexName);
            } else {
                throw new AssertionError();
            }
            Logger.normal((Object)this, (String)("Loaded index type " + indextype.getName() + " at " + indexuri));
            return index;
        }
        catch (FetchException e) {
            throw new TaskAbortException("Failed to fetch index " + indexuri + " : " + (Object)((Object)e), e, true);
        }
        catch (UnsupportedOperationException e) {
            throw new TaskAbortException("Failed to parse index  " + indexuri + " : " + e, e);
        }
        catch (RuntimeException e) {
            throw new TaskAbortException("Failed to load index  " + indexuri + " : " + e, e);
        }
    }

    public static <T> FreenetArchiver<T> makeArchiver(ObjectStreamReader r, ObjectStreamWriter w, String mime, int size, short priorityClass) {
        if (lib == null || Library.lib.pr == null) {
            throw new IllegalStateException("Cannot archive to freenet without a fully live Library plugin connected to a freenet node.");
        }
        return new FreenetArchiver(Library.lib.pr.getNode().clientCore, r, w, mime, size, priorityClass);
    }

    public static <T, S extends ObjectStreamWriter & ObjectStreamReader> FreenetArchiver<T> makeArchiver(S rw, String mime, int size, short priorityClass) {
        return Library.makeArchiver(rw, rw, mime, size, priorityClass);
    }

    public static String convertToHex(byte[] data) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String MD5(String text) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] b = text.getBytes("UTF-8");
            md.update(b, 0, b.length);
            byte[] md5hash = md.digest();
            return Library.convertToHex(md5hash);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void update(String updateContext, String indexuri) {
        this.addBookmark(updateContext, indexuri);
    }

    static {
        REQUEST_CLIENT = new RequestClient(){

            public boolean persistent() {
                return false;
            }

            public boolean realTimeFlag() {
                return false;
            }
        };
        Logger.registerClass(Library.class);
    }

    private class BookmarkCallback
    implements USKRetrieverCallback,
    USKCallback {
        private final String bookmarkName;
        private String[] metaStrings;
        USKRetriever ret;
        private long origEdition;

        public BookmarkCallback(String name, String[] allMetaStrings, long origEdition) {
            this.bookmarkName = name;
            this.metaStrings = allMetaStrings;
        }

        public short getPollingPriorityNormal() {
            return 3;
        }

        public short getPollingPriorityProgress() {
            return 2;
        }

        public void onFound(USK origUSK, long edition, FetchResult data) {
            data.asBucket().free();
            if (logMINOR) {
                Logger.minor((Object)this, (String)("Bookmark " + this.bookmarkName + " : fetching edition " + edition));
            }
        }

        public void onFoundEdition(long l, USK key, ClientContext context, boolean metadata, short codec, byte[] data, boolean newKnownGood, boolean newSlotToo) {
            if (l < this.origEdition) {
                Logger.error((Object)this, (String)("Wrong edition: " + l + " less than " + this.origEdition));
                return;
            }
            if (newKnownGood) {
                String uri = key.copy(l).getURI().setMetaString(this.metaStrings).toString();
                if (logMINOR) {
                    Logger.minor((Object)this, (String)("Bookmark " + this.bookmarkName + " new last known good edition " + l + " uri is now " + uri));
                }
                Library.this.addBookmark(this.bookmarkName, uri);
            }
        }
    }
}

