/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library;

import freenet.client.InsertException;
import freenet.keys.FreenetURI;
import freenet.pluginmanager.PluginNotFoundException;
import freenet.pluginmanager.PluginReplySender;
import freenet.pluginmanager.PluginRespirator;
import freenet.support.Logger;
import freenet.support.MutableBoolean;
import freenet.support.SimpleFieldSet;
import freenet.support.TimeUtil;
import freenet.support.api.Bucket;
import freenet.support.io.BucketTools;
import freenet.support.io.Closer;
import freenet.support.io.FileBucket;
import freenet.support.io.FileUtil;
import freenet.support.io.LineReader;
import freenet.support.io.LineReadingInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.logging.Level;
import plugins.Library.Main;
import plugins.Library.SpiderIndexURIs;
import plugins.Library.client.FreenetArchiver;
import plugins.Library.index.ProtoIndex;
import plugins.Library.index.ProtoIndexComponentSerialiser;
import plugins.Library.index.ProtoIndexSerialiser;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermEntryReaderWriter;
import plugins.Library.io.serial.LiveArchiver;
import plugins.Library.io.serial.Serialiser;
import plugins.Library.util.SkeletonBTreeMap;
import plugins.Library.util.SkeletonBTreeSet;
import plugins.Library.util.TaskAbortExceptionConvertor;
import plugins.Library.util.exec.SimpleProgress;
import plugins.Library.util.exec.TaskAbortException;
import plugins.Library.util.func.Closure;

public class SpiderIndexUploader {
    static boolean logMINOR;
    private final PluginRespirator pr;
    private Object freenetMergeSync = new Object();
    private boolean freenetMergeRunning = false;
    private boolean diskMergeRunning = false;
    private final ArrayList<Bucket> toMergeToDisk = new ArrayList();
    static final int MAX_HANDLING_COUNT = 5;
    private int PUSH_BROKEN_MAX_HANDLING_COUNT = 10;
    private boolean pushBroken;
    ProtoIndex idxDisk;
    static final long MAX_TIME = 86400000L;
    static final int MAX_UPDATES = 16;
    static final int MAX_TERMS = 100000;
    static final int MAX_TERMS_NOT_UPLOADED = 10000;
    static final int MAX_DISK_ENTRY_SIZE = 10000;
    private int dirNumber;
    static final String DISK_DIR_PREFIX = "library-temp-index-";
    File idxDiskDir;
    private int mergedToDisk;
    ProtoIndexSerialiser srl = null;
    FreenetURI lastUploadURI = null;
    String lastDiskIndexName;
    ProtoIndex idxFreenet;
    private final SpiderIndexURIs spiderIndexURIs;
    long pushNumber;
    static final String LAST_URL_FILENAME = "library.index.lastpushed.chk";
    static final String PRIV_URI_FILENAME = "library.index.privkey";
    static final String PUB_URI_FILENAME = "library.index.pubkey";
    static final String EDITION_FILENAME = "library.index.next-edition";
    static final String LAST_DISK_FILENAME = "library.index.lastpushed.disk";
    static final String BASE_FILENAME_PUSH_DATA = "library.index.data.";
    private Map<String, SortedSet<TermEntry>> newtrees;
    private SortedSet<String> terms;
    ProtoIndexSerialiser srlDisk = null;
    private ProtoIndexComponentSerialiser leafsrlDisk;
    private long lastMergedToFreenet = -1L;
    static final String INDEX_DOCNAME = "index.yml";
    private ProtoIndexComponentSerialiser leafsrl;
    private final Object inflateSync = new Object();

    SpiderIndexUploader(PluginRespirator pr) {
        this.pr = pr;
        this.spiderIndexURIs = new SpiderIndexURIs(pr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void wrapMergeToDisk() {
        this.spiderIndexURIs.loadSSKURIs();
        boolean first = true;
        while (true) {
            Bucket data;
            Object object = this.freenetMergeSync;
            synchronized (object) {
                if (this.pushBroken) {
                    Logger.error((Object)this, (String)"Pushing broken");
                    return;
                }
                if (first && this.diskMergeRunning) {
                    Logger.error((Object)this, (String)"Already running a handler!");
                    return;
                }
                if (!first && !this.diskMergeRunning) {
                    Logger.error((Object)this, (String)"Already running yet runningHandler is false?!");
                    return;
                }
                first = false;
                if (this.toMergeToDisk.size() == 0) {
                    if (logMINOR) {
                        Logger.minor((Object)this, (String)"Nothing to handle");
                    }
                    this.diskMergeRunning = false;
                    this.freenetMergeSync.notifyAll();
                    return;
                }
                data = this.toMergeToDisk.remove(0);
                this.freenetMergeSync.notifyAll();
                this.diskMergeRunning = true;
            }
            try {
                this.mergeToDisk(data);
                continue;
            }
            catch (Throwable t) {
                Object object2 = this.freenetMergeSync;
                synchronized (object2) {
                    this.diskMergeRunning = false;
                    this.pushBroken = true;
                    this.freenetMergeSync.notifyAll();
                }
                if (t instanceof RuntimeException) {
                    throw (RuntimeException)t;
                }
                if (t instanceof Error) throw (Error)t;
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeToDisk(Bucket data) {
        boolean newIndex = false;
        if (this.idxDiskDir == null) {
            newIndex = true;
            if (!this.createDiskDir()) {
                return;
            }
        }
        if (!this.makeDiskDirSerialiser()) {
            return;
        }
        long entriesAdded = this.readTermsFrom(data);
        if (this.terms.size() == 0) {
            Logger.debug((Object)this, (String)"Nothing to merge");
            SpiderIndexUploader spiderIndexUploader = this;
            synchronized (spiderIndexUploader) {
                this.newtrees = null;
                this.terms = null;
            }
            return;
        }
        try {
            String uri;
            Object clo;
            MutableBoolean maxDiskEntrySizeExceeded = new MutableBoolean();
            maxDiskEntrySizeExceeded.value = false;
            long mergeStartTime = System.currentTimeMillis();
            if (newIndex) {
                if (this.createDiskIndex()) {
                    maxDiskEntrySizeExceeded.value = true;
                }
            } else {
                clo = this.createMergeFromNewtreesClosure(maxDiskEntrySizeExceeded);
                assert (this.idxDisk.ttab.isBare());
                Logger.debug((Object)this, (String)("Merging " + this.terms.size() + " terms, tree.size = " + this.idxDisk.ttab.size() + " from " + data + "..."));
                this.idxDisk.ttab.update(this.terms, (SortedSet<String>)null, clo, new TaskAbortExceptionConvertor());
            }
            clo = this;
            synchronized (clo) {
                this.newtrees = null;
                this.terms = null;
            }
            assert (this.idxDisk.ttab.isBare());
            Serialiser.PushTask<ProtoIndex> task4 = new Serialiser.PushTask<ProtoIndex>(this.idxDisk);
            this.srlDisk.push(task4);
            long mergeEndTime = System.currentTimeMillis();
            Logger.debug((Object)this, (String)(entriesAdded + " entries merged to disk in " + (mergeEndTime - mergeStartTime) + " ms, root at " + task4.meta + ", "));
            this.lastDiskIndexName = uri = (String)task4.meta;
            Logger.normal((Object)this, (String)("Pushed new index to file " + uri));
            if (this.writeStringTo(new File(LAST_DISK_FILENAME), uri) && this.writeStringTo(new File(this.idxDiskDir, LAST_DISK_FILENAME), uri)) {
                data.free();
            }
            this.maybeMergeToFreenet(maxDiskEntrySizeExceeded);
        }
        catch (TaskAbortException e) {
            Logger.error((Object)this, (String)"Failed to upload index for spider: ", (Throwable)e);
            e.printStackTrace();
            Object object = this.freenetMergeSync;
            synchronized (object) {
                this.pushBroken = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeMergeToFreenet(MutableBoolean maxDiskEntrySizeExceeded) {
        boolean termTooBig = false;
        MutableBoolean mutableBoolean = maxDiskEntrySizeExceeded;
        synchronized (mutableBoolean) {
            termTooBig = maxDiskEntrySizeExceeded.value;
        }
        ++this.mergedToDisk;
        if (this.lastMergedToFreenet > 0L && this.idxDisk.ttab.size() > 100000 || this.idxDisk.ttab.size() > 10000 || this.mergedToDisk > 16 || termTooBig || this.lastMergedToFreenet > 0L && System.currentTimeMillis() - this.lastMergedToFreenet > 86400000L) {
            final ProtoIndex diskToMerge = this.idxDisk;
            final File dir = this.idxDiskDir;
            Logger.debug((Object)this, (String)"Exceeded threshold, starting new disk index and starting merge from disk to Freenet...");
            this.mergedToDisk = 0;
            this.lastMergedToFreenet = -1L;
            this.idxDisk = null;
            this.srlDisk = null;
            this.leafsrlDisk = null;
            this.idxDiskDir = null;
            this.lastDiskIndexName = null;
            Object object = this.freenetMergeSync;
            synchronized (object) {
                while (this.freenetMergeRunning) {
                    if (this.pushBroken) {
                        return;
                    }
                    Logger.normal((Object)this, (String)"Need to merge to Freenet, but last merge not finished yet. Waiting...");
                    try {
                        this.freenetMergeSync.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.pushBroken) {
                    return;
                }
                this.freenetMergeRunning = true;
            }
            Runnable r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SpiderIndexUploader.this.mergeToFreenet(diskToMerge, dir);
                    }
                    catch (Throwable t) {
                        Logger.error((Object)this, (String)"Merge to Freenet failed: ", (Throwable)t);
                        t.printStackTrace();
                        Object object = SpiderIndexUploader.this.freenetMergeSync;
                        synchronized (object) {
                            SpiderIndexUploader.this.pushBroken = true;
                        }
                    }
                    finally {
                        Object object = SpiderIndexUploader.this.freenetMergeSync;
                        synchronized (object) {
                            SpiderIndexUploader.this.freenetMergeRunning = false;
                            if (!SpiderIndexUploader.this.pushBroken) {
                                SpiderIndexUploader.this.lastMergedToFreenet = System.currentTimeMillis();
                            }
                            SpiderIndexUploader.this.freenetMergeSync.notifyAll();
                        }
                    }
                }
            };
            this.pr.getNode().executor.execute(r, "Library: Merge data from disk to Freenet");
        } else {
            Logger.debug((Object)this, (String)("Not merging to Freenet yet: " + this.idxDisk.ttab.size() + " terms in index, " + this.mergedToDisk + " merges, " + (this.lastMergedToFreenet <= 0L ? "never merged to Freenet" : "last merged to Freenet " + TimeUtil.formatTime((long)(System.currentTimeMillis() - this.lastMergedToFreenet)) + "ago")));
        }
    }

    private boolean writeURITo(File filename, FreenetURI uri) {
        return this.writeStringTo(filename, uri.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean writeStringTo(File filename, String uri) {
        boolean bl;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(filename);
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(uri.toString());
            osw.close();
            fos = null;
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                Logger.error((Object)this, (String)("Failed to write to " + filename + " : " + uri), (Throwable)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                Closer.close(fos);
                throw throwable;
            }
            Closer.close((Closeable)fos);
            return bl2;
        }
        Closer.close((Closeable)fos);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readStringFrom(File file) {
        String string;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
            String ret = br.readLine();
            fis.close();
            fis = null;
            string = ret;
        }
        catch (IOException e) {
            String string2;
            try {
                string2 = null;
            }
            catch (Throwable throwable) {
                Closer.close(fis);
                throw throwable;
            }
            Closer.close((Closeable)fis);
            return string2;
        }
        Closer.close((Closeable)fis);
        return string;
    }

    private FreenetURI readURIFrom(File file) {
        String s = this.readStringFrom(file);
        if (s != null) {
            try {
                return new FreenetURI(s);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private Closure<Map.Entry<String, SkeletonBTreeSet<TermEntry>>, TaskAbortException> createMergeFromNewtreesClosure(final MutableBoolean maxDiskEntrySizeExceeded) {
        return new Closure<Map.Entry<String, SkeletonBTreeSet<TermEntry>>, TaskAbortException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Map.Entry<String, SkeletonBTreeSet<TermEntry>> entry) throws TaskAbortException {
                String key = entry.getKey();
                SkeletonBTreeSet<TermEntry> tree = entry.getValue();
                if (logMINOR) {
                    Logger.minor((Object)this, (String)("Processing: " + key + " : " + tree));
                }
                if (tree != null) {
                    Logger.debug((Object)this, (String)("Merging data (on disk) in term " + key));
                } else {
                    Logger.debug((Object)this, (String)("Adding new term to disk index:  " + key));
                }
                if (tree == null) {
                    tree = SpiderIndexUploader.makeEntryTree(SpiderIndexUploader.this.leafsrlDisk);
                    entry.setValue(tree);
                }
                assert (tree.isBare());
                SortedSet toMerge = (SortedSet)SpiderIndexUploader.this.newtrees.get(key);
                tree.update(toMerge, null);
                if (toMerge.size() > 10000) {
                    MutableBoolean mutableBoolean = maxDiskEntrySizeExceeded;
                    synchronized (mutableBoolean) {
                        maxDiskEntrySizeExceeded.value = true;
                    }
                }
                toMerge = null;
                SpiderIndexUploader.this.newtrees.remove(key);
                assert (tree.isBare());
                if (logMINOR) {
                    Logger.minor((Object)this, (String)("Updated: " + key + " : " + tree));
                }
            }
        };
    }

    private boolean createDiskIndex() throws TaskAbortException {
        boolean tooBig = false;
        for (String key : this.terms) {
            SkeletonBTreeSet<TermEntry> tree = SpiderIndexUploader.makeEntryTree(this.leafsrlDisk);
            SortedSet<TermEntry> toMerge = this.newtrees.get(key);
            tree.addAll(toMerge);
            if (toMerge.size() > 10000) {
                tooBig = true;
            }
            toMerge = null;
            tree.deflate();
            assert (tree.isBare());
            this.idxDisk.ttab.put(key, tree);
        }
        this.idxDisk.ttab.deflate();
        return tooBig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readTermsFrom(Bucket data) {
        Object w = null;
        this.newtrees = new HashMap<String, SortedSet<TermEntry>>();
        this.terms = new TreeSet<String>();
        int entriesAdded = 0;
        InputStream is = null;
        try {
            Logger.normal((Object)this, (String)("Bucket of buffer received, " + data.size() + " bytes"));
            is = data.getInputStream();
            SimpleFieldSet fs = new SimpleFieldSet((LineReader)new LineReadingInputStream(is), 1024, 512, true, true, true);
            this.idxDisk.setName(fs.get("index.title"));
            this.idxDisk.setOwnerEmail(fs.get("index.owner.email"));
            this.idxDisk.setOwner(fs.get("index.owner.name"));
            this.idxDisk.setTotalPages(fs.getLong("totalPages", -1L));
            try {
                while (true) {
                    TermEntry readObject = TermEntryReaderWriter.getInstance().readObject(is);
                    SortedSet<TermEntry> set = this.newtrees.get(readObject.subj);
                    if (set == null) {
                        set = new TreeSet<TermEntry>();
                        this.newtrees.put(readObject.subj, set);
                    }
                    set.add(readObject);
                    this.terms.add(readObject.subj);
                    ++entriesAdded;
                }
            }
            catch (EOFException eOFException) {
                Closer.close((Closeable)is);
            }
        }
        catch (IOException ex) {
            java.util.logging.Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            Closer.close(is);
        }
        return entriesAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean createDiskDir() {
        ++this.dirNumber;
        this.idxDiskDir = new File(DISK_DIR_PREFIX + Integer.toString(this.dirNumber));
        Logger.normal((Object)this, (String)("Created new disk dir for merging: " + this.idxDiskDir));
        if (!this.idxDiskDir.mkdir() && !this.idxDiskDir.isDirectory()) {
            Logger.error((Object)this, (String)("Unable to create new disk dir: " + this.idxDiskDir));
            SpiderIndexUploader spiderIndexUploader = this;
            synchronized (spiderIndexUploader) {
                this.pushBroken = true;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean makeDiskDirSerialiser() {
        if (this.srlDisk == null) {
            this.srlDisk = ProtoIndexSerialiser.forIndex(this.idxDiskDir);
            Serialiser archiver = this.srlDisk.getChildSerialiser();
            this.leafsrlDisk = ProtoIndexComponentSerialiser.get(-734403942, (LiveArchiver<Map<String, Object>, SimpleProgress>)archiver);
            if (this.lastDiskIndexName == null) {
                try {
                    this.idxDisk = new ProtoIndex(new FreenetURI("CHK@"), "test", null, null, 0L);
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                this.leafsrlDisk.setSerialiserFor(this.idxDisk);
            } else {
                try {
                    Serialiser.PullTask<ProtoIndex> pull = new Serialiser.PullTask<ProtoIndex>(this.lastDiskIndexName);
                    Logger.debug((Object)this, (String)("Pulling previous index " + this.lastDiskIndexName + " from disk so can update it."));
                    this.srlDisk.pull(pull);
                    Logger.debug((Object)this, (String)("Pulled previous index " + this.lastDiskIndexName + " from disk - updating..."));
                    this.idxDisk = (ProtoIndex)pull.data;
                    if (this.idxDisk.getSerialiser().getLeafSerialiser() != archiver) {
                        throw new IllegalStateException("Different serialiser: " + this.idxFreenet.getSerialiser() + " should be " + this.leafsrl);
                    }
                }
                catch (TaskAbortException e) {
                    Logger.error((Object)this, (String)("Failed to download previous index for spider update: " + e), (Throwable)e);
                    e.printStackTrace();
                    Object object = this.freenetMergeSync;
                    synchronized (object) {
                        this.pushBroken = true;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeToFreenet(File diskDir) {
        ProtoIndexSerialiser s = ProtoIndexSerialiser.forIndex(diskDir);
        Serialiser archiver = s.getChildSerialiser();
        ProtoIndexComponentSerialiser leaf = ProtoIndexComponentSerialiser.get(-734403942, (LiveArchiver<Map<String, Object>, SimpleProgress>)archiver);
        String f = this.readStringFrom(new File(diskDir, LAST_DISK_FILENAME));
        if (f == null) {
            if (diskDir.list().length == 0) {
                Logger.debug((Object)this, (String)("Directory " + diskDir + " is empty. Nothing to merge."));
                diskDir.delete();
                return;
            }
            Logger.error((Object)this, (String)("Unable to merge old data " + diskDir));
            return;
        }
        Logger.debug((Object)this, (String)("Continuing old bucket: " + f));
        ProtoIndex idxDisk = null;
        try {
            Serialiser.PullTask<ProtoIndex> pull = new Serialiser.PullTask<ProtoIndex>(f);
            Logger.debug((Object)this, (String)("Pulling previous index " + f + " from disk so can update it."));
            s.pull(pull);
            Logger.debug((Object)this, (String)("Pulled previous index " + f + " from disk - updating..."));
            idxDisk = (ProtoIndex)pull.data;
            if (idxDisk.getSerialiser().getLeafSerialiser() != archiver) {
                throw new IllegalStateException("Different serialiser: " + idxDisk.getSerialiser() + " should be " + archiver);
            }
        }
        catch (TaskAbortException e) {
            Logger.error((Object)this, (String)("Failed to download previous index for spider update: " + e), (Throwable)e);
            e.printStackTrace();
            Object object = this.freenetMergeSync;
            synchronized (object) {
                this.pushBroken = true;
            }
            return;
        }
        this.mergeToFreenet(idxDisk, diskDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void mergeToFreenet(ProtoIndex diskToMerge, File diskDir) {
        Logger.debug((Object)this, (String)("Merging on-disk index to Freenet: " + diskDir));
        if (this.lastUploadURI == null) {
            this.lastUploadURI = this.readURIFrom(new File(LAST_URL_FILENAME));
        }
        this.setupFreenetCacheDir();
        this.makeFreenetSerialisers();
        this.updateOverallMetadata(diskToMerge);
        SkeletonBTreeMap<String, SkeletonBTreeSet<TermEntry>> newtrees = diskToMerge.ttab;
        Closure<Map.Entry<String, SkeletonBTreeSet<TermEntry>>, TaskAbortException> clo = this.createMergeFromTreeClosure(newtrees);
        try {
            FreenetURI uri;
            long mergeStartTime = System.currentTimeMillis();
            assert (this.idxFreenet.ttab.isBare());
            Iterator<String> it = diskToMerge.ttab.keySetAutoDeflate().iterator();
            TreeSet<String> terms = new TreeSet<String>();
            while (it.hasNext()) {
                terms.add(it.next());
            }
            Logger.debug((Object)this, (String)("Merging " + terms.size() + " terms from disk to Freenet..."));
            assert (terms.size() == diskToMerge.ttab.size());
            assert (this.idxFreenet.ttab.isBare());
            assert (diskToMerge.ttab.isBare());
            long entriesAdded = terms.size();
            this.idxFreenet.ttab.update(terms, null, clo, new TaskAbortExceptionConvertor());
            assert (this.idxFreenet.ttab.isBare());
            newtrees.deflate();
            assert (diskToMerge.ttab.isBare());
            Serialiser.PushTask<ProtoIndex> task4 = new Serialiser.PushTask<ProtoIndex>(this.idxFreenet);
            task4.meta = FreenetURI.EMPTY_CHK_URI;
            this.srl.push(task4);
            FreenetArchiver arch = (FreenetArchiver)this.srl.getChildSerialiser();
            arch.waitForAsyncInserts();
            long mergeEndTime = System.currentTimeMillis();
            Logger.debug((Object)this, (String)(entriesAdded + " entries merged in " + (mergeEndTime - mergeStartTime) + " ms, root at " + task4.meta + ", "));
            this.lastUploadURI = uri = (FreenetURI)task4.meta;
            Logger.debug((Object)this, (String)("Uploaded new index to " + uri));
            if (this.writeURITo(new File(LAST_URL_FILENAME), uri)) {
                newtrees.deflate();
                diskToMerge = null;
                terms = null;
                Logger.debug((Object)this, (String)("Finished with disk index " + diskDir));
                FileUtil.removeAll((File)diskDir);
            }
            this.uploadUSKForFreenetIndex(uri);
        }
        catch (TaskAbortException e) {
            Logger.error((Object)this, (String)("Failed to upload index for spider: " + e), (Throwable)e);
            e.printStackTrace();
            Object object = this.freenetMergeSync;
            synchronized (object) {
                this.pushBroken = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadUSKForFreenetIndex(FreenetURI uri) {
        FreenetURI privUSK = this.spiderIndexURIs.getPrivateUSK();
        try {
            long ed;
            FreenetURI tmp = this.pr.getHLSimpleClient().insertRedirect(privUSK, uri);
            Object object = this.freenetMergeSync;
            synchronized (object) {
                ed = this.spiderIndexURIs.setEdition(tmp.getEdition() + 1L);
            }
            Logger.debug((Object)this, (String)("Uploaded index as USK to " + tmp));
            this.writeStringTo(new File(EDITION_FILENAME), Long.toString(ed));
        }
        catch (InsertException e) {
            e.printStackTrace();
            Logger.error((Object)this, (String)"Failed to upload USK for index update", (Throwable)e);
        }
    }

    private Closure<Map.Entry<String, SkeletonBTreeSet<TermEntry>>, TaskAbortException> createMergeFromTreeClosure(final SkeletonBTreeMap<String, SkeletonBTreeSet<TermEntry>> newtrees) {
        return new Closure<Map.Entry<String, SkeletonBTreeSet<TermEntry>>, TaskAbortException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void invoke(Map.Entry<String, SkeletonBTreeSet<TermEntry>> entry) throws TaskAbortException {
                TreeSet data;
                String key = entry.getKey();
                SkeletonBTreeSet<TermEntry> tree = entry.getValue();
                if (logMINOR) {
                    Logger.minor((Object)this, (String)("Processing: " + key + " : " + tree));
                }
                boolean newTree = false;
                if (tree == null) {
                    tree = SpiderIndexUploader.makeEntryTree(SpiderIndexUploader.this.leafsrl);
                    entry.setValue(tree);
                    newTree = true;
                }
                assert (tree.isBare());
                Object object = SpiderIndexUploader.this.inflateSync;
                synchronized (object) {
                    newtrees.inflate(key, true);
                    SkeletonBTreeSet entries = (SkeletonBTreeSet)newtrees.get(key);
                    entries.inflate();
                    data = new TreeSet(entries);
                    entries.deflate();
                    assert (entries.isBare());
                }
                if (tree != null) {
                    if (newTree) {
                        tree.addAll(data);
                        assert (tree.size() == data.size());
                        Logger.debug((Object)this, (String)("Added data to Freenet for term " + key + " : " + data.size()));
                    } else {
                        int oldSize = tree.size();
                        tree.update(data, null);
                        Logger.debug((Object)this, (String)("Merged data to Freenet in term " + key + " : " + data.size() + " + " + oldSize + " -> " + tree.size()));
                    }
                }
                tree.deflate();
                assert (tree.isBare());
                if (logMINOR) {
                    Logger.minor((Object)this, (String)("Updated: " + key + " : " + tree));
                }
            }
        };
    }

    private void updateOverallMetadata(ProtoIndex diskToMerge) {
        this.idxFreenet.setName(diskToMerge.getName());
        this.idxFreenet.setOwnerEmail(diskToMerge.getOwnerEmail());
        this.idxFreenet.setOwner(diskToMerge.getOwner());
        this.idxFreenet.setTotalPages(diskToMerge.getTotalPages() + Math.max(0L, this.idxFreenet.getTotalPages()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeFreenetSerialisers() {
        if (this.srl == null) {
            this.srl = ProtoIndexSerialiser.forIndex(this.lastUploadURI, (short)4);
            Serialiser archiver = this.srl.getChildSerialiser();
            this.leafsrl = ProtoIndexComponentSerialiser.get(766757184, (LiveArchiver<Map<String, Object>, SimpleProgress>)archiver);
            if (this.lastUploadURI == null) {
                try {
                    this.idxFreenet = new ProtoIndex(new FreenetURI("CHK@"), "test", null, null, 0L);
                }
                catch (MalformedURLException e) {
                    throw new AssertionError((Object)e);
                }
                this.leafsrl.setSerialiserFor(this.idxFreenet);
            } else {
                try {
                    Serialiser.PullTask<ProtoIndex> pull = new Serialiser.PullTask<ProtoIndex>(this.lastUploadURI);
                    Logger.debug((Object)this, (String)("Pulling previous index " + this.lastUploadURI + " so can update it."));
                    this.srl.pull(pull);
                    Logger.debug((Object)this, (String)("Pulled previous index " + this.lastUploadURI + " - updating..."));
                    this.idxFreenet = (ProtoIndex)pull.data;
                    if (this.idxFreenet.getSerialiser().getLeafSerialiser() != archiver) {
                        throw new IllegalStateException("Different serialiser: " + this.idxFreenet.getSerialiser() + " should be " + this.leafsrl);
                    }
                }
                catch (TaskAbortException e) {
                    Logger.error((Object)this, (String)("Failed to download previous index for spider update: " + e), (Throwable)e);
                    e.printStackTrace();
                    Object object = this.freenetMergeSync;
                    synchronized (object) {
                        this.pushBroken = true;
                    }
                    return;
                }
            }
        }
    }

    private void setupFreenetCacheDir() {
        if (FreenetArchiver.getCacheDir() == null) {
            File dir = new File("library-spider-pushed-data-cache");
            dir.mkdir();
            FreenetArchiver.setCacheDir(dir);
        }
    }

    protected static SkeletonBTreeSet<TermEntry> makeEntryTree(ProtoIndexComponentSerialiser leafsrl) {
        SkeletonBTreeSet<TermEntry> tree = new SkeletonBTreeSet<TermEntry>(ProtoIndex.BTREE_NODE_MIN);
        leafsrl.setSerialiserFor(tree);
        return tree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        Runnable r;
        String[] dirsToMerge;
        String[] oldToMerge;
        Object object = this.freenetMergeSync;
        synchronized (object) {
            oldToMerge = new File(".").list(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    if (!arg1.toLowerCase().startsWith(SpiderIndexUploader.BASE_FILENAME_PUSH_DATA)) {
                        return false;
                    }
                    File f = new File(arg0, arg1);
                    if (!f.isFile()) {
                        return false;
                    }
                    if (f.length() == 0L) {
                        f.delete();
                        return false;
                    }
                    String s = f.getName().substring(SpiderIndexUploader.BASE_FILENAME_PUSH_DATA.length());
                    SpiderIndexUploader.this.pushNumber = Math.max(SpiderIndexUploader.this.pushNumber, Long.parseLong(s) + 1L);
                    return true;
                }
            });
        }
        Object object2 = this.freenetMergeSync;
        synchronized (object2) {
            dirsToMerge = new File(".").list(new FilenameFilter(){

                @Override
                public boolean accept(File arg0, String arg1) {
                    if (!arg1.toLowerCase().startsWith(SpiderIndexUploader.DISK_DIR_PREFIX)) {
                        return false;
                    }
                    File f = new File(arg0, arg1);
                    String s = f.getName().substring(SpiderIndexUploader.DISK_DIR_PREFIX.length());
                    SpiderIndexUploader.this.dirNumber = Math.max(SpiderIndexUploader.this.dirNumber, Integer.parseInt(s) + 1);
                    return true;
                }
            });
        }
        if (oldToMerge != null && oldToMerge.length > 0) {
            Logger.debug((Object)this, (String)("Found " + oldToMerge.length + " buckets of old index data to merge..."));
            r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = SpiderIndexUploader.this.freenetMergeSync;
                    synchronized (object) {
                        for (String filename : oldToMerge) {
                            File f = new File(filename);
                            SpiderIndexUploader.this.toMergeToDisk.add(new FileBucket(f, true, false, false, true));
                        }
                    }
                    SpiderIndexUploader.this.wrapMergeToDisk();
                }
            };
            this.pr.getNode().executor.execute(r, "Library: handle index data from previous run");
        }
        if (dirsToMerge != null && dirsToMerge.length > 0) {
            Logger.debug((Object)this, (String)("Found " + dirsToMerge.length + " disk trees of old index data to merge..."));
            r = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = SpiderIndexUploader.this.freenetMergeSync;
                    synchronized (object) {
                        while (SpiderIndexUploader.this.freenetMergeRunning) {
                            if (SpiderIndexUploader.this.pushBroken) {
                                return;
                            }
                            Logger.normal((Object)this, (String)"Need to merge to Freenet, but last merge not finished yet. Waiting...");
                            try {
                                SpiderIndexUploader.this.freenetMergeSync.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        if (SpiderIndexUploader.this.pushBroken) {
                            return;
                        }
                        SpiderIndexUploader.this.freenetMergeRunning = true;
                    }
                    try {
                        for (String filename : dirsToMerge) {
                            File f = new File(filename);
                            SpiderIndexUploader.this.mergeToFreenet(f);
                        }
                    }
                    finally {
                        object = SpiderIndexUploader.this.freenetMergeSync;
                        synchronized (object) {
                            SpiderIndexUploader.this.freenetMergeRunning = false;
                            if (!SpiderIndexUploader.this.pushBroken) {
                                SpiderIndexUploader.this.lastMergedToFreenet = System.currentTimeMillis();
                            }
                            SpiderIndexUploader.this.freenetMergeSync.notifyAll();
                        }
                    }
                }
            };
            this.pr.getNode().executor.execute(r, "Library: handle trees from previous run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handlePushBuffer(SimpleFieldSet params, Bucket data) {
        long pn;
        if (data.size() == 0L) {
            Logger.error((Object)this, (String)("Bucket of data (" + data + ") to push is empty"), (Throwable)new Exception("error"));
            data.free();
            return;
        }
        SpiderIndexUploader spiderIndexUploader = this;
        synchronized (spiderIndexUploader) {
            pn = this.pushNumber++;
        }
        File pushFile = new File(BASE_FILENAME_PUSH_DATA + pn);
        FileBucket output = new FileBucket(pushFile, false, false, false, true);
        try {
            BucketTools.copy((Bucket)data, (Bucket)output);
            data.free();
            Logger.debug((Object)this, (String)("Written data to " + pushFile));
        }
        catch (IOException e1) {
            e1.printStackTrace();
            Logger.error((Object)this, (String)("Unable to back up push data #" + pn), (Throwable)e1);
            output = data;
        }
        Object e1 = this.freenetMergeSync;
        synchronized (e1) {
            boolean waited = false;
            while (this.toMergeToDisk.size() > 5 && !this.pushBroken) {
                Logger.error((Object)this, (String)("Spider feeding us data too fast, waiting for background process to finish. Ahead of us in the queue: " + this.toMergeToDisk.size()));
                try {
                    waited = true;
                    this.freenetMergeSync.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.toMergeToDisk.add((Bucket)output);
            if (this.pushBroken) {
                if (this.toMergeToDisk.size() >= this.PUSH_BROKEN_MAX_HANDLING_COUNT) {
                    while (true) {
                        try {
                            while (true) {
                                this.freenetMergeSync.wait();
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                Logger.error((Object)this, (String)"Pushing is broken, failing");
                return;
            }
            if (waited) {
                Logger.error((Object)this, (String)"Waited for previous handler to go away, moving on...");
            }
            if (this.diskMergeRunning) {
                return;
            }
        }
        Runnable r = new Runnable(){

            @Override
            public void run() {
                SpiderIndexUploader.this.wrapMergeToDisk();
            }
        };
        this.pr.getNode().executor.execute(r, "Library: Handle data from Spider");
    }

    public FreenetURI getPublicUSKURI() {
        return this.spiderIndexURIs.getPublicUSK();
    }

    public void handleGetSpiderURI(PluginReplySender replysender) {
        FreenetURI uri = this.getPublicUSKURI();
        SimpleFieldSet sfs = new SimpleFieldSet(true);
        sfs.putSingle("reply", "getSpiderURI");
        sfs.putSingle("publicUSK", uri.toString(true, false));
        try {
            replysender.send(sfs);
        }
        catch (PluginNotFoundException pluginNotFoundException) {
            // empty catch block
        }
    }

    static {
        Logger.registerClass(SpiderIndexUploader.class);
    }
}

