/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.index.xml;

import freenet.keys.FreenetURI;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import plugins.Library.index.TermPageEntry;
import plugins.Library.index.xml.FindRequest;

public class LibrarianHandler
extends DefaultHandler {
    private boolean processingWord;
    private HashMap<String, String> uris;
    private HashMap<String, String> titles;
    private HashMap<String, Integer> wordCounts;
    private int totalFileCount;
    private List<FindRequest> requests;
    private List<FindRequest> wordMatches;
    private int inWordFileCount;
    private StringBuilder characters;
    private String inFileTitle;
    private FreenetURI inFileURI;
    private int inFileWordCount;
    static volatile boolean logMINOR;
    static volatile boolean logDEBUG;

    public LibrarianHandler(List<FindRequest> requests) {
        this.requests = new ArrayList<FindRequest>(requests);
        for (FindRequest r : requests) {
            r.setResult((Set<TermPageEntry>)new HashSet<TermPageEntry>());
        }
    }

    @Override
    public void setDocumentLocator(Locator value) {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        if (this.uris == null || this.titles == null) {
            this.uris = new HashMap();
            this.titles = new HashMap();
            this.wordCounts = new HashMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startElement(String nameSpaceURI, String localName, String rawName, Attributes attrs) throws SAXException {
        Object it;
        String elt_name;
        if (this.requests.size() == 0 && this.wordMatches.size() == 0) {
            return;
        }
        if (rawName == null) {
            rawName = localName;
        }
        if ((elt_name = rawName).equals("files")) {
            this.processingWord = false;
            String fileCount = attrs.getValue("", "totalFileCount");
            if (fileCount != null) {
                this.totalFileCount = Integer.parseInt(fileCount);
            }
            if (logMINOR) {
                Logger.minor((Object)this, (String)("totalfilecount = " + this.totalFileCount));
            }
        }
        if (elt_name.equals("keywords")) {
            this.processingWord = true;
        }
        if (elt_name.equals("word")) {
            try {
                this.wordMatches = null;
                String match = attrs.getValue("v");
                if (this.requests != null) {
                    this.wordMatches = new ArrayList<FindRequest>();
                    it = this.requests.iterator();
                    while (it.hasNext()) {
                        FindRequest r = it.next();
                        if (!match.equals(r.getSubject())) continue;
                        this.wordMatches.add(r);
                        it.remove();
                        if (!logMINOR) continue;
                        Logger.minor((Object)this, (String)("found word match " + this.wordMatches));
                    }
                    if (attrs.getValue("fileCount") != null) {
                        this.inWordFileCount = Integer.parseInt(attrs.getValue("fileCount"));
                    }
                }
            }
            catch (Exception e) {
                throw new SAXException(e);
            }
        }
        if (elt_name.equals("file")) {
            if (this.processingWord && this.wordMatches != null) {
                try {
                    String suri = this.uris.get(attrs.getValue("id"));
                    this.inFileURI = new FreenetURI(suri);
                    it = this;
                    synchronized (it) {
                        if (this.titles.containsKey(attrs.getValue("id"))) {
                            this.inFileTitle = this.titles.get(attrs.getValue("id"));
                            if (suri.equals(this.inFileTitle)) {
                                this.inFileTitle = null;
                            }
                        } else {
                            this.inFileTitle = null;
                        }
                        this.inFileWordCount = this.wordCounts.containsKey(attrs.getValue("id")) ? this.wordCounts.get(attrs.getValue("id")) : -1;
                        this.characters = new StringBuilder();
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)this, (String)("Index format may be outdated " + e.toString()), (Throwable)e);
                }
            } else if (!this.processingWord) {
                try {
                    String id = attrs.getValue("id");
                    String key = attrs.getValue("key");
                    int l = attrs.getLength();
                    LibrarianHandler librarianHandler = this;
                    synchronized (librarianHandler) {
                        if (l >= 3) {
                            try {
                                String title = attrs.getValue("title");
                                this.titles.put(id, title);
                            }
                            catch (Exception e) {
                                Logger.error((Object)this, (String)("Index Format not compatible " + e.toString()), (Throwable)e);
                            }
                            try {
                                String wordCountString = attrs.getValue("wordCount");
                                if (wordCountString != null) {
                                    int wordCount = Integer.parseInt(attrs.getValue("wordCount"));
                                    this.wordCounts.put(id, wordCount);
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        this.uris.put(id, key);
                    }
                }
                catch (Exception e) {
                    Logger.error((Object)this, (String)"File id and key could not be retrieved. May be due to format clash", (Throwable)e);
                }
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.processingWord && this.wordMatches != null && this.characters != null) {
            this.characters.append(ch, start, length);
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.processingWord && this.wordMatches != null) {
            HashMap<Integer, String> termpositions = null;
            if (this.characters != null) {
                String[] termposs = this.characters.toString().split(",");
                termpositions = new HashMap<Integer, String>();
                for (String pos : termposs) {
                    try {
                        termpositions.put(Integer.valueOf(pos), null);
                    }
                    catch (NumberFormatException e) {
                        Logger.error((Object)this, (String)("Position in index not an integer :" + pos), (Throwable)e);
                    }
                }
                this.characters = null;
            }
            for (FindRequest match : this.wordMatches) {
                Set<TermPageEntry> result = match.getUnfinishedResult();
                float relevance = 0.0f;
                if (termpositions != null && termpositions.size() > 0 && this.inFileWordCount > 0) {
                    relevance = (float)termpositions.size() / (float)this.inFileWordCount;
                    if (this.totalFileCount > 0 && this.inWordFileCount > 0) {
                        relevance = (float)((double)relevance * Math.log((float)this.totalFileCount / (float)this.inWordFileCount));
                    }
                }
                TermPageEntry pageEntry = new TermPageEntry(match.getSubject(), relevance, this.inFileURI, this.inFileTitle, termpositions);
                result.add(pageEntry);
            }
        }
    }

    static {
        Logger.registerClass(LibrarianHandler.class);
    }
}

