/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.ui;

import freenet.keys.FreenetURI;
import freenet.support.HTMLNode;
import freenet.support.Logger;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import plugins.Library.index.TermEntry;
import plugins.Library.index.TermIndexEntry;
import plugins.Library.index.TermPageEntry;
import plugins.Library.index.TermTermEntry;
import plugins.Library.ui.RelevanceComparator;
import plugins.Library.ui.TermPageGroupEntry;

public class ResultNodeGenerator
implements Runnable {
    private TreeMap<String, TermPageGroupEntry> groupmap;
    private TreeMap<TermPageEntry, Boolean> pageset;
    private TreeSet<TermTermEntry> relatedTerms;
    private TreeSet<TermIndexEntry> relatedIndexes;
    private Set<TermEntry> result;
    private boolean groupusk;
    private boolean showold;
    private boolean js;
    private boolean done;
    private HTMLNode pageEntryNode;
    private RuntimeException exception;

    public ResultNodeGenerator(Set<TermEntry> result, boolean groupusk, boolean showold, boolean js) {
        this.result = result;
        this.groupusk = groupusk;
        this.showold = showold;
        this.js = js;
    }

    @Override
    public synchronized void run() {
        if (this.done) {
            throw new IllegalStateException("ResultNodeGenerator can only be run once.");
        }
        try {
            this.parseResult();
            this.generatePageEntryNode();
        }
        catch (RuntimeException e) {
            this.exception = e;
            throw e;
        }
        this.done = true;
        this.result = null;
    }

    public HTMLNode getPageEntryNode() {
        if (this.exception != null) {
            throw new RuntimeException("RuntimeException thrown in ResultNodeGenerator thread", this.exception);
        }
        return this.pageEntryNode;
    }

    public boolean isDone() {
        if (this.exception != null) {
            throw new RuntimeException("RuntimeException thrown in ResultNodeGenerator thread", this.exception);
        }
        return this.done;
    }

    private void parseResult() {
        this.groupmap = new TreeMap();
        if (!this.groupusk) {
            this.pageset = new TreeMap(RelevanceComparator.comparator);
        }
        this.relatedTerms = new TreeSet<TermEntry>(RelevanceComparator.comparator);
        this.relatedIndexes = new TreeSet<TermEntry>(RelevanceComparator.comparator);
        for (TermEntry o : this.result) {
            if (o instanceof TermPageEntry) {
                TermPageEntry pageEntry = (TermPageEntry)o;
                long uskEdition = Long.MIN_VALUE;
                FreenetURI uri = pageEntry.page;
                if (uri.isSSKForUSK()) {
                    uri = uri.uskForSSK();
                    uskEdition = uri.getEdition();
                }
                String sitebase = uri.setMetaString(null).setSuggestedEdition(0L).toString().replaceFirst("/0", "");
                Logger.minor((Object)this, (String)sitebase);
                if (!this.groupmap.containsKey(sitebase)) {
                    this.groupmap.put(sitebase, new TermPageGroupEntry(sitebase));
                }
                TermPageGroupEntry siteGroup = this.groupmap.get(sitebase);
                siteGroup.addPage(uskEdition, pageEntry);
                continue;
            }
            if (o instanceof TermTermEntry) {
                this.relatedTerms.add((TermTermEntry)o);
                continue;
            }
            if (o instanceof TermIndexEntry) {
                this.relatedIndexes.add((TermIndexEntry)o);
                continue;
            }
            Logger.error((Object)this, (String)("Unknown TermEntry type : " + o.getClass().getName()));
        }
        if (!this.groupusk) {
            for (TermPageGroupEntry groupentry : this.groupmap.values()) {
                SortedMap<Long, SortedSet<TermPageEntry>> editions = groupentry.getEditions();
                SortedSet newest = (SortedSet)editions.get(editions.lastKey());
                for (SortedSet<TermPageEntry> edition : groupentry.getEditions().values()) {
                    if (!this.showold && edition != newest) continue;
                    for (TermPageEntry termPageEntry : edition) {
                        this.pageset.put(termPageEntry, edition == newest);
                    }
                }
            }
            this.groupmap = null;
        }
    }

    private HTMLNode generateIndexEntryNode() {
        return new HTMLNode("#", "TermIndexEntry code not done yet");
    }

    private HTMLNode generateTermEntryNode() {
        return new HTMLNode("#", "TermTermEntry code not done yet");
    }

    private void generatePageEntryNode() {
        this.pageEntryNode = new HTMLNode("div", "id", "results");
        int results = 0;
        if (this.groupmap != null) {
            TreeSet<TermEntry> groupSet = new TreeSet<TermEntry>(RelevanceComparator.comparator);
            groupSet.addAll(this.groupmap.values());
            for (TermPageGroupEntry termPageGroupEntry : groupSet) {
                String keybase = termPageGroupEntry.subj;
                SortedMap<Long, SortedSet<TermPageEntry>> siteMap = termPageGroupEntry.getEditions();
                HTMLNode siteNode = this.pageEntryNode.addChild("div", "style", "padding-bottom: 6px;");
                HTMLNode siteBlockOldOuter = siteNode.addChild("div", new String[]{"id", "style"}, new String[]{"result-hiddenblock-" + keybase, !this.showold ? "display:none" : ""});
                if (siteMap.size() > 1) {
                    siteBlockOldOuter.addChild("a", new String[]{"onClick", "name"}, new String[]{"toggleResult('" + keybase + "')", keybase}).addChild("h3", "class", "result-grouptitle", keybase.replaceAll("\\b.*/(.*)", "$1"));
                }
                HTMLNode oldEditionContainer = siteBlockOldOuter.addChild("div", new String[]{"class", "style"}, new String[]{"result-hideblock", "border-left: thick black;"});
                Iterator<Long> it3 = siteMap.keySet().iterator();
                while (it3.hasNext()) {
                    HTMLNode versionCell;
                    boolean newestVersion;
                    long version = it3.next();
                    boolean bl = newestVersion = !it3.hasNext();
                    if (newestVersion) {
                        oldEditionContainer = siteNode;
                    }
                    if (((SortedSet)siteMap.get(version)).size() > 1 || siteMap.size() > 1) {
                        HTMLNode versionNode = oldEditionContainer.addChild("table", new String[]{"class"}, new String[]{"librarian-result"});
                        HTMLNode grouptitle = versionNode.addChild("tr").addChild("td", new String[]{"padding", "colspan"}, new String[]{"0", "3"});
                        grouptitle.addChild("h4", "class", newestVersion ? "result-editiontitle-new" : "result-editiontitle-old", keybase.replaceAll("\\b.*/(.*)", "$1") + (version >= 0L ? "-" + version : ""));
                        if (newestVersion && !this.showold && this.js && siteMap.size() > 1) {
                            grouptitle.addChild("a", new String[]{"href", "onClick"}, new String[]{"#" + keybase, "toggleResult('" + keybase + "')"}, "       [" + (siteMap.size() - 1) + " older matching versions]");
                        }
                        HTMLNode versionrow = versionNode.addChild("tr");
                        versionrow.addChild("td", "width", "8px");
                        versionrow.addChild("td", new String[]{"class"}, new String[]{"sskeditionbracket"});
                        versionCell = versionrow.addChild("td", "style", "padding-left:15px");
                    } else {
                        versionCell = oldEditionContainer;
                    }
                    Iterator it4 = ((SortedSet)siteMap.get(version)).iterator();
                    while (it4.hasNext()) {
                        versionCell.addChild(this.termPageEntryNode((TermPageEntry)it4.next(), newestVersion));
                        ++results;
                    }
                }
            }
        } else {
            for (Map.Entry<TermPageEntry, Boolean> entry : this.pageset.entrySet()) {
                TermPageEntry termPageEntry = entry.getKey();
                boolean newestVersion = entry.getValue();
                this.pageEntryNode.addChild("div").addChild(this.termPageEntryNode(termPageEntry, newestVersion));
                ++results;
            }
        }
        this.pageEntryNode.addChild("p").addChild("span", "class", "librarian-summary-found", "Found " + results + " results");
    }

    private HTMLNode termPageEntryNode(TermPageEntry entry, boolean newestVersion) {
        FreenetURI uri = entry.page;
        String showtitle = entry.title;
        String showurl = uri.toShortString();
        if (showtitle == null || showtitle.trim().length() == 0) {
            showtitle = showurl;
        }
        String realurl = "/" + uri.toString();
        HTMLNode pageNode = new HTMLNode("div", new String[]{"class", "style"}, new String[]{"result-entry", ""});
        pageNode.addChild("a", new String[]{"href", "class", "title"}, new String[]{realurl, newestVersion ? "result-title-new" : "result-title-old", entry.rel > 0.0f ? "Relevance : " + entry.rel * 100.0f + "%" : "Relevance unknown"}, showtitle);
        if (uri.isSSKForUSK()) {
            String realuskurl = "/" + uri.uskForSSK().toString();
            pageNode.addChild("a", new String[]{"href", "class", "title"}, new String[]{realuskurl, newestVersion ? "result-uskbutton-new" : "result-uskbutton-old", realuskurl}, "[ USK ]");
        }
        pageNode.addChild("br");
        pageNode.addChild("a", new String[]{"href", "class", "title"}, new String[]{realurl, newestVersion ? "result-url-new" : "result-url-old", uri.toString()}, showurl);
        return pageNode;
    }
}

