/*
 * Decompiled with CFR 0.152.
 */
package plugins.Library.util.exec;

import plugins.Library.util.exec.Progress;
import plugins.Library.util.exec.ProgressParts;
import plugins.Library.util.exec.TaskAbortException;

public class SimpleProgress
implements Progress {
    protected String subject = "??";
    protected String status = null;
    protected volatile int pdone;
    protected volatile int known;
    protected volatile int estimate = -2;
    private boolean inprogress = true;
    private volatile TaskAbortException abort = null;

    public boolean finalizedTotal() {
        return this.estimate == -1;
    }

    public synchronized void addPartDone() {
        if (this.pdone == this.known) {
            throw new IllegalStateException("Can't increased parts done above parts known");
        }
        ++this.pdone;
        if (this.finalizedTotal() && this.pdone == this.known) {
            this.inprogress = false;
            this.notifyAll();
        }
    }

    public synchronized void addPartKnown(int parts, boolean finalise) {
        if (parts < 0) {
            throw new IllegalArgumentException("Can't decrease the number of parts done.");
        }
        if (finalise) {
            if (this.finalizedTotal() && parts > 0) {
                throw new IllegalArgumentException("Total already finalised");
            }
            this.known = this.estimate = this.known + parts;
            this.estimate = -1;
        } else {
            if (this.finalizedTotal()) {
                throw new IllegalArgumentException("Cannot un-finalise a final total!");
            }
            this.estimate = -2;
            this.known += parts;
        }
    }

    public synchronized void setEstimate(int e) {
        if (e < this.known) {
            throw new IllegalArgumentException("Can't give a lower estimate than what is already known.");
        }
        this.estimate = e;
    }

    public void enteredSerialiser() {
        this.addPartKnown(1, false);
    }

    public void exitingSerialiser() {
        this.addPartDone();
    }

    public synchronized void abort(TaskAbortException e) throws TaskAbortException {
        this.abort = e;
        this.inprogress = false;
        this.notifyAll();
        throw e;
    }

    public void setSubject(String s) {
        if (s == null) {
            throw new IllegalArgumentException("Can't set a null progress subject");
        }
        this.subject = s;
    }

    public void setStatus(String s) {
        this.status = s;
    }

    public void setStatusDefault() {
        this.status = null;
    }

    @Override
    public String getSubject() {
        return this.subject;
    }

    @Override
    public String getStatus() {
        if (this.abort != null) {
            return this.abort.getMessage();
        }
        if (this.status != null) {
            return this.status;
        }
        try {
            return this.getParts().toString();
        }
        catch (TaskAbortException e) {
            return this.abort.getMessage();
        }
    }

    @Override
    public ProgressParts getParts() throws TaskAbortException {
        if (this.abort != null) {
            throw new TaskAbortException("Task failed", this.abort);
        }
        return new ProgressParts(this.pdone, this.known, this.known, this.estimate);
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Override
    public boolean isDone() throws TaskAbortException {
        if (this.abort != null) {
            throw new TaskAbortException("Task failed", this.abort);
        }
        return this.finalizedTotal() && this.pdone == this.known;
    }

    @Override
    public synchronized void join() throws InterruptedException, TaskAbortException {
        while (this.inprogress) {
            this.wait();
        }
        if (this.abort != null) {
            throw new TaskAbortException("Task failed", this.abort);
        }
    }
}

