/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.KeyGenUtils;
import freenet.crypt.KeyType;
import java.io.Serializable;
import java.security.InvalidKeyException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

public final class MasterSecret
implements Serializable {
    private static final long serialVersionUID = -8411217325990445764L;
    private final SecretKey masterKey;

    public MasterSecret() {
        this.masterKey = KeyGenUtils.genSecretKey(KeyType.HMACSHA512);
    }

    public MasterSecret(byte[] secret) {
        if (secret.length != 64) {
            throw new IllegalArgumentException();
        }
        this.masterKey = KeyGenUtils.getSecretKey(KeyType.HMACSHA512, secret);
    }

    public SecretKey deriveKey(KeyType type) {
        try {
            return KeyGenUtils.deriveSecretKey(this.masterKey, this.getClass(), type.name() + " key", type);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
    }

    public IvParameterSpec deriveIv(KeyType type) {
        try {
            return KeyGenUtils.deriveIvParameterSpec(this.masterKey, this.getClass(), type.name() + " iv", type);
        }
        catch (InvalidKeyException e) {
            throw new IllegalStateException(e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.masterKey == null ? 0 : this.masterKey.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MasterSecret other = (MasterSecret)obj;
        return this.masterKey.equals(other.masterKey);
    }
}

