/*
 * Decompiled with CFR 0.152.
 */
package freenet.io.xfer;

import freenet.io.xfer.AbortedException;
import freenet.support.Buffer;
import freenet.support.LogThresholdCallback;
import freenet.support.Logger;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;

public class PartiallyReceivedBlock {
    private static volatile boolean logMINOR;
    private static volatile boolean logDEBUG;
    byte[] _data;
    boolean[] _received;
    int _receivedCount;
    public final int _packets;
    public final int _packetSize;
    boolean _aborted;
    boolean _abortedLocally;
    int _abortReason;
    String _abortDescription;
    ArrayList<PacketReceivedListener> _packetReceivedListeners = new ArrayList();

    public PartiallyReceivedBlock(int packets, int packetSize, byte[] data) {
        if (data.length != packets * packetSize) {
            throw new RuntimeException("Length of data (" + data.length + ") doesn't match packet number and size");
        }
        this._data = data;
        this._received = new boolean[packets];
        for (int x = 0; x < this._received.length; ++x) {
            this._received[x] = true;
        }
        this._receivedCount = packets;
        this._packets = packets;
        this._packetSize = packetSize;
    }

    public PartiallyReceivedBlock(int packets, int packetSize) {
        this._data = new byte[packets * packetSize];
        this._received = new boolean[packets];
        this._packets = packets;
        this._packetSize = packetSize;
    }

    public synchronized Deque<Integer> addListener(PacketReceivedListener listener) throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("Adding listener to aborted PRB");
        }
        this._packetReceivedListeners.add(listener);
        LinkedList<Integer> ret = new LinkedList<Integer>();
        for (int x = 0; x < this._packets; ++x) {
            if (!this._received[x]) continue;
            ret.addLast(x);
        }
        return ret;
    }

    public synchronized boolean isReceived(int packetNo) throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        return this._received[packetNo];
    }

    public synchronized int getNumPackets() throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        return this._packets;
    }

    public synchronized int getPacketSize() throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        return this._packetSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPacket(int position, Buffer packet) throws AbortedException {
        PacketReceivedListener[] packetReceivedListenerArray = this;
        synchronized (this) {
            if (this._aborted) {
                throw new AbortedException("PRB is aborted");
            }
            if (packet.getLength() != this._packetSize) {
                throw new RuntimeException("New packet size " + packet.getLength() + " but expecting packet of size " + this._packetSize);
            }
            if (this._received[position]) {
                // ** MonitorExit[var4_3] (shouldn't be in output)
                return;
            }
            ++this._receivedCount;
            packet.copyTo(this._data, position * this._packetSize);
            this._received[position] = true;
            PacketReceivedListener[] prls = this._packetReceivedListeners.toArray(new PacketReceivedListener[this._packetReceivedListeners.size()]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (PacketReceivedListener prl : prls) {
                prl.packetReceived(position);
            }
            return;
        }
    }

    public synchronized boolean allReceivedAndNotAborted() {
        return this._receivedCount == this._packets && !this._aborted;
    }

    public synchronized boolean allReceived() throws AbortedException {
        if (this._receivedCount == this._packets) {
            if (logDEBUG) {
                Logger.debug(this, "Received " + this._receivedCount + " of " + this._packets + " on " + this);
            }
            return true;
        }
        if (this._aborted) {
            throw new AbortedException("PRB is aborted: " + this._abortReason + " : " + this._abortDescription + " received " + this._receivedCount + " of " + this._packets + " on " + this);
        }
        return false;
    }

    public synchronized byte[] getBlock() throws AbortedException {
        if (this.allReceived()) {
            return this._data;
        }
        throw new RuntimeException("Tried to get block before all packets received");
    }

    public synchronized Buffer getPacket(int x) throws AbortedException {
        if (this._aborted) {
            throw new AbortedException("PRB is aborted");
        }
        if (!this._received[x]) {
            throw new IllegalStateException("that packet is not received");
        }
        return new Buffer(this._data, x * this._packetSize, this._packetSize);
    }

    public synchronized void removeListener(PacketReceivedListener listener) {
        this._packetReceivedListeners.remove(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] abort(int reason, String description, boolean cancelledLocally) {
        PacketReceivedListener[] packetReceivedListenerArray = this;
        synchronized (this) {
            if (this._aborted) {
                if (logMINOR) {
                    Logger.minor(this, "Already aborted " + this + " : reason=" + this._abortReason + " description=" + this._abortDescription);
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return null;
            }
            if (this._receivedCount == this._packets) {
                if (logMINOR) {
                    Logger.minor(this, "Already received");
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return this._data;
            }
            Logger.normal(this, "Aborting PRB: " + reason + " : " + description + " on " + this, (Throwable)new Exception("debug"));
            this._aborted = true;
            this._abortedLocally = cancelledLocally;
            this._abortReason = reason;
            this._abortDescription = description;
            PacketReceivedListener[] listeners = this._packetReceivedListeners.toArray(new PacketReceivedListener[this._packetReceivedListeners.size()]);
            this._packetReceivedListeners.clear();
            // ** MonitorExit[var5_4] (shouldn't be in output)
            for (PacketReceivedListener prl : listeners) {
                prl.receiveAborted(reason, description);
            }
            return null;
        }
    }

    public synchronized boolean isAborted() {
        return this._aborted;
    }

    public synchronized int getAbortReason() {
        return this._abortReason;
    }

    public synchronized String getAbortDescription() {
        return this._abortDescription;
    }

    public boolean abortedLocally() {
        return this._abortedLocally;
    }

    static {
        Logger.registerLogThresholdCallback(new LogThresholdCallback(){

            @Override
            public void shouldUpdate() {
                logMINOR = Logger.shouldLog(Logger.LogLevel.MINOR, (Object)this);
                logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, (Object)this);
            }
        });
    }

    public static interface PacketReceivedListener {
        public void packetReceived(int var1);

        public void receiveAborted(int var1, String var2);
    }
}

