/*
 * Decompiled with CFR 0.152.
 */
package freenet.node.stats;

import freenet.node.stats.DataStoreStats;
import freenet.node.stats.StatsNotAvailableException;
import freenet.node.stats.StoreAccessStats;
import freenet.node.stats.StoreLocationStats;
import freenet.store.StoreCallback;

public class StoreCallbackStats
implements DataStoreStats {
    private final StoreCallback<?> storeStats;
    private final StoreLocationStats nodeStats;
    public final StoreAccessStats sessionAccessStats;
    public final StoreAccessStats totalAccessStats;

    public StoreCallbackStats(StoreCallback<?> delegate, StoreLocationStats nodeStats) {
        this.storeStats = delegate;
        this.nodeStats = nodeStats;
        this.sessionAccessStats = delegate.getSessionAccessStats();
        this.totalAccessStats = delegate.getTotalAccessStats();
    }

    @Override
    public long keys() {
        return this.storeStats.keyCount();
    }

    @Override
    public long capacity() {
        return this.storeStats.getMaxKeys();
    }

    @Override
    public long dataSize() {
        return this.keys() * (long)this.storeStats.dataLength();
    }

    @Override
    public double avgLocation() throws StatsNotAvailableException {
        return this.nodeStats.avgLocation();
    }

    @Override
    public double utilization() {
        return 1.0 * (double)this.keys() / (double)this.capacity();
    }

    @Override
    public double avgSuccess() throws StatsNotAvailableException {
        return this.nodeStats.avgSuccess();
    }

    @Override
    public double furthestSuccess() throws StatsNotAvailableException {
        return this.nodeStats.furthestSuccess();
    }

    @Override
    public double avgDist() throws StatsNotAvailableException {
        return this.nodeStats.avgDist();
    }

    @Override
    public double distanceStats() throws StatsNotAvailableException {
        return this.nodeStats.distanceStats();
    }

    @Override
    public StoreAccessStats getSessionAccessStats() {
        return this.sessionAccessStats;
    }

    @Override
    public StoreAccessStats getTotalAccessStats() throws StatsNotAvailableException {
        if (this.totalAccessStats == null) {
            throw new StatsNotAvailableException();
        }
        return this.totalAccessStats;
    }
}

