/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Logger;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.BitSet;

public class HexUtil {
    private static final boolean logDEBUG = Logger.shouldLog(Logger.LogLevel.DEBUG, HexUtil.class);

    private HexUtil() {
    }

    public static final String bytesToHex(byte[] bs, int off, int length) {
        if (bs.length < off + length) {
            throw new IllegalArgumentException("Total length: " + bs.length + ", offset: " + off + ", length: " + length);
        }
        StringBuilder sb = new StringBuilder(length * 2);
        HexUtil.bytesToHexAppend(bs, off, length, sb);
        return sb.toString();
    }

    public static void bytesToHexAppend(byte[] bs, int off, int length, StringBuilder sb) {
        if (bs.length < off + length) {
            throw new IllegalArgumentException();
        }
        sb.ensureCapacity(sb.length() + length * 2);
        for (int i = off; i < off + length; ++i) {
            sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(bs[i] & 0xF, 16));
        }
    }

    public static String bytesToHex(byte[] bs) {
        return HexUtil.bytesToHex(bs, 0, bs.length);
    }

    public static byte[] hexToBytes(String s) {
        return HexUtil.hexToBytes(s, 0);
    }

    public static byte[] hexToBytes(String s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        HexUtil.hexToBytes(s, bs, off);
        return bs;
    }

    public static void hexToBytes(String s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        int slen = s.length();
        if (slen % 2 != 0) {
            s = '0' + s;
        }
        if (out.length < off + slen / 2) {
            throw new IndexOutOfBoundsException("Output buffer too small for input (" + out.length + '<' + off + slen / 2 + ')');
        }
        for (int i = 0; i < slen; i += 2) {
            byte b1 = (byte)Character.digit(s.charAt(i), 16);
            byte b2 = (byte)Character.digit(s.charAt(i + 1), 16);
            if (b1 < 0 || b2 < 0) {
                throw new NumberFormatException();
            }
            out[off + i / 2] = (byte)(b1 << 4 | b2);
        }
    }

    public static byte[] bitsToBytes(BitSet ba, int size) {
        int bytesAlloc = HexUtil.countBytesForBits(size);
        byte[] b = new byte[bytesAlloc];
        StringBuilder sb = null;
        if (logDEBUG) {
            sb = new StringBuilder(8 * bytesAlloc);
        }
        for (int i = 0; i < b.length; ++i) {
            int s = 0;
            for (int j = 0; j < 8; ++j) {
                int idx = i * 8 + j;
                boolean val = idx > size - 1 ? false : ba.get(idx);
                s = (short)(s | (val ? 1 << j : 0));
                if (!logDEBUG) continue;
                sb.append(val ? (char)'1' : '0');
            }
            if (s > 255) {
                throw new IllegalStateException("WTF? s = " + s);
            }
            b[i] = (byte)s;
        }
        if (logDEBUG) {
            Logger.debug(HexUtil.class, "bytes: " + bytesAlloc + " returned from bitsToBytes(" + ba + ',' + size + "): " + HexUtil.bytesToHex(b) + " for " + sb.toString());
        }
        return b;
    }

    public static String bitsToHexString(BitSet ba, int size) {
        return HexUtil.bytesToHex(HexUtil.bitsToBytes(ba, size));
    }

    public static String toHexString(BigInteger i) {
        return HexUtil.bytesToHex(i.toByteArray());
    }

    public static int countBytesForBits(int size) {
        return (size + 7) / 8;
    }

    public static void bytesToBits(byte[] b, BitSet ba, int maxSize) {
        if (logDEBUG) {
            Logger.debug(HexUtil.class, "bytesToBits(" + HexUtil.bytesToHex(b) + ",ba," + maxSize);
        }
        int x = 0;
        for (byte bi : b) {
            for (int j = 0; j < 8 && x <= maxSize; ++x, ++j) {
                int mask = 1 << j;
                boolean value = (mask & bi) != 0;
                ba.set(x, value);
            }
        }
    }

    public static void hexToBits(String s, BitSet ba, int length) {
        byte[] b = HexUtil.hexToBytes(s);
        HexUtil.bytesToBits(b, ba, length);
    }

    public static void writeBigInteger(BigInteger integer, DataOutputStream out) throws IOException {
        if (integer.signum() == -1) {
            throw new IllegalStateException("Negative BigInteger!");
        }
        byte[] buf = integer.toByteArray();
        if (buf.length > Short.MAX_VALUE) {
            throw new IllegalStateException("Too long: " + buf.length);
        }
        out.writeShort((short)buf.length);
        out.write(buf);
    }

    public static BigInteger readBigInteger(DataInputStream dis) throws IOException {
        short i = dis.readShort();
        if (i < 0) {
            throw new IOException("Invalid BigInteger length: " + i);
        }
        byte[] buf = new byte[i];
        dis.readFully(buf);
        return new BigInteger(1, buf);
    }

    public static String biToHex(BigInteger bi) {
        return HexUtil.bytesToHex(bi.toByteArray());
    }
}

