/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.maven;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.result.AttributeContainerSerializer;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.internal.component.external.descriptor.Configuration;
import org.gradle.internal.component.external.descriptor.MavenScope;
import org.gradle.internal.component.external.model.AbstractRealisedModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.AbstractRealisedModuleResolveMetadataSerializationHelper;
import org.gradle.internal.component.external.model.ComponentVariant;
import org.gradle.internal.component.external.model.ConfigurationBoundExternalDependencyMetadata;
import org.gradle.internal.component.external.model.ExternalDependencyDescriptor;
import org.gradle.internal.component.external.model.GradleDependencyMetadata;
import org.gradle.internal.component.external.model.ImmutableCapabilities;
import org.gradle.internal.component.external.model.LazyToRealisedModuleComponentResolveMetadataHelper;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.external.model.ModuleDependencyMetadata;
import org.gradle.internal.component.external.model.RealisedConfigurationMetadata;
import org.gradle.internal.component.external.model.maven.DefaultMavenModuleResolveMetadata;
import org.gradle.internal.component.external.model.maven.MavenDependencyDescriptor;
import org.gradle.internal.component.external.model.maven.RealisedMavenModuleResolveMetadata;
import org.gradle.internal.component.model.ConfigurationMetadata;
import org.gradle.internal.component.model.DependencyMetadata;
import org.gradle.internal.component.model.ExcludeMetadata;
import org.gradle.internal.component.model.IvyArtifactName;
import org.gradle.internal.serialize.Decoder;
import org.gradle.internal.serialize.Encoder;

public class RealisedMavenModuleResolveMetadataSerializationHelper
extends AbstractRealisedModuleResolveMetadataSerializationHelper {
    private static final String COMPILE_DERIVED_VARIANT_NAME = "compile___derived";
    private static final String RUNTIME_DERIVED_VARIANT_NAME = "runtime___derived";

    public RealisedMavenModuleResolveMetadataSerializationHelper(AttributeContainerSerializer attributeContainerSerializer, ImmutableModuleIdentifierFactory moduleIdentifierFactory) {
        super(attributeContainerSerializer, moduleIdentifierFactory);
    }

    @Override
    public void writeRealisedConfigurationsData(Encoder encoder, AbstractRealisedModuleComponentResolveMetadata transformed) throws IOException {
        if (transformed instanceof RealisedMavenModuleResolveMetadata) {
            this.writeDerivedVariants(encoder, (RealisedMavenModuleResolveMetadata)transformed);
        }
        super.writeRealisedConfigurationsData(encoder, transformed);
    }

    public ModuleComponentResolveMetadata readMetadata(Decoder decoder, DefaultMavenModuleResolveMetadata resolveMetadata) throws IOException {
        Map<String, List<GradleDependencyMetadata>> variantToDependencies = this.readVariantDependencies(decoder);
        ImmutableList variants = resolveMetadata.getVariants();
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ComponentVariant variant : variants) {
            builder.add((Object)new AbstractRealisedModuleComponentResolveMetadata.ImmutableRealisedVariantImpl(resolveMetadata.getId(), variant.getName(), variant.getAttributes().asImmutable(), variant.getDependencies(), variant.getDependencyConstraints(), variant.getFiles(), ImmutableCapabilities.of(variant.getCapabilities().getCapabilities()), variantToDependencies.get(variant.getName())));
        }
        ImmutableList realisedVariants = builder.build();
        Map<String, ConfigurationMetadata> configurations = this.readMavenConfigurationsAndDerivedVariants(decoder, resolveMetadata);
        ArrayList derivedVariants = Lists.newArrayListWithCapacity((int)2);
        this.addDerivedVariant(configurations, derivedVariants, COMPILE_DERIVED_VARIANT_NAME);
        this.addDerivedVariant(configurations, derivedVariants, RUNTIME_DERIVED_VARIANT_NAME);
        return new RealisedMavenModuleResolveMetadata(resolveMetadata, (ImmutableList<? extends ComponentVariant>)realisedVariants, derivedVariants, configurations);
    }

    @Override
    protected void writeDependencies(Encoder encoder, ConfigurationMetadata configuration) throws IOException {
        List<? extends DependencyMetadata> dependencies = configuration.getDependencies();
        encoder.writeSmallInt(dependencies.size());
        for (DependencyMetadata dependencyMetadata : dependencies) {
            if (dependencyMetadata instanceof GradleDependencyMetadata) {
                encoder.writeByte((byte)1);
                this.writeDependencyMetadata(encoder, (GradleDependencyMetadata)dependencyMetadata);
                continue;
            }
            if (!(dependencyMetadata instanceof ConfigurationBoundExternalDependencyMetadata)) continue;
            ConfigurationBoundExternalDependencyMetadata dependencyMetadata2 = (ConfigurationBoundExternalDependencyMetadata)dependencyMetadata;
            ExternalDependencyDescriptor dependencyDescriptor = dependencyMetadata2.getDependencyDescriptor();
            if (!(dependencyDescriptor instanceof MavenDependencyDescriptor)) {
                throw new IllegalStateException("Unknown type of dependency descriptor: " + dependencyDescriptor.getClass());
            }
            encoder.writeByte((byte)2);
            this.writeMavenDependency(encoder, (MavenDependencyDescriptor)dependencyDescriptor);
            encoder.writeNullableString((CharSequence)dependencyMetadata.getReason());
        }
    }

    private void writeDerivedVariants(Encoder encoder, RealisedMavenModuleResolveMetadata metadata) throws IOException {
        encoder.writeBoolean(!metadata.getDerivedVariants().isEmpty());
    }

    private Map<String, ConfigurationMetadata> readMavenConfigurationsAndDerivedVariants(Decoder decoder, DefaultMavenModuleResolveMetadata metadata) throws IOException {
        ImmutableMap<String, Configuration> configurationDefinitions = metadata.getConfigurationDefinitions();
        boolean derivedVariants = decoder.readBoolean();
        int configurationsCount = decoder.readSmallInt();
        HashMap configurations = Maps.newHashMapWithExpectedSize((int)configurationsCount);
        for (int i = 0; i < configurationsCount; ++i) {
            String configurationName = decoder.readString();
            Configuration configuration = (Configuration)configurationDefinitions.get((Object)configurationName);
            ImmutableList<String> hierarchy = LazyToRealisedModuleComponentResolveMetadataHelper.constructHierarchy(configuration, configurationDefinitions);
            ImmutableAttributes attributes = this.getAttributeContainerSerializer().read(decoder);
            ImmutableCapabilities capabilities = this.readCapabilities(decoder);
            RealisedConfigurationMetadata configurationMetadata = new RealisedConfigurationMetadata(metadata.getId(), configurationName, configuration.isTransitive(), configuration.isVisible(), hierarchy, RealisedMavenModuleResolveMetadata.getArtifactsForConfiguration(metadata.getId(), configurationName), (ImmutableList<ExcludeMetadata>)ImmutableList.of(), attributes, capabilities);
            ImmutableList.Builder builder = ImmutableList.builder();
            int dependenciesCount = decoder.readSmallInt();
            block6: for (int j = 0; j < dependenciesCount; ++j) {
                byte dependencyType = decoder.readByte();
                switch (dependencyType) {
                    case 1: {
                        builder.add((Object)this.readDependencyMetadata(decoder));
                        continue block6;
                    }
                    case 2: {
                        MavenDependencyDescriptor mavenDependencyDescriptor = this.readMavenDependency(decoder);
                        ModuleDependencyMetadata dependencyMetadata = RealisedMavenModuleResolveMetadata.contextualize(configurationMetadata, metadata.getId(), mavenDependencyDescriptor, metadata.isImprovedPomSupportEnabled());
                        builder.add((Object)dependencyMetadata.withReason(decoder.readNullableString()));
                        continue block6;
                    }
                    case 3: {
                        throw new IllegalStateException("Unexpected Ivy dependency for Maven module");
                    }
                    default: {
                        throw new IllegalStateException("Unknown dependency type " + dependencyType);
                    }
                }
            }
            ImmutableList dependencies = builder.build();
            configurationMetadata.setDependencies((List<ModuleDependencyMetadata>)dependencies);
            configurations.put(configurationName, configurationMetadata);
            if (!derivedVariants) continue;
            if (configurationName.equals("compile")) {
                ConfigurationMetadata compileDerivedVariant = RealisedMavenModuleResolveMetadata.withUsageAttribute(configurationMetadata, "java-api", metadata.getAttributesFactory(), attributes, metadata.getObjectInstantiator());
                configurations.put(COMPILE_DERIVED_VARIANT_NAME, compileDerivedVariant);
                continue;
            }
            if (!configurationName.equals("runtime")) continue;
            ConfigurationMetadata runtimeDerivedVariant = RealisedMavenModuleResolveMetadata.withUsageAttribute(configurationMetadata, "java-runtime", metadata.getAttributesFactory(), attributes, metadata.getObjectInstantiator());
            configurations.put(RUNTIME_DERIVED_VARIANT_NAME, runtimeDerivedVariant);
        }
        return configurations;
    }

    private void addDerivedVariant(Map<String, ConfigurationMetadata> configurations, List<ConfigurationMetadata> derivedVariants, String name) {
        ConfigurationMetadata configurationMetadata = configurations.remove(name);
        if (configurationMetadata != null) {
            derivedVariants.add(configurationMetadata);
        }
    }

    private MavenDependencyDescriptor readMavenDependency(Decoder decoder) throws IOException {
        ModuleComponentSelector requested = this.getComponentSelectorSerializer().read(decoder);
        IvyArtifactName artifactName = this.readNullableArtifact(decoder);
        List<ExcludeMetadata> mavenExcludes = this.readMavenExcludes(decoder);
        MavenScope scope = MavenScope.values()[decoder.readSmallInt()];
        boolean optional = decoder.readBoolean();
        return new MavenDependencyDescriptor(scope, optional, requested, artifactName, mavenExcludes);
    }

    private void writeMavenDependency(Encoder encoder, MavenDependencyDescriptor mavenDependency) throws IOException {
        this.getComponentSelectorSerializer().write(encoder, mavenDependency.getSelector());
        this.writeNullableArtifact(encoder, mavenDependency.getDependencyArtifact());
        this.writeMavenExcludeRules(encoder, mavenDependency.getAllExcludes());
        encoder.writeSmallInt(mavenDependency.getScope().ordinal());
        encoder.writeBoolean(mavenDependency.isOptional());
    }
}

