/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.compile.processing;

import java.util.Set;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.gradle.api.internal.tasks.compile.incremental.processing.AnnotationProcessingResult;
import org.gradle.api.internal.tasks.compile.processing.ElementUtils;
import org.gradle.api.internal.tasks.compile.processing.IncrementalProcessingStrategy;

class IsolatingProcessingStrategy
extends IncrementalProcessingStrategy {
    private final AnnotationProcessingResult result;

    IsolatingProcessingStrategy(AnnotationProcessingResult result) {
        super(result);
        this.result = result;
    }

    @Override
    public void recordProcessingInputs(Set<String> supportedAnnotationTypes, Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
    }

    @Override
    public void recordGeneratedType(CharSequence name, Element[] originatingElements) {
        String generatedType = name.toString();
        Set<String> originatingTypes = ElementUtils.getTopLevelTypeNames(originatingElements);
        int size = originatingTypes.size();
        if (size != 1) {
            this.result.setFullRebuildCause("the generated type '" + generatedType + "' must have exactly one originating element, but had " + size);
        }
        this.result.addGeneratedType(generatedType, originatingTypes);
    }
}

