/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.health;

import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationResult;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStatus;
import org.gradle.launcher.daemon.server.expiry.DaemonExpirationStrategy;
import org.gradle.launcher.daemon.server.health.DaemonMemoryStatus;

public class LowTenuredSpaceDaemonExpirationStrategy
implements DaemonExpirationStrategy {
    private final DaemonMemoryStatus status;
    private static final Logger LOG = Logging.getLogger(LowTenuredSpaceDaemonExpirationStrategy.class);
    public static final String EXPIRATION_REASON = "after running out of JVM memory";
    public static final String EXPIRE_DAEMON_MESSAGE = "Expiring Daemon because JVM Tenured space is exhausted";

    public LowTenuredSpaceDaemonExpirationStrategy(DaemonMemoryStatus status) {
        this.status = status;
    }

    @Override
    public DaemonExpirationResult checkExpiration() {
        if (this.status.isTenuredSpaceExhausted()) {
            LOG.warn(EXPIRE_DAEMON_MESSAGE);
            return new DaemonExpirationResult(DaemonExpirationStatus.GRACEFUL_EXPIRE, EXPIRATION_REASON);
        }
        return DaemonExpirationResult.NOT_TRIGGERED;
    }
}

