/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.filter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class TestSelectionMatcher {
    private final List<TestPattern> buildScriptIncludePatterns;
    private final List<TestPattern> commandLineIncludePatterns;

    public TestSelectionMatcher(Collection<String> includedTests, Collection<String> includedTestsCommandLine) {
        this.buildScriptIncludePatterns = this.preparePatternList(includedTests);
        this.commandLineIncludePatterns = this.preparePatternList(includedTestsCommandLine);
    }

    private List<TestPattern> preparePatternList(Collection<String> includedTests) {
        ArrayList<TestPattern> includePatterns = new ArrayList<TestPattern>(includedTests.size());
        for (String includedTest : includedTests) {
            includePatterns.add(new TestPattern(includedTest));
        }
        return includePatterns;
    }

    public boolean matchesTest(String className, String methodName) {
        return this.matchesPattern(this.buildScriptIncludePatterns, className, methodName) && this.matchesPattern(this.commandLineIncludePatterns, className, methodName);
    }

    public boolean mayIncludeClass(String fullQualifiedClassName) {
        return this.mayIncludeClass(this.buildScriptIncludePatterns, fullQualifiedClassName) && this.mayIncludeClass(this.commandLineIncludePatterns, fullQualifiedClassName);
    }

    private boolean mayIncludeClass(List<TestPattern> includePatterns, String fullQualifiedName) {
        if (includePatterns.isEmpty()) {
            return true;
        }
        for (TestPattern pattern : includePatterns) {
            if (!pattern.mayIncludeClass(fullQualifiedName)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesPattern(List<TestPattern> includePatterns, String fullQualifiedName, String methodName) {
        if (includePatterns.isEmpty()) {
            return true;
        }
        for (TestPattern pattern : includePatterns) {
            if (pattern.matchesClassAndMethod(fullQualifiedName, methodName)) {
                return true;
            }
            if (!pattern.matchesClass(fullQualifiedName)) continue;
            return true;
        }
        return false;
    }

    private static String getSimpleName(String fullQualifiedName) {
        String simpleName = StringUtils.substringAfterLast((String)fullQualifiedName, (String)".");
        if ("".equals(simpleName)) {
            return fullQualifiedName;
        }
        return simpleName;
    }

    private static class SimpleClassNameSelector
    implements ClassNameSelector {
        private SimpleClassNameSelector() {
        }

        @Override
        public String determineTargetClassName(String fullQualifiedName) {
            return TestSelectionMatcher.getSimpleName(fullQualifiedName);
        }
    }

    private static class FullQualifiedClassNameSelector
    implements ClassNameSelector {
        private FullQualifiedClassNameSelector() {
        }

        @Override
        public String determineTargetClassName(String fullQualifiedName) {
            return fullQualifiedName;
        }
    }

    private static interface ClassNameSelector {
        public String determineTargetClassName(String var1);
    }

    private static class WildcardMatcher
    implements LastElementMatcher {
        private WildcardMatcher() {
        }

        @Override
        public boolean match(String classElement, String patternElement) {
            return classElement.startsWith(patternElement);
        }
    }

    private static class NoWildcardMatcher
    implements LastElementMatcher {
        private NoWildcardMatcher() {
        }

        @Override
        public boolean match(String classElement, String patternElement) {
            return classElement.equals(patternElement);
        }
    }

    private static interface LastElementMatcher {
        public boolean match(String var1, String var2);
    }

    private static class TestPattern {
        private Pattern pattern;
        private String[] segments;
        private LastElementMatcher lastElementMatcher;
        private ClassNameSelector classNameSelector;

        private TestPattern(String pattern) {
            this.pattern = TestPattern.preparePattern(pattern);
            this.classNameSelector = this.patternStartsWithUpperCase(pattern) ? new SimpleClassNameSelector() : new FullQualifiedClassNameSelector();
            int firstWildcardIndex = pattern.indexOf(42);
            if (firstWildcardIndex == -1) {
                this.segments = StringUtils.splitPreserveAllTokens((String)pattern, (char)'.');
                this.lastElementMatcher = new NoWildcardMatcher();
            } else {
                this.segments = StringUtils.splitPreserveAllTokens((String)pattern.substring(0, firstWildcardIndex), (char)'.');
                this.lastElementMatcher = new WildcardMatcher();
            }
        }

        private static Pattern preparePattern(String input) {
            String[] split;
            StringBuilder pattern = new StringBuilder();
            for (String s : split = StringUtils.splitPreserveAllTokens((String)input, (char)'*')) {
                if (s.equals("")) {
                    pattern.append(".*");
                    continue;
                }
                if (pattern.length() > 0) {
                    pattern.append(".*");
                }
                pattern.append(Pattern.quote(s));
            }
            return Pattern.compile(pattern.toString());
        }

        private boolean mayIncludeClass(String fullQualifiedName) {
            if (this.patternStartsWithWildcard()) {
                return true;
            }
            String[] classNameArray = this.classNameSelector.determineTargetClassName(fullQualifiedName).split("\\.");
            if (this.classNameIsShorterThanPattern(classNameArray)) {
                return false;
            }
            for (int i = 0; i < this.segments.length; ++i) {
                if (this.lastClassNameElementMatchesPenultimatePatternElement(classNameArray, i)) {
                    return true;
                }
                if (this.lastClassNameElementMatchesLastPatternElement(classNameArray, i)) {
                    return true;
                }
                if (classNameArray[i].equals(this.segments[i])) continue;
                return false;
            }
            return false;
        }

        private boolean matchesClass(String fullQualifiedName) {
            return this.pattern.matcher(this.classNameSelector.determineTargetClassName(fullQualifiedName)).matches();
        }

        private boolean matchesClassAndMethod(String fullQualifiedName, String methodName) {
            if (methodName == null) {
                return false;
            }
            return this.pattern.matcher(this.classNameSelector.determineTargetClassName(fullQualifiedName) + "." + methodName).matches();
        }

        private boolean lastClassNameElementMatchesPenultimatePatternElement(String[] className, int index) {
            return index == this.segments.length - 2 && index == className.length - 1 && className[index].equals(this.segments[index]);
        }

        private boolean lastClassNameElementMatchesLastPatternElement(String[] className, int index) {
            return index == this.segments.length - 1 && this.lastElementMatcher.match(className[index], this.segments[index]);
        }

        private boolean patternStartsWithWildcard() {
            return this.segments.length == 0;
        }

        private boolean classNameIsShorterThanPattern(String[] classNameArray) {
            return classNameArray.length < this.segments.length - 1;
        }

        private boolean patternStartsWithUpperCase(String pattern) {
            return pattern.length() > 0 && Character.isUpperCase(pattern.charAt(0));
        }
    }
}

