/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.nativeplatform.test.cpp.plugins;

import java.util.Set;
import java.util.concurrent.Callable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.Usage;
import org.gradle.api.file.Directory;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributesFactory;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.language.cpp.CppApplication;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.cpp.CppPlatform;
import org.gradle.language.cpp.ProductionCppComponent;
import org.gradle.language.cpp.internal.DefaultCppBinary;
import org.gradle.language.cpp.internal.DefaultUsageContext;
import org.gradle.language.cpp.internal.NativeVariantIdentity;
import org.gradle.language.cpp.plugins.CppBasePlugin;
import org.gradle.language.internal.NativeComponentFactory;
import org.gradle.language.nativeplatform.internal.toolchains.ToolChainSelector;
import org.gradle.language.swift.tasks.UnexportMainSymbol;
import org.gradle.nativeplatform.OperatingSystemFamily;
import org.gradle.nativeplatform.platform.internal.DefaultNativePlatform;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestExecutable;
import org.gradle.nativeplatform.test.cpp.CppTestSuite;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestExecutable;
import org.gradle.nativeplatform.test.cpp.internal.DefaultCppTestSuite;
import org.gradle.nativeplatform.test.plugins.NativeTestingBasePlugin;
import org.gradle.nativeplatform.test.tasks.RunTestExecutable;
import org.gradle.util.CollectionUtils;

@Incubating
public class CppUnitTestPlugin
implements Plugin<ProjectInternal> {
    private final NativeComponentFactory componentFactory;
    private final ToolChainSelector toolChainSelector;
    private final ObjectFactory objectFactory;
    private final ImmutableAttributesFactory attributesFactory;

    @Inject
    public CppUnitTestPlugin(NativeComponentFactory componentFactory, ToolChainSelector toolChainSelector, ObjectFactory objectFactory, ImmutableAttributesFactory attributesFactory) {
        this.componentFactory = componentFactory;
        this.toolChainSelector = toolChainSelector;
        this.objectFactory = objectFactory;
        this.attributesFactory = attributesFactory;
    }

    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(CppBasePlugin.class);
        project.getPluginManager().apply(NativeTestingBasePlugin.class);
        final DefaultCppTestSuite testComponent = (DefaultCppTestSuite)this.componentFactory.newInstance(CppTestSuite.class, DefaultCppTestSuite.class, "test");
        project.getExtensions().add(CppTestSuite.class, "unitTest", (Object)testComponent);
        project.getComponents().add((Object)testComponent);
        testComponent.getBaseName().set((Object)(project.getName() + "Test"));
        project.afterEvaluate((Action)new Action<Project>(){

            public void execute(final Project project) {
                testComponent.getOperatingSystems().lockNow();
                Set operatingSystemFamilies = (Set)testComponent.getOperatingSystems().get();
                if (operatingSystemFamilies.isEmpty()) {
                    throw new IllegalArgumentException("An operating system needs to be specified for the unit test.");
                }
                boolean hasHostOperatingSystem = CollectionUtils.any((Iterable)operatingSystemFamilies, (Spec)new Spec<OperatingSystemFamily>(){

                    public boolean isSatisfiedBy(OperatingSystemFamily element) {
                        return DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName().equals(element.getName());
                    }
                });
                if (hasHostOperatingSystem) {
                    String operatingSystemSuffix = "";
                    OperatingSystemFamily operatingSystem = (OperatingSystemFamily)CppUnitTestPlugin.this.objectFactory.named(OperatingSystemFamily.class, DefaultNativePlatform.getCurrentOperatingSystem().toFamilyName());
                    Usage runtimeUsage = (Usage)CppUnitTestPlugin.this.objectFactory.named(Usage.class, "native-runtime");
                    Provider group = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getGroup().toString();
                        }
                    });
                    Provider version = project.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return project.getVersion().toString();
                        }
                    });
                    AttributeContainerInternal attributesDebug = CppUnitTestPlugin.this.attributesFactory.mutable();
                    attributesDebug.attribute(Usage.USAGE_ATTRIBUTE, (Object)runtimeUsage);
                    attributesDebug.attribute(CppBinary.DEBUGGABLE_ATTRIBUTE, (Object)true);
                    attributesDebug.attribute(CppBinary.OPTIMIZED_ATTRIBUTE, (Object)false);
                    NativeVariantIdentity debugVariant = new NativeVariantIdentity("debug" + operatingSystemSuffix, (Provider)testComponent.getBaseName(), group, version, true, false, operatingSystem, null, (UsageContext)new DefaultUsageContext("debug" + operatingSystemSuffix + "Runtime", runtimeUsage, (AttributeContainer)attributesDebug));
                    ToolChainSelector.Result result = CppUnitTestPlugin.this.toolChainSelector.select(CppPlatform.class);
                    testComponent.addExecutable(debugVariant, (CppPlatform)result.getTargetPlatform(), result.getToolChain(), result.getPlatformToolProvider());
                    final TaskContainer tasks = project.getTasks();
                    final ProductionCppComponent mainComponent = (ProductionCppComponent)project.getComponents().withType(ProductionCppComponent.class).findByName("main");
                    if (mainComponent != null) {
                        testComponent.getTestedComponent().set((Object)mainComponent);
                    }
                    testComponent.getBinaries().whenElementKnown(DefaultCppTestExecutable.class, (Action)new Action<DefaultCppTestExecutable>(){

                        public void execute(final DefaultCppTestExecutable executable) {
                            if (mainComponent != null) {
                                mainComponent.getBinaries().whenElementFinalized((Action)new Action<CppBinary>(){

                                    public void execute(CppBinary testedBinary) {
                                        FileCollection testableObjects;
                                        if (testedBinary != mainComponent.getDevelopmentBinary().get()) {
                                            return;
                                        }
                                        executable.getImplementationDependencies().extendsFrom(new Configuration[]{((DefaultCppBinary)testedBinary).getImplementationDependencies()});
                                        if (mainComponent instanceof CppApplication) {
                                            UnexportMainSymbol unexportMainSymbol = (UnexportMainSymbol)tasks.create("relocateMainForTest", UnexportMainSymbol.class);
                                            unexportMainSymbol.getOutputDirectory().set(project.getLayout().getBuildDirectory().dir("obj/main/for-test"));
                                            unexportMainSymbol.getObjects().from(new Object[]{testedBinary.getObjects()});
                                            testableObjects = unexportMainSymbol.getRelocatedObjects();
                                        } else {
                                            testableObjects = testedBinary.getObjects();
                                        }
                                        Dependency linkDependency = project.getDependencies().create((Object)testableObjects);
                                        executable.getLinkConfiguration().getDependencies().add((Object)linkDependency);
                                    }
                                });
                            }
                            RunTestExecutable testTask = (RunTestExecutable)tasks.create(executable.getNames().getTaskName("run"), RunTestExecutable.class);
                            testTask.setGroup("verification");
                            testTask.setDescription("Executes C++ unit tests.");
                            InstallExecutable installTask = (InstallExecutable)executable.getInstallTask().get();
                            testTask.onlyIf((Spec)new Spec<Task>(){

                                public boolean isSatisfiedBy(Task element) {
                                    return ((Directory)executable.getInstallDirectory().get()).getAsFile().exists();
                                }
                            });
                            testTask.getInputs().dir((Object)executable.getInstallDirectory());
                            testTask.setExecutable(((RegularFile)installTask.getRunScriptFile().get()).getAsFile());
                            testTask.dependsOn(new Object[]{((CppTestExecutable)testComponent.getTestBinary().get()).getInstallDirectory()});
                            testTask.setOutputDir(((Directory)project.getLayout().getBuildDirectory().dir("test-results/" + executable.getNames().getDirName()).get()).getAsFile());
                            executable.getRunTask().set((Object)testTask);
                        }
                    });
                }
                testComponent.getBinaries().realizeNow();
            }
        });
    }
}

